/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferPool;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class BufferPoolTest
extends AbstractOMTest {
    private static IBufferPool bufferPool = Net4jUtil.createBufferPool();
    private static Collection<byte[]> memory = new ArrayList<byte[]>();

    @Override
    protected void doTearDown() throws Exception {
        memory.clear();
        super.doTearDown();
    }

    public void testBufferPool() throws Exception {
        LifecycleUtil.activate((Object)bufferPool);
        IBuffer[] buffers = new IBuffer[10];
        int i = 0;
        while (i < buffers.length) {
            buffers[i] = bufferPool.provideBuffer();
            ++i;
        }
        i = 0;
        while (i < buffers.length) {
            bufferPool.retainBuffer(buffers[i]);
            buffers[i] = null;
            ++i;
        }
        while (Net4jUtil.getPooledBuffers((IBufferPool)bufferPool) > 0 && BufferPoolTest.allocate()) {
            BufferPoolTest.sleep(10L);
            ReflectUtil.dump((Object)bufferPool);
        }
        LifecycleUtil.deactivate((Object)bufferPool);
    }

    private static void msg() {
        BufferPoolTest.msg("pooledBuffers = " + Net4jUtil.getPooledBuffers((IBufferPool)bufferPool));
    }

    private static boolean allocate() {
        try {
            IOUtil.OUT().println("allocating from " + Runtime.getRuntime().freeMemory());
            int i = 0;
            while (i < 10) {
                memory.add(new byte[1000000]);
                ++i;
            }
            BufferPoolTest.msg();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static void gc() {
        BufferPoolTest.msg();
        IOUtil.OUT().println("collecting garbage");
        System.gc();
        BufferPoolTest.msg();
    }
}

