/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class CDOLabelProvider
extends AdapterFactoryLabelProvider
implements IColorProvider,
IFontProvider {
    private static Color readPermissionColor;
    private Font bold;
    private CDOView view;
    private TreeViewer viewer;

    public CDOLabelProvider(AdapterFactory adapterFactory, CDOView view, TreeViewer viewer) {
        super(adapterFactory);
        this.view = view;
        this.viewer = viewer;
        Control control = viewer.getControl();
        this.bold = UIUtil.getBoldFont((Control)control);
    }

    public CDOView getView() {
        return this.view;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void dispose() {
        this.bold.dispose();
        super.dispose();
    }

    public void notifyChanged(final Notification notification) {
        super.notifyChanged(notification);
        try {
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        CDOLabelProvider.this.viewer.refresh(notification.getNotifier(), true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image getImage(Object object) {
        try {
            return super.getImage(object);
        }
        catch (Exception ex) {
            return CDOLabelProvider.getErrorImage();
        }
    }

    public String getText(Object object) {
        try {
            String text = super.getText(object);
            if (!StringUtil.isEmpty((String)text)) {
                return text;
            }
        }
        catch (Exception text) {
            // empty catch block
        }
        try {
            EObject eObject;
            EClass eClass;
            String text;
            if (object instanceof EObject && !StringUtil.isEmpty((String)(text = this.getText(eClass = (eObject = (EObject)object).eClass())))) {
                return text;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object.getClass().getSimpleName();
    }

    public Color getBackground(Object object) {
        return null;
    }

    public Color getForeground(Object object) {
        return CDOLabelProvider.getColor((CDOObject)FSMUtil.adapt((Object)object, (CDOView)this.view));
    }

    public Font getFont(Object object) {
        try {
            InternalCDOObject cdoObject = FSMUtil.adapt((Object)object, (CDOView)this.view);
            if (cdoObject != null) {
                switch (cdoObject.cdoState()) {
                    case NEW: 
                    case DIRTY: 
                    case CONFLICT: {
                        return this.bold;
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public static Color getColor(CDOObject object) {
        if (object != null) {
            try {
                if (object.cdoConflict()) {
                    return CDOLabelProvider.getConflictColor();
                }
                CDOPermission permission = object.cdoPermission();
                switch (permission) {
                    case NONE: {
                        return CDOLabelProvider.getNoPermissionColor();
                    }
                    case READ: {
                        return CDOLabelProvider.getReadPermissionColor();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Color getNoPermissionColor() {
        return UIUtil.grayColor();
    }

    private static Color getReadPermissionColor() {
        if (readPermissionColor == null) {
            readPermissionColor = UIUtil.getDisplay().getSystemColor(14);
        }
        return readPermissionColor;
    }

    private static Color getConflictColor() {
        return UIUtil.redColor();
    }

    private static Image getErrorImage() {
        return UIUtil.errorImage();
    }
}

