/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.releng.apireports;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.releng.apireports.Activator;
import org.eclipse.emf.cdo.releng.apireports.ApiReportsGenerator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ApiReportsHandler
extends AbstractHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        IFile file = ApiReportsHandler.getFile(((IStructuredSelection)selection).getFirstElement());
        InputStream contents = null;
        try {
            try {
                contents = file.getContents();
                Properties properties = new Properties();
                properties.load(contents);
                final String reportFileName = ApiReportsHandler.getProperty(properties, "reportFileName", file.getParent().getLocation().append("api.xml").toOSString());
                final String baselineName = ApiReportsHandler.getProperty(properties, "baselineName", null);
                final String exclusionPatterns = ApiReportsHandler.getProperty(properties, "exclusionPatterns", null);
                new ProgressMonitorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event)).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            IStatus status = ApiReportsGenerator.generate(reportFileName, baselineName, exclusionPatterns, monitor);
                            if (status.isOK()) {
                                IFile apiReport = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(reportFileName));
                                if (apiReport != null) {
                                    IContainer parent = apiReport.getParent();
                                    parent.refreshLocal(2, monitor);
                                }
                            } else if (status.getSeverity() != 8) {
                                Activator.log(status);
                            }
                        }
                        catch (CoreException ex) {
                            Activator.log(ex.getStatus());
                        }
                        catch (Throwable ex) {
                            Activator.log(ex);
                        }
                    }
                });
                return null;
            }
            catch (CoreException ex) {
                Activator.log(ex.getStatus());
                if (contents == null) return null;
                try {
                    contents.close();
                    return null;
                }
                catch (Throwable ex2) {
                    Activator.log(ex2);
                }
                return null;
            }
            catch (Throwable ex) {
                Activator.log(ex);
                if (contents == null) return null;
                try {
                    contents.close();
                    return null;
                }
                catch (Throwable ex3) {
                    Activator.log(ex3);
                }
                return null;
            }
        }
        finally {
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (Throwable ex) {
                    Activator.log(ex);
                }
            }
        }
    }

    private static String getProperty(Properties properties, String key, String defaultValue) {
        String value = properties.getProperty(key);
        if (value == null || value.length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    private static IFile getFile(Object element) {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        if (element instanceof IAdaptable) {
            Object adapter = ((IAdaptable)element).getAdapter(IFile.class);
            return ApiReportsHandler.getFile(adapter);
        }
        return null;
    }
}

