/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.spi.security;

import java.util.List;
import org.eclipse.emf.cdo.server.internal.security.bundle.OM;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.security.SecurityManagerUtil;
import org.eclipse.emf.cdo.server.spi.security.AnnotationHandler;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.RepositoryFactory;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;

public abstract class SecurityManagerFactory
extends Factory {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.security.managers";

    public SecurityManagerFactory(String type) {
        super(PRODUCT_GROUP, type);
    }

    public abstract ISecurityManager create(String var1) throws ProductCreationException;

    @Deprecated
    public static class Annotation
    extends SecurityManagerFactory {
        private static final String TYPE = "annotation";

        public Annotation() {
            super(TYPE);
        }

        @Override
        public ISecurityManager create(String realmPath) throws ProductCreationException {
            OM.LOG.warn("SecurityManagerFactory.Annotation is deprecated. As of 4.3 use SecurityManagerFactory.Default with a description like \"realmPath:annotation\"");
            InternalSecurityManager securityManager = (InternalSecurityManager)SecurityManagerUtil.createSecurityManager(realmPath);
            AnnotationHandler handler = new AnnotationHandler();
            securityManager.addCommitHandler(handler);
            return securityManager;
        }
    }

    public static class Default
    extends SecurityManagerFactory
    implements IManagedContainer.ContainerAware {
        public static final String TYPE = "default";
        private IManagedContainer container;

        public Default() {
            super(TYPE);
        }

        public void setManagedContainer(IManagedContainer container) {
            this.container = container;
        }

        @Override
        public ISecurityManager create(String description) throws ProductCreationException {
            List tokens = StringUtil.split((String)description, (String)":", (String)"()");
            String repositoryName = (String)tokens.get(0);
            String realmPath = (String)tokens.get(1);
            ISecurityManager securityManager = SecurityManagerUtil.createSecurityManager(realmPath);
            int i = 2;
            while (i < tokens.size()) {
                String token = (String)tokens.get(i);
                InternalSecurityManager.CommitHandler handler = this.getHandler(this.container, token);
                ((InternalSecurityManager)securityManager).addCommitHandler(handler);
                ++i;
            }
            if (securityManager instanceof InternalSecurityManager) {
                ((InternalSecurityManager)securityManager).setRepository((InternalRepository)RepositoryFactory.get((IManagedContainer)this.container, (String)repositoryName));
            }
            return securityManager;
        }

        protected InternalSecurityManager.CommitHandler getHandler(IManagedContainer container, String token) {
            String description;
            String factoryType;
            int pos = token.indexOf(40);
            if (pos == -1) {
                factoryType = token.trim();
                description = null;
            } else {
                factoryType = token.substring(0, pos).trim();
                description = token.substring(pos + 1, token.length() - 1).trim();
            }
            return (InternalSecurityManager.CommitHandler)container.getElement("org.eclipse.emf.cdo.server.security.commitHandlers", factoryType, description);
        }

        public static ISecurityManager create(IManagedContainer container, String repositoryName, String description) {
            String qualifiedDescription = String.format("%s:%s", repositoryName, description);
            return (ISecurityManager)container.getElement(SecurityManagerFactory.PRODUCT_GROUP, TYPE, qualifiedDescription);
        }
    }
}

