/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IBranchDeletionSupport;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingAuditSupport;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy2;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.CommitInfoTable;
import org.eclipse.emf.cdo.server.internal.db.DBRevisionHandler;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStoreChunkReader;
import org.eclipse.emf.cdo.server.internal.db.DurableLockingManager;
import org.eclipse.emf.cdo.server.internal.db.SQLQueryHandler;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.UnitMappingTable;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalUnitManager;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.Batch;
import org.eclipse.net4j.db.BatchedStatement;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.IDBSchemaTransaction;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.internal.db.ddl.DBField;
import org.eclipse.net4j.spi.db.DBAdapter;
import org.eclipse.net4j.util.ConsumerWithException;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.TrackableTimerTask;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class DBStoreAccessor
extends StoreAccessor
implements IDBStoreAccessor,
InternalCDOBranchManager.BranchLoader5,
IStoreAccessor.DurableLocking2 {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DBStoreAccessor.class);
    private IDBConnection connection;
    private ConnectionKeepAliveTask connectionKeepAliveTask;
    private CDOID maxID = CDOID.NULL;
    private InternalUnitManager.InternalObjectAttacher objectAttacher;
    private List<IDBTable> createdTables;

    public DBStoreAccessor(DBStore store, ISession session) throws DBException {
        super((Store)store, session);
    }

    public DBStoreAccessor(DBStore store, ITransaction transaction) throws DBException {
        super((Store)store, transaction);
    }

    @Override
    public final DBStore getStore() {
        return (DBStore)super.getStore();
    }

    @Override
    public final IDBConnection getDBConnection() {
        return this.connection;
    }

    @Override
    public final Connection getConnection() {
        return this.connection;
    }

    public DBStoreChunkReader createChunkReader(InternalCDORevision revision, EStructuralFeature feature) {
        return new DBStoreChunkReader(this, (CDORevision)revision, feature);
    }

    @Override
    public IDBSchemaTransaction openSchemaTransaction() {
        DBStore store = this.getStore();
        DBAdapter dbAdapter = (DBAdapter)store.getDBAdapter();
        IDBDatabase database = store.getDatabase();
        return dbAdapter.openSchemaTransaction(database, this.connection);
    }

    public CDOClassifierRef readObjectType(CDOID id) {
        if (TRACER.isEnabled()) {
            TRACER.format("Selecting object type: {0}", new Object[]{id});
        }
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        return mappingStrategy.readObjectType(this, id);
    }

    @Override
    public EClass getObjectType(CDOID id) {
        InternalCDORevision revision;
        InternalRepository repository = this.getStore().getRepository();
        if (id.equals(repository.getRootResourceID())) {
            return EresourcePackage.Literals.CDO_RESOURCE;
        }
        EClass result = repository.getRevisionManager().getObjectType(id);
        if (result != null) {
            return result;
        }
        IStoreAccessor.CommitContext commitContext = StoreThreadLocal.getCommitContext();
        if (commitContext != null && (revision = (InternalCDORevision)commitContext.getNewRevisions().get(id)) != null) {
            return revision.getEClass();
        }
        CDOClassifierRef type = this.readObjectType(id);
        if (type != null) {
            CDOPackageRegistry packageRegistry = repository.getPackageRegistry();
            return (EClass)type.resolve((EPackage.Registry)packageRegistry);
        }
        return null;
    }

    public InternalCDORevision readRevision(CDOID id, CDOBranchPoint branchPoint, int listChunk, CDORevisionCacheAdder cache) {
        if (TRACER.isEnabled()) {
            TRACER.format("Selecting revision {0} from {1}", new Object[]{id, branchPoint});
        }
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        EClass eClass = this.getObjectType(id);
        if (eClass != null) {
            InternalCDORevision revision = this.getStore().createRevision(eClass, id);
            revision.setBranchPoint(branchPoint);
            IClassMapping mapping = mappingStrategy.getClassMapping(eClass);
            if (mapping.readRevision(this, revision, listChunk)) {
                int version = revision.getVersion();
                if (version < 0) {
                    return new DetachedCDORevision(eClass, id, (CDOBranch)revision.getBranch(), -version, revision.getTimeStamp(), revision.getRevised());
                }
                return revision;
            }
        }
        return null;
    }

    public InternalCDORevision readRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int listChunk, CDORevisionCacheAdder cache) {
        DBStore store = this.getStore();
        EClass eClass = this.getObjectType(id);
        IMappingStrategy mappingStrategy = store.getMappingStrategy();
        IClassMapping mapping = mappingStrategy.getClassMapping(eClass);
        InternalCDORevision revision = store.createRevision(eClass, id);
        revision.setVersion(branchVersion.getVersion());
        revision.setBranchPoint(branchVersion.getBranch().getHead());
        boolean success = false;
        if (mappingStrategy.hasAuditSupport()) {
            if (TRACER.isEnabled()) {
                TRACER.format("Selecting revision {0} from {1}", new Object[]{id, branchVersion});
            }
            if ((success = ((IClassMappingAuditSupport)((Object)mapping)).readRevisionByVersion(this, revision, listChunk)) && revision.getVersion() < 0) {
                revision = new DetachedCDORevision(eClass, id, (CDOBranch)revision.getBranch(), -revision.getVersion(), revision.getTimeStamp(), revision.getRevised());
            }
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Selecting current base revision: {0}", new Object[]{id});
            }
            if ((success = mapping.readRevision(this, revision, listChunk)) && revision.getVersion() != branchVersion.getVersion()) {
                throw new IllegalStateException("Can only retrieve current version " + revision.getVersion() + " for " + id + " - version requested was " + branchVersion);
            }
        }
        return success ? revision : null;
    }

    public void queryResources(IStoreAccessor.QueryResourcesContext context) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        mappingStrategy.queryResources(this, context);
    }

    public void queryXRefs(IStoreAccessor.QueryXRefsContext context) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        mappingStrategy.queryXRefs(this, context);
    }

    public IQueryHandler getQueryHandler(CDOQueryInfo info) {
        String queryLanguage = info.getQueryLanguage();
        if (StringUtil.equalsUpperOrLowerCase((String)queryLanguage, (String)"sql")) {
            return new SQLQueryHandler(this);
        }
        return null;
    }

    public void queryLobs(List<byte[]> ids) {
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_QUERY_LOBS, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBResultSet resultSet = null;
        try {
            try {
                Iterator<byte[]> it = ids.iterator();
                while (it.hasNext()) {
                    byte[] id = it.next();
                    stmt.setString(1, HexUtil.bytesToHex((byte[])id));
                    try {
                        resultSet = stmt.executeQuery();
                        if (resultSet.next()) continue;
                        it.remove();
                    }
                    finally {
                        DBUtil.close((ResultSet)resultSet);
                    }
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    public void loadLob(byte[] id, OutputStream out) throws IOException {
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_LOAD_LOB, IDBPreparedStatement.ReuseProbability.MEDIUM);
        IDBResultSet resultSet = null;
        try {
            try {
                stmt.setString(1, HexUtil.bytesToHex((byte[])id));
                resultSet = stmt.executeQuery();
                resultSet.next();
                long size = resultSet.getLong(1);
                InputStream inputStream = resultSet.getBinaryStream(2);
                if (resultSet.wasNull()) {
                    Reader reader = resultSet.getCharacterStream(3);
                    IOUtil.copyCharacter((Reader)reader, (Writer)new OutputStreamWriter(out), (long)size);
                } else {
                    IOUtil.copyBinary((InputStream)inputStream, (OutputStream)out, (long)size);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    public void handleLobs(long fromTime, long toTime, CDOLobHandler handler) throws IOException {
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_HANDLE_LOBS, IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        try {
            try {
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    byte[] id = HexUtil.hexToBytes((String)resultSet.getString(1));
                    long size = resultSet.getLong(2);
                    InputStream inputStream = resultSet.getBinaryStream(3);
                    if (resultSet.wasNull()) {
                        Reader reader = resultSet.getCharacterStream(4);
                        Writer out = handler.handleClob(id, size);
                        if (out == null) continue;
                        try {
                            IOUtil.copyCharacter((Reader)reader, (Writer)out, (long)size);
                            continue;
                        }
                        finally {
                            IOUtil.close((Closeable)out);
                        }
                    }
                    OutputStream out = handler.handleBlob(id, size);
                    if (out == null) continue;
                    try {
                        IOUtil.copyBinary((InputStream)inputStream, (OutputStream)out, (long)size);
                    }
                    finally {
                        IOUtil.close((Closeable)out);
                    }
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    protected void applyIDMappings(InternalCommitContext context, OMMonitor monitor) {
        super.applyIDMappings(context, monitor);
        DBStore store = this.getStore();
        IIDHandler idHandler = store.getIDHandler();
        boolean adjustMaxID = !context.getBranchPoint().getBranch().isLocal() && store.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE;
        InternalCDORevision[] internalCDORevisionArray = context.getNewObjects();
        int n = internalCDORevisionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevision revision = internalCDORevisionArray[n2];
            CDOID id = revision.getID();
            if (adjustMaxID && (CDOIDUtil.isNull((CDOID)this.maxID) || idHandler.compare(id, this.maxID) > 0)) {
                this.maxID = id;
            }
            ++n2;
        }
    }

    protected void writeCommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, CDOBranchPoint mergeSource, OMMonitor monitor) {
        CommitInfoTable commitInfoTable = this.getStore().getCommitInfoTable();
        if (commitInfoTable != null) {
            commitInfoTable.writeCommitInfo(this, branch, timeStamp, previousTimeStamp, userID, comment, mergeSource, monitor);
        }
    }

    protected void writeRevisionDeltas(InternalCDORevisionDelta[] revisionDeltas, CDOBranch branch, long created, OMMonitor monitor) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        if (!mappingStrategy.hasDeltaSupport()) {
            throw new UnsupportedOperationException("Mapping strategy does not support revision deltas");
        }
        monitor.begin((double)revisionDeltas.length);
        try {
            InternalCDORevisionDelta[] internalCDORevisionDeltaArray = revisionDeltas;
            int n = revisionDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevisionDelta delta = internalCDORevisionDeltaArray[n2];
                this.writeRevisionDelta(delta, created, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void writeRevisionDelta(InternalCDORevisionDelta delta, long created, OMMonitor monitor) {
        CDOID id = delta.getID();
        EClass eClass = this.getObjectType(id);
        IClassMappingDeltaSupport mapping = (IClassMappingDeltaSupport)((Object)this.getStore().getMappingStrategy().getClassMapping(eClass));
        mapping.writeRevisionDelta(this, delta, created, monitor);
    }

    protected void writeNewObjectRevisions(InternalCommitContext context, InternalCDORevision[] newObjects, CDOBranch branch, OMMonitor monitor) {
        this.writeRevisions(context, true, newObjects, branch, monitor);
    }

    protected void writeDirtyObjectRevisions(InternalCommitContext context, InternalCDORevision[] dirtyObjects, CDOBranch branch, OMMonitor monitor) {
        this.writeRevisions(context, false, dirtyObjects, branch, monitor);
    }

    protected void writeRevisions(InternalCommitContext context, boolean attachNewObjects, InternalCDORevision[] revisions, CDOBranch branch, OMMonitor monitor) {
        try {
            InternalRepository repository;
            monitor.begin((double)revisions.length);
            InternalCDORevision[] internalCDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                this.writeRevision(revision, attachNewObjects, true, monitor.fork());
                ++n2;
            }
            if (attachNewObjects && (repository = this.getStore().getRepository()).isSupportingUnits()) {
                InternalUnitManager unitManager = repository.getUnitManager();
                this.objectAttacher = unitManager.attachObjects(context);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void writeRevisions(InternalCDORevision[] revisions, CDOBranch branch, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    protected void writeRevision(InternalCDORevision revision, boolean firstRevision, boolean revise, OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing revision: {0}", new Object[]{revision});
        }
        EClass eClass = revision.getEClass();
        IClassMapping mapping = this.getStore().getMappingStrategy().getClassMapping(eClass);
        mapping.writeRevision(this, revision, firstRevision, revise, monitor);
    }

    protected boolean needsRevisionPostProcessing() {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        if (mappingStrategy instanceof IMappingStrategy2) {
            return ((IMappingStrategy2)mappingStrategy).needsRevisionPostProcessing();
        }
        return super.needsRevisionPostProcessing();
    }

    protected void postProcessRevisions(InternalCommitContext context, OMMonitor monitor) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        if (mappingStrategy instanceof IMappingStrategy2) {
            ((IMappingStrategy2)mappingStrategy).postProcessRevisions(this, (IStoreAccessor.CommitContext)context, monitor);
        }
    }

    protected void detachObjects(CDOID[] detachedObjects, CDOBranch branch, long timeStamp, OMMonitor monitor) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        monitor.begin((double)detachedObjects.length);
        try {
            InternalCDORevisionManager revisionManager = this.getStore().getRepository().getRevisionManager();
            CDOID[] cDOIDArray = detachedObjects;
            int n = detachedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                int version;
                CDOID id = cDOIDArray[n2];
                InternalCDORevision revision = revisionManager.getRevision(id, branch.getHead(), -1, 0, true);
                int n3 = version = ObjectUtil.equals((Object)branch, (Object)revision.getBranch()) ? revision.getVersion() + 1 : 1;
                if (TRACER.isEnabled()) {
                    TRACER.format("Detaching object: {0}", new Object[]{id});
                }
                EClass eClass = this.getObjectType(id);
                IClassMapping mapping = mappingStrategy.getClassMapping(eClass);
                mapping.detachObject(this, id, version, branch, timeStamp, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected CDOID getNextCDOID(CDORevision revision) {
        return this.getStore().getIDHandler().getNextCDOID(revision);
    }

    protected void writeBlob(byte[] id, long size, InputStream inputStream) throws IOException {
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_WRITE_BLOB, IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            try {
                stmt.setString(1, HexUtil.bytesToHex((byte[])id));
                stmt.setLong(2, size);
                stmt.setBinaryStream(3, inputStream, (int)size);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    protected void writeClob(byte[] id, long size, Reader reader) throws IOException {
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_WRITE_CLOB, IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            try {
                stmt.setString(1, HexUtil.bytesToHex((byte[])id));
                stmt.setLong(2, size);
                stmt.setCharacterStream(3, reader, (int)size);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    protected final void doCommit(OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("--- DB COMMIT ---", new Object[0]);
        }
        OMMonitor.Async async = null;
        monitor.begin();
        try {
            try {
                try {
                    async = monitor.forkAsync();
                    this.connection.commit();
                    if (this.maxID != CDOID.NULL) {
                        this.getStore().getIDHandler().adjustLastObjectID(this.maxID);
                        this.maxID = CDOID.NULL;
                    }
                    if (this.objectAttacher != null) {
                        this.objectAttacher.finishedCommit(true);
                        this.objectAttacher = null;
                    }
                }
                finally {
                    if (async != null) {
                        async.stop();
                    }
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected final void doRollback(IStoreAccessor.CommitContext commitContext) {
        if (this.objectAttacher != null) {
            this.objectAttacher.finishedCommit(false);
            this.objectAttacher = null;
        }
        DBStore store = this.getStore();
        IMetaDataManager metaDataManager = store.getMetaDataManager();
        metaDataManager.clearMetaIDMappings();
        if (TRACER.isEnabled()) {
            TRACER.format("--- DB ROLLBACK ---", new Object[0]);
        }
        try {
            this.connection.rollback();
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        IMappingStrategy mappingStrategy = store.getMappingStrategy();
        mappingStrategy.removeMapping((Connection)this.connection, commitContext.getNewPackageUnits());
    }

    protected void doActivate() throws Exception {
        String value;
        super.doActivate();
        DBStore store = this.getStore();
        this.connection = store.getDatabase().getConnection();
        this.connectionKeepAliveTask = new ConnectionKeepAliveTask(this);
        this.objectAttacher = null;
        long keepAlivePeriod = 14400000L;
        Map<String, String> storeProps = store.getProperties();
        if (storeProps != null && (value = storeProps.get("connectionKeepAlivePeriod")) != null) {
            keepAlivePeriod = Long.parseLong(value) * 60L * 1000L;
        }
        store.getConnectionKeepAliveTimer().schedule((TimerTask)((Object)this.connectionKeepAliveTask), keepAlivePeriod, keepAlivePeriod);
    }

    protected void doDeactivate() throws Exception {
        this.connectionKeepAliveTask.cancel();
        this.connectionKeepAliveTask = null;
        DBUtil.close((Connection)this.connection);
        this.connection = null;
        super.doDeactivate();
    }

    protected void doPassivate() throws Exception {
        this.connection.rollback();
        if (this.createdTables != null) {
            this.createdTables.clear();
            this.createdTables = null;
        }
    }

    protected void doUnpassivate() throws Exception {
    }

    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        IMetaDataManager metaDataManager = this.getStore().getMetaDataManager();
        return metaDataManager.loadPackageUnit((Connection)this.connection, packageUnit);
    }

    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        IMetaDataManager metaDataManager = this.getStore().getMetaDataManager();
        return metaDataManager.readPackageUnits((Connection)this.connection);
    }

    protected void doWrite(InternalCommitContext context, OMMonitor monitor) {
        boolean wasTrackConstruction = DBField.isTrackConstruction();
        try {
            String prop;
            Map<String, String> properties = this.getStore().getProperties();
            if (properties != null && (prop = properties.get("fieldConstructionTracking")) != null) {
                DBField.trackConstruction((boolean)Boolean.valueOf(prop));
            }
            super.doWrite(context, monitor);
        }
        finally {
            DBField.trackConstruction((boolean)wasTrackConstruction);
        }
    }

    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        monitor.begin(2.0);
        try {
            DBStore store = this.getStore();
            IMetaDataManager metaDataManager = store.getMetaDataManager();
            metaDataManager.writePackageUnits((Connection)this.connection, packageUnits, monitor.fork());
            IMappingStrategy mappingStrategy = store.getMappingStrategy();
            mappingStrategy.createMapping((Connection)this.connection, packageUnits, monitor.fork());
        }
        finally {
            monitor.done();
        }
    }

    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        this.checkBranchingSupport();
        if (branchID == Integer.MAX_VALUE) {
            branchID = this.getStore().getNextBranchID();
        } else if (branchID == Integer.MIN_VALUE) {
            branchID = this.getStore().getNextLocalBranchID();
        }
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_CREATE_BRANCH, IDBPreparedStatement.ReuseProbability.LOW);
        try {
            stmt.setInt(1, branchID);
            stmt.setString(2, branchInfo.getName());
            stmt.setInt(3, branchInfo.getBaseBranchID());
            stmt.setLong(4, branchInfo.getBaseTimeStamp());
            DBUtil.update((PreparedStatement)stmt, (boolean)true);
            this.connection.commit();
            Pair pair = Pair.create((Object)branchID, (Object)branchInfo.getBaseTimeStamp());
            return pair;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo;
        this.checkBranchingSupport();
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_LOAD_BRANCH, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBResultSet resultSet = null;
        try {
            stmt.setInt(1, branchID);
            resultSet = stmt.executeQuery();
            if (!resultSet.next()) {
                throw new DBException("Branch with ID " + branchID + " does not exist");
            }
            String name = resultSet.getString(1);
            int baseBranchID = resultSet.getInt(2);
            long baseTimeStamp = resultSet.getLong(3);
            branchInfo = new InternalCDOBranchManager.BranchLoader.BranchInfo(name, baseBranchID, baseTimeStamp);
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return branchInfo;
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int baseID) {
        InternalCDOBranchManager.BranchLoader.SubBranchInfo[] subBranchInfoArray;
        this.checkBranchingSupport();
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_LOAD_SUB_BRANCHES, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBResultSet resultSet = null;
        try {
            stmt.setInt(1, baseID);
            resultSet = stmt.executeQuery();
            ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo> result = new ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo>();
            while (resultSet.next()) {
                int id = resultSet.getInt(1);
                String name = resultSet.getString(2);
                long baseTimeStamp = resultSet.getLong(3);
                result.add(new InternalCDOBranchManager.BranchLoader.SubBranchInfo(id, name, baseTimeStamp));
            }
            subBranchInfoArray = result.toArray(new InternalCDOBranchManager.BranchLoader.SubBranchInfo[result.size()]);
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return subBranchInfoArray;
    }

    private void execSQL(String sql, ConsumerWithException<IDBPreparedStatement, SQLException> preparer) {
        IDBPreparedStatement stmt = this.connection.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
        try {
            try {
                if (preparer != null) {
                    preparer.accept((Object)stmt);
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
                this.connection.commit();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private void checkAuditingSupport() {
        if (!this.getStore().getMappingStrategy().hasAuditSupport()) {
            throw new UnsupportedOperationException("Mapping strategy does not support auditing");
        }
    }

    private void checkBranchingSupport() {
        if (!this.getStore().getMappingStrategy().hasBranchingSupport()) {
            throw new UnsupportedOperationException("Mapping strategy does not support branching");
        }
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler handler) {
        int n;
        int count = 0;
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_LOAD_BRANCHES, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBResultSet resultSet = null;
        InternalCDOBranchManager branchManager = this.getSession().getRepository().getBranchManager();
        try {
            stmt.setInt(1, startID);
            stmt.setInt(2, endID > 0 ? endID : Integer.MAX_VALUE);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                int branchID = resultSet.getInt(1);
                String name = resultSet.getString(2);
                int baseBranchID = resultSet.getInt(3);
                long baseTimeStamp = resultSet.getLong(4);
                InternalCDOBranch branch = branchManager.getBranch(branchID, new InternalCDOBranchManager.BranchLoader.BranchInfo(name, baseBranchID, baseTimeStamp));
                handler.handleBranch((CDOBranch)branch);
                ++count;
            }
            n = count;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return n;
    }

    public CDOBranch[] deleteBranches(int branchID, OMMonitor monitor) {
        DBStore store = this.getStore();
        LinkedHashSet branches = store.getRepository().getBranchManager().getBranches(branchID);
        String idList = this.buildIDList(branches);
        Throwable throwable = null;
        Object var7_8 = null;
        try (Batch batch = new Batch((Connection)this.connection, new String[0]);){
            CommitInfoTable commitInfoTable;
            batch.add("DELETE FROM " + CDODBSchema.BRANCHES + " WHERE " + CDODBSchema.BRANCHES_ID + " IN (" + idList + ")");
            batch.add("DELETE FROM " + CDODBSchema.TAGS + " WHERE " + CDODBSchema.TAGS_BRANCH + " IN (" + idList + ")");
            IMappingStrategy mappingStrategy = store.getMappingStrategy();
            if (mappingStrategy instanceof IBranchDeletionSupport) {
                ((IBranchDeletionSupport)((Object)mappingStrategy)).deleteBranches(this, batch, idList);
            }
            if ((commitInfoTable = store.getCommitInfoTable()) != null) {
                commitInfoTable.deleteBranches(this, batch, idList);
            }
            store.getDurableLockingManager().deleteBranches(this, batch, idList);
            monitor.begin();
            OMMonitor.Async async = monitor.forkAsync();
            try {
                try {
                    batch.execute();
                    this.connection.commit();
                }
                catch (SQLException ex) {
                    throw new DBException((Throwable)ex);
                }
            }
            finally {
                async.stop();
                monitor.done();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return branches.toArray(new CDOBranch[branches.size()]);
    }

    private String buildIDList(Set<CDOBranch> branches) {
        StringBuilder builder = new StringBuilder();
        for (CDOBranch branch : branches) {
            StringUtil.appendSeparator((StringBuilder)builder, (String)", ");
            builder.append(branch.getID());
        }
        return builder.toString();
    }

    public void renameBranch(int branchID, String oldName, String newName) {
        this.checkBranchingSupport();
        IDBPreparedStatement stmt = this.connection.prepareStatement(CDODBSchema.SQL_RENAME_BRANCH, IDBPreparedStatement.ReuseProbability.LOW);
        try {
            try {
                stmt.setString(1, newName);
                stmt.setInt(2, branchID);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
                this.connection.commit();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    public CDOBranchPoint changeTag(AtomicInteger modCount, String oldName, String newName, CDOBranchPoint branchPoint) {
        this.checkAuditingSupport();
        switch (InternalCDOBranchManager.getTagChangeKind((String)oldName, (String)newName, (CDOBranchPoint)branchPoint)) {
            case CREATED: {
                this.execSQL(CDODBSchema.SQL_CREATE_TAG, (ConsumerWithException<IDBPreparedStatement, SQLException>)((ConsumerWithException)stmt -> {
                    stmt.setString(1, newName);
                    stmt.setInt(2, branchPoint.getBranch().getID());
                    stmt.setLong(3, branchPoint.getTimeStamp());
                }));
                break;
            }
            case RENAMED: {
                this.execSQL(CDODBSchema.SQL_RENAME_TAG, (ConsumerWithException<IDBPreparedStatement, SQLException>)((ConsumerWithException)stmt -> {
                    stmt.setString(1, newName);
                    stmt.setString(2, oldName);
                }));
                break;
            }
            case MOVED: {
                this.execSQL(CDODBSchema.SQL_MOVE_TAG, (ConsumerWithException<IDBPreparedStatement, SQLException>)((ConsumerWithException)stmt -> {
                    stmt.setInt(1, branchPoint.getBranch().getID());
                    stmt.setLong(2, branchPoint.getTimeStamp());
                    stmt.setString(3, oldName);
                }));
                break;
            }
            case DELETED: {
                this.execSQL(CDODBSchema.SQL_DELETE_TAG, (ConsumerWithException<IDBPreparedStatement, SQLException>)((ConsumerWithException)stmt -> stmt.setString(1, oldName)));
            }
        }
        return null;
    }

    public void loadTags(String name, Consumer<InternalCDOBranchManager.BranchLoader.BranchInfo> handler) {
        this.checkAuditingSupport();
        boolean single = name != null;
        String sql = single ? CDODBSchema.SQL_LOAD_TAG : CDODBSchema.SQL_LOAD_TAGS;
        IDBPreparedStatement stmt = this.connection.prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        try {
            try {
                if (single) {
                    stmt.setString(1, name);
                }
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    int c = 0;
                    if (!single) {
                        name = resultSet.getString(++c);
                    }
                    int branchID = resultSet.getInt(++c);
                    long timeStamp = resultSet.getLong(++c);
                    handler.accept(new InternalCDOBranchManager.BranchLoader.BranchInfo(name, branchID, timeStamp));
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        CommitInfoTable commitInfoTable = this.getStore().getCommitInfoTable();
        if (commitInfoTable != null) {
            commitInfoTable.loadCommitInfos(this, branch, startTime, endTime, handler);
        }
    }

    public Set<CDOID> readChangeSet(OMMonitor monitor, CDOChangeSetSegment ... segments) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        return mappingStrategy.readChangeSet(this, monitor, segments);
    }

    public void handleRevisions(EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        mappingStrategy.handleRevisions(this, eClass, branch, timeStamp, exactTime, new DBRevisionHandler(handler));
    }

    public void rawExport(CDODataOutput out, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) throws IOException {
        DBStore store = this.getStore();
        InternalRepository repository = store.getRepository();
        if (repository.getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            out.writeCDOID(store.getIDHandler().getLastObjectID());
        }
        String where = " WHERE " + CDODBSchema.BRANCHES_ID + " BETWEEN " + fromBranchID + " AND " + toBranchID;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)this.connection, (IDBTable)CDODBSchema.BRANCHES, null, (String)where);
        CommitInfoTable commitInfoTable = store.getCommitInfoTable();
        if (commitInfoTable != null) {
            out.writeBoolean(true);
            commitInfoTable.rawExport((Connection)this.connection, out, fromCommitTime, toCommitTime);
        } else {
            out.writeBoolean(false);
        }
        DurableLockingManager durableLockingManager = store.getDurableLockingManager();
        durableLockingManager.rawExport((Connection)this.connection, out, fromCommitTime, toCommitTime);
        IIDHandler idHandler = store.getIDHandler();
        idHandler.rawExport((Connection)this.connection, out, fromCommitTime, toCommitTime);
        IMappingStrategy mappingStrategy = store.getMappingStrategy();
        mappingStrategy.rawExport(this, out, fromBranchID, toBranchID, fromCommitTime, toCommitTime);
    }

    public void rawImport(CDODataInput in, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        DBStore store = this.getStore();
        IIDHandler idHandler = store.getIDHandler();
        if (store.getRepository().getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            idHandler.setLastObjectID(in.readCDOID());
        }
        IMappingStrategy mappingStrategy = store.getMappingStrategy();
        int size = mappingStrategy.getClassMappings().size();
        int commitWork = 5;
        monitor.begin((double)(commitWork + size + commitWork));
        HashSet<InternalCDOPackageUnit> packageUnits = new HashSet<InternalCDOPackageUnit>();
        try {
            try {
                DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)this.connection, (IDBTable)CDODBSchema.BRANCHES, (OMMonitor)monitor.fork());
                CommitInfoTable commitInfoTable = store.getCommitInfoTable();
                if (in.readBoolean()) {
                    if (commitInfoTable == null) {
                        throw new IllegalStateException("Commit info table is missing");
                    }
                    commitInfoTable.rawImport((Connection)this.connection, in, fromCommitTime, toCommitTime, monitor.fork());
                } else if (commitInfoTable != null) {
                    throw new IllegalStateException("Commit info data is expected but missing");
                }
                DurableLockingManager durableLockingManager = store.getDurableLockingManager();
                durableLockingManager.rawImport((Connection)this.connection, in, fromCommitTime, toCommitTime, monitor.fork());
                idHandler.rawImport((Connection)this.connection, in, fromCommitTime, toCommitTime, monitor.fork());
                try (IDBSchemaTransaction schemaTransaction = this.openSchemaTransaction();){
                    mappingStrategy.rawImport(this, in, fromCommitTime, toCommitTime, monitor.fork((double)size));
                    schemaTransaction.commit();
                }
                this.rawCommit(commitWork, monitor);
            }
            catch (RuntimeException ex) {
                this.rawRollback(packageUnits);
                throw ex;
            }
            catch (IOException ex) {
                this.rawRollback(packageUnits);
                throw ex;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void rawRollback(Collection<InternalCDOPackageUnit> packageUnits) {
        try {
            this.connection.rollback();
        }
        catch (SQLException ex) {
            OM.LOG.error((Throwable)ex);
        }
        this.getStore().getMappingStrategy().removeMapping((Connection)this.connection, packageUnits.toArray(new InternalCDOPackageUnit[packageUnits.size()]));
    }

    protected void rawImportPackageUnits(CDODataInput in, long fromCommitTime, long toCommitTime, Collection<InternalCDOPackageUnit> packageUnits, OMMonitor monitor) throws IOException {
        block8: {
            monitor.begin(2.0);
            try {
                DBStore store = this.getStore();
                IMetaDataManager metaDataManager = store.getMetaDataManager();
                Collection<InternalCDOPackageUnit> imported = metaDataManager.rawImport((Connection)this.connection, in, fromCommitTime, toCommitTime, monitor.fork());
                packageUnits.addAll(imported);
                if (!packageUnits.isEmpty()) {
                    InternalRepository repository = store.getRepository();
                    InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
                    for (InternalCDOPackageUnit packageUnit : packageUnits) {
                        packageRegistry.putPackageUnit(packageUnit);
                    }
                    IMappingStrategy mappingStrategy = store.getMappingStrategy();
                    Connection connection2 = null;
                    try {
                        connection2 = store.getConnection();
                        mappingStrategy.createMapping(connection2, packageUnits.toArray(new InternalCDOPackageUnit[packageUnits.size()]), monitor.fork());
                        break block8;
                    }
                    finally {
                        DBUtil.close((Connection)connection2);
                    }
                }
                monitor.worked();
            }
            finally {
                monitor.done();
            }
        }
    }

    public void rawStore(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        this.writePackageUnits(packageUnits, monitor);
    }

    public void rawStore(InternalCDORevision revision, OMMonitor monitor) {
        boolean firstRevision;
        CDOID id = revision.getID();
        EClass eClass = revision.getEClass();
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        CDOClassifierRef classifierRef = mappingStrategy.readObjectType(this, id);
        boolean bl = firstRevision = classifierRef == null;
        if (!firstRevision) {
            boolean namesMatch = classifierRef.getClassifierName().equals(eClass.getName());
            boolean packagesMatch = classifierRef.getPackageURI().equals(eClass.getEPackage().getNsURI());
            if (!namesMatch || !packagesMatch) {
                throw new IllegalStateException();
            }
        }
        this.writeRevision(revision, firstRevision, false, monitor);
        this.getStore().getIDHandler().adjustLastObjectID(id);
    }

    public void rawStore(byte[] id, long size, InputStream inputStream) throws IOException {
        this.writeBlob(id, size, inputStream);
    }

    public void rawStore(byte[] id, long size, Reader reader) throws IOException {
        this.writeClob(id, size, reader);
    }

    public void rawStore(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, OMMonitor monitor) {
        this.writeCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, null, monitor);
    }

    public void rawStore(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, CDOBranchPoint mergeSource, OMMonitor monitor) {
        this.writeCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, mergeSource, monitor);
    }

    public void rawDelete(CDOID id, int version, CDOBranch branch, EClass eClass, OMMonitor monitor) {
        IMappingStrategy mappingStrategy;
        IClassMapping mapping;
        if (eClass == null) {
            eClass = this.getObjectType(id);
        }
        if (!((mapping = (mappingStrategy = this.getStore().getMappingStrategy()).getClassMapping(eClass)) instanceof AbstractHorizontalClassMapping)) {
            throw new UnsupportedOperationException("rawDelete() is not supported by " + mapping.getClass().getName());
        }
        AbstractHorizontalClassMapping m = (AbstractHorizontalClassMapping)mapping;
        m.rawDelete(this, id, version, branch, monitor);
    }

    public void rawCommit(double commitWork, OMMonitor monitor) {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            async.stop();
            monitor.done();
        }
    }

    public IDurableLockingManager.LockArea createLockArea(String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        return this.createLockArea(null, userID, branchPoint, readOnly, locks);
    }

    public IDurableLockingManager.LockArea createLockArea(String durableLockingID, String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        return manager.createLockArea(this, durableLockingID, userID, branchPoint, readOnly, locks);
    }

    public void updateLockArea(IDurableLockingManager.LockArea area) {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        manager.updateLockArea(this, area);
    }

    public IDurableLockingManager.LockArea getLockArea(String durableLockingID) throws IDurableLockingManager.LockAreaNotFoundException {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        return manager.getLockArea(this, durableLockingID);
    }

    public void getLockAreas(String userIDPrefix, IDurableLockingManager.LockArea.Handler handler) {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        manager.getLockAreas(this, userIDPrefix, handler);
    }

    public void deleteLockArea(String durableLockingID) {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        manager.deleteLockArea(this, durableLockingID);
    }

    public void lock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToLock) {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        manager.lock(this, durableLockingID, type, objectsToLock);
    }

    public void unlock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToUnlock) {
        DurableLockingManager manager = this.getStore().getDurableLockingManager();
        manager.unlock(this, durableLockingID, type, objectsToUnlock);
    }

    public List<CDOID> readUnitRoots() {
        UnitMappingTable unitMappingTable = this.getStore().getUnitMappingTable();
        return unitMappingTable.readUnitRoots(this);
    }

    public void readUnit(IView view, CDOID rootID, CDORevisionHandler revisionHandler, OMMonitor monitor) {
        UnitMappingTable unitMappingTable = this.getStore().getUnitMappingTable();
        unitMappingTable.readUnitRevisions(this, view, rootID, revisionHandler, monitor);
    }

    public Object initUnit(IView view, CDOID rootID, CDORevisionHandler revisionHandler, Set<CDOID> initializedIDs, long timeStamp, OMMonitor monitor) {
        UnitMappingTable unitMappingTable = this.getStore().getUnitMappingTable();
        return unitMappingTable.initUnit(this, timeStamp, view, rootID, revisionHandler, initializedIDs, monitor);
    }

    public void finishUnit(IView view, CDOID rootID, CDORevisionHandler revisionHandler, long timeStamp, Object initResult, List<CDOID> ids) {
        UnitMappingTable unitMappingTable = this.getStore().getUnitMappingTable();
        unitMappingTable.finishUnit((BatchedStatement)initResult, rootID, ids, timeStamp);
    }

    public void writeUnits(Map<CDOID, CDOID> unitMappings, long timeStamp) {
        UnitMappingTable unitMappingTable = this.getStore().getUnitMappingTable();
        unitMappingTable.writeUnitMappings(this, unitMappings, timeStamp);
    }

    @Override
    public void tableCreated(IDBTable table) {
        if (this.createdTables == null) {
            this.createdTables = new ArrayList<IDBTable>();
        }
        this.createdTables.add(table);
    }

    @Override
    @Deprecated
    public IPreparedStatementCache getStatementCache() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public CloseableIterator<CDOID> readObjectIDs() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void writeCommitInfo(CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void deleteBranch(int branchID) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void renameBranch(int branchID, String newName) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void unlock(String durableLockingID) {
        throw new UnsupportedOperationException();
    }

    private static final class ConnectionKeepAliveTask
    extends TrackableTimerTask {
        public static final long EXECUTION_PERIOD = 14400000L;
        private DBStoreAccessor accessor;

        public ConnectionKeepAliveTask(DBStoreAccessor accessor) {
            this.accessor = accessor;
        }

        public void run() {
            block11: {
                if (this.accessor == null) {
                    return;
                }
                Statement stmt = null;
                try {
                    if (TRACER.isEnabled()) {
                        TRACER.trace("DB connection keep-alive task activated");
                    }
                    Connection connection = this.accessor.getConnection();
                    stmt = connection.createStatement();
                    stmt.executeQuery("SELECT 1 FROM " + CDODBSchema.PROPERTIES);
                }
                catch (SQLException ex) {
                    OM.LOG.error("DB connection keep-alive failed", (Throwable)ex);
                    try {
                        LifecycleUtil.deactivate((Object)this.accessor);
                        LifecycleUtil.activate((Object)this.accessor);
                    }
                    catch (Exception ex2) {
                        OM.LOG.error("DB connection reconnect failed", (Throwable)ex2);
                    }
                    DBUtil.close((Statement)stmt);
                    break block11;
                }
                catch (Exception ex) {
                    try {
                        OM.LOG.error("DB connection keep-alive failed", (Throwable)ex);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        DBUtil.close(stmt);
                    }
                }
                DBUtil.close((Statement)stmt);
            }
        }

        public boolean cancel() {
            this.accessor = null;
            return super.cancel();
        }
    }
}

