/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.codegen.qvti.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AS2CGVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGFinalVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.generator.GenModelException;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.examples.domain.ids.PrimitiveTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.LibraryProperty;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiAnalyzer;
import org.eclipse.qvtd.codegen.qvti.java.QVTiGlobalContext;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcorePropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGEcoreRealizedVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunction;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunctionCallExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGFunctionParameter;
import org.eclipse.qvtd.codegen.qvticgmodel.CGGuardVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMapping;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingCall;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingCallBinding;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMappingExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMiddlePropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGMiddlePropertyCallExp;
import org.eclipse.qvtd.codegen.qvticgmodel.CGPredicate;
import org.eclipse.qvtd.codegen.qvticgmodel.CGPropertyAssignment;
import org.eclipse.qvtd.codegen.qvticgmodel.CGRealizedVariable;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTransformation;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTypedModel;
import org.eclipse.qvtd.codegen.qvticgmodel.CGVariablePredicate;
import org.eclipse.qvtd.codegen.qvticgmodel.QVTiCGModelFactory;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.Unit;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.EnforcementOperation;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MiddlePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtimperative.MiddlePropertyCallExp;
import org.eclipse.qvtd.pivot.qvtimperative.VariablePredicate;
import org.eclipse.qvtd.pivot.qvtimperative.util.QVTimperativeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QVTiAS2CGVisitor
extends AS2CGVisitor
implements QVTimperativeVisitor<CGNamedElement> {
    @NonNull
    protected final QVTiAnalyzer analyzer;
    @NonNull
    protected final QVTiGlobalContext globalContext;

    public QVTiAS2CGVisitor(@NonNull QVTiAnalyzer analyzer, @NonNull QVTiGlobalContext globalContext) {
        super((CodeGenAnalyzer)analyzer);
        this.analyzer = analyzer;
        this.globalContext = globalContext;
    }

    protected void createMappingCalls(@NonNull Mapping pMapping, @NonNull CGMappingExp cgMappingExp) {
        for (MappingCall asMappingCall : pMapping.getMappingCall()) {
            CGMappingCall cgMappingCall = (CGMappingCall)this.doVisit(CGMappingCall.class, (Element)asMappingCall);
            cgMappingExp.getMappingCalls().add(cgMappingCall);
        }
    }

    protected void doBottoms(@NonNull Mapping pMapping, @NonNull CGMappingExp cgMappingExp) {
        ArrayList<BottomPattern> pBottomPatterns = new ArrayList<BottomPattern>();
        BottomPattern pBottomPattern = pMapping.getBottomPattern();
        if (pBottomPattern != null) {
            pBottomPatterns.add(pBottomPattern);
        }
        for (Domain pDomain : pMapping.getDomain()) {
            if (!(pDomain instanceof CoreDomain) || (pBottomPattern = ((CoreDomain)pDomain).getBottomPattern()) == null) continue;
            pBottomPatterns.add(pBottomPattern);
        }
        ArrayList pRealizedVariables = new ArrayList();
        for (BottomPattern pBottomPattern2 : pBottomPatterns) {
            pRealizedVariables.addAll(pBottomPattern2.getRealizedVariable());
        }
        Collections.sort(pRealizedVariables, new Comparator<NamedElement>(){

            @Override
            public int compare(NamedElement o1, NamedElement o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        List<CGValuedElement> cgRealizedVariables = cgMappingExp.getRealizedVariables();
        for (RealizedVariable pRealizedVariable : pRealizedVariables) {
            CGRealizedVariable cgVariable = this.getRealizedVariable(pRealizedVariable);
            cgRealizedVariables.add((CGValuedElement)cgVariable);
        }
        List<CGPropertyAssignment> cgAssignments = cgMappingExp.getAssignments();
        for (BottomPattern pBottomPattern3 : pBottomPatterns) {
            for (Assignment pAssignment : pBottomPattern3.getAssignment()) {
                cgAssignments.add((CGPropertyAssignment)this.doVisit(CGPropertyAssignment.class, (Element)pAssignment));
            }
        }
    }

    protected void doGuards(@NonNull Mapping pMapping, @NonNull CGMapping cgMapping, @NonNull CGMappingExp cgMappingExp) {
        ArrayList<GuardPattern> guardPatterns = new ArrayList<GuardPattern>();
        GuardPattern pGuardPattern = pMapping.getGuardPattern();
        if (pGuardPattern != null) {
            guardPatterns.add(pGuardPattern);
        }
        for (Domain pDomain : pMapping.getDomain()) {
            GuardPattern guardPattern;
            if (!(pDomain instanceof CoreDomain) || (guardPattern = ((CoreDomain)pDomain).getGuardPattern()) == null) continue;
            guardPatterns.add(guardPattern);
        }
        HashSet<Variable> predicatedVariables = new HashSet<Variable>();
        for (GuardPattern pGuardPattern2 : guardPatterns) {
            for (Predicate predicate : pGuardPattern2.getPredicate()) {
                if (!(predicate instanceof VariablePredicate)) continue;
                predicatedVariables.add(((VariablePredicate)predicate).getTargetVariable());
            }
        }
        ArrayList<Variable> pGuardVariables = new ArrayList<Variable>();
        for (GuardPattern pGuardPattern3 : guardPatterns) {
            pGuardPattern3.getPredicate();
            for (Variable pGuardVariable : pGuardPattern3.getVariable()) {
                if (predicatedVariables.contains(pGuardVariable)) continue;
                pGuardVariables.add(pGuardVariable);
            }
        }
        Collections.sort(pGuardVariables, new Comparator<NamedElement>(){

            @Override
            public int compare(NamedElement o1, NamedElement o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<CGGuardVariable> cgFreeVariables = new ArrayList<CGGuardVariable>();
        ArrayList<CGFinalVariable> cgBoundVariables = new ArrayList<CGFinalVariable>();
        for (Variable pGuardVariable : pGuardVariables) {
            OCLExpression initExpression = pGuardVariable.getInitExpression();
            if (initExpression == null) {
                CGGuardVariable cgUnboundVariable = this.getGuardVariable(pGuardVariable);
                cgFreeVariables.add(cgUnboundVariable);
                continue;
            }
            CGFinalVariable cgBoundVariable = (CGFinalVariable)this.getVariable((VariableDeclaration)pGuardVariable);
            CGValuedElement cgInit = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)initExpression);
            cgBoundVariable.setInit(cgInit);
            JavaLocalContext localContext = this.globalContext.getLocalContext((CGElement)cgMapping);
            cgBoundVariables.add(cgBoundVariable);
        }
        Collections.sort(cgFreeVariables, new Comparator<CGGuardVariable>(){

            @Override
            public int compare(CGGuardVariable o1, CGGuardVariable o2) {
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareTo(n2);
            }
        });
        Collections.sort(cgBoundVariables, new Comparator<CGFinalVariable>(){

            @Override
            public int compare(CGFinalVariable o1, CGFinalVariable o2) {
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareTo(n2);
            }
        });
        cgMapping.getFreeVariables().addAll(cgFreeVariables);
        List<CGPredicate> cgGuardExpressions = cgMappingExp.getPredicates();
        for (GuardPattern pGuardPattern4 : guardPatterns) {
            for (Predicate asPredicate : pGuardPattern4.getPredicate()) {
                cgGuardExpressions.add((CGPredicate)this.doVisit(CGPredicate.class, (Element)asPredicate));
            }
        }
    }

    @NonNull
    public CGFunctionParameter getFunctionParameter(@NonNull FunctionParameter asFunctionParameter) {
        CGFunctionParameter cgFunctionParameter = (CGFunctionParameter)this.getVariablesStack().getParameter((Variable)asFunctionParameter);
        if (cgFunctionParameter == null) {
            cgFunctionParameter = QVTiCGModelFactory.eINSTANCE.createCGFunctionParameter();
            ((CodeGenAnalyzer)this.context).setNames((CGValuedElement)cgFunctionParameter, (Object)asFunctionParameter);
            this.setAst((CGTypedElement)cgFunctionParameter, (TypedElement)asFunctionParameter);
            cgFunctionParameter.setTypeId(((CodeGenAnalyzer)this.context).getTypeId(asFunctionParameter.getTypeId()));
            this.addParameter((Variable)asFunctionParameter, cgFunctionParameter);
        }
        return cgFunctionParameter;
    }

    @NonNull
    public CGGuardVariable getGuardVariable(@NonNull Variable asVariable) {
        CGGuardVariable cgGuardVariable = (CGGuardVariable)this.getVariablesStack().getParameter(asVariable);
        cgGuardVariable = QVTiCGModelFactory.eINSTANCE.createCGGuardVariable();
        ((CodeGenAnalyzer)this.context).setNames((CGValuedElement)cgGuardVariable, (Object)asVariable);
        this.setAst((CGTypedElement)cgGuardVariable, (TypedElement)asVariable);
        cgGuardVariable.setTypeId(((CodeGenAnalyzer)this.context).getTypeId(asVariable.getTypeId()));
        cgGuardVariable.setTypedModel(this.getTypedModel(asVariable));
        this.addParameter(asVariable, cgGuardVariable);
        return cgGuardVariable;
    }

    @NonNull
    public CGRealizedVariable getRealizedVariable(@NonNull RealizedVariable pRealizedVariable) {
        AS2CGVisitor.Variables variablesStack = this.getVariablesStack();
        CGRealizedVariable cgVariable = (CGRealizedVariable)variablesStack.getVariable((VariableDeclaration)pRealizedVariable);
        if (cgVariable == null) {
            Type pivotType = (Type)DomainUtil.nonNullModel((Object)pRealizedVariable.getType());
            EClassifier eClassifier = (EClassifier)pivotType.getETarget();
            if (eClassifier != null) {
                CGEcoreRealizedVariable cgEcoreRealizedVariable = QVTiCGModelFactory.eINSTANCE.createCGEcoreRealizedVariable();
                cgEcoreRealizedVariable.setEClassifier(eClassifier);
                cgVariable = cgEcoreRealizedVariable;
            }
            if (cgVariable == null) {
                cgVariable = QVTiCGModelFactory.eINSTANCE.createCGRealizedVariable();
            }
            this.setAst((CGTypedElement)cgVariable, (TypedElement)pRealizedVariable);
            cgVariable.setTypedModel(this.getTypedModel((Variable)pRealizedVariable));
            variablesStack.putVariable((VariableDeclaration)pRealizedVariable, (CGVariable)cgVariable);
        }
        return cgVariable;
    }

    @NonNull
    protected CGTypedModel getTypedModel(@NonNull Variable pVariable) {
        Area pArea = (Area)DomainUtil.nonNullState((Object)QVTcoreBaseUtil.getContainingArea((EObject)pVariable));
        TypedModel asTypedModel = null;
        if (pArea instanceof Domain) {
            asTypedModel = (TypedModel)DomainUtil.nonNullState((Object)((Domain)pArea).getTypedModel());
        } else {
            Transformation pTransformation = ((Mapping)pArea).getTransformation();
            asTypedModel = (TypedModel)DomainUtil.nonNullState((Object)pTransformation.getModelParameter(null));
        }
        return (CGTypedModel)DomainUtil.nonNullState((Object)this.analyzer.getTypedModel(asTypedModel));
    }

    @Nullable
    public CGNamedElement visitAssignment(@NonNull Assignment object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitBaseModel(@NonNull BaseModel object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitBottomPattern(@NonNull BottomPattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitCoreDomain(@NonNull CoreDomain object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitCorePattern(@NonNull CorePattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitDomain(@NonNull Domain object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitEnforcementOperation(@NonNull EnforcementOperation object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitFunction(@NonNull Function asFunction) {
        ExpressionInOCL expressionInOCL;
        CGFunction cgFunction = QVTiCGModelFactory.eINSTANCE.createCGFunction();
        this.setAst((CGTypedElement)cgFunction, (TypedElement)asFunction);
        cgFunction.setRequired(asFunction.isRequired());
        for (Parameter pParameter : asFunction.getOwnedParameter()) {
            cgFunction.getParameters().add((CGParameter)this.doVisit(CGParameter.class, (Element)pParameter));
        }
        OpaqueExpression specification = asFunction.getBodyExpression();
        if (specification != null && (expressionInOCL = PivotUtil.getExpressionInOCL((NamedElement)asFunction, (OpaqueExpression)specification)) != null) {
            Variable contextVariable = expressionInOCL.getContextVariable();
            if (contextVariable != null) {
                this.getSelfParameter(contextVariable);
            }
            for (Variable parameterVariable : expressionInOCL.getParameterVariable()) {
                this.getParameter(parameterVariable);
            }
            cgFunction.setBody((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)expressionInOCL.getBodyExpression()));
        }
        this.analyzer.addFunction(asFunction, cgFunction);
        return cgFunction;
    }

    @Nullable
    public CGNamedElement visitFunctionParameter(@NonNull FunctionParameter asFunctionParameter) {
        return this.getFunctionParameter(asFunctionParameter);
    }

    @Nullable
    public CGNamedElement visitGuardPattern(@NonNull GuardPattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitImperativeModel(@NonNull ImperativeModel object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitMapping(@NonNull Mapping pMapping) {
        CGMapping cgMapping = QVTiCGModelFactory.eINSTANCE.createCGMapping();
        this.setAst(cgMapping, (NamedElement)pMapping);
        this.analyzer.addMapping(pMapping, cgMapping);
        CGMappingExp cgMappingExp = QVTiCGModelFactory.eINSTANCE.createCGMappingExp();
        this.setAst((CGNamedElement)cgMappingExp, (NamedElement)pMapping);
        PrimitiveTypeId pivotTypeId = TypeId.BOOLEAN;
        cgMappingExp.setTypeId(((CodeGenAnalyzer)this.context).getTypeId((TypeId)pivotTypeId));
        cgMapping.setBody(cgMappingExp);
        this.doGuards(pMapping, cgMapping, cgMappingExp);
        this.doBottoms(pMapping, cgMappingExp);
        this.createMappingCalls(pMapping, cgMappingExp);
        return cgMapping;
    }

    @Nullable
    public CGNamedElement visitMappingCall(@NonNull MappingCall asMappingCall) {
        CGMappingCall cgMappingCall = QVTiCGModelFactory.eINSTANCE.createCGMappingCall();
        this.setAst((CGTypedElement)cgMappingCall, (TypedElement)asMappingCall);
        ArrayList<CGMappingCallBinding> cgMappingCallBindings = new ArrayList<CGMappingCallBinding>();
        for (MappingCallBinding asMappingCallBinding : asMappingCall.getBinding()) {
            CGMappingCallBinding cgMappingCallBinding = (CGMappingCallBinding)this.doVisit(CGMappingCallBinding.class, (Element)asMappingCallBinding);
            cgMappingCallBindings.add(cgMappingCallBinding);
        }
        Collections.sort(cgMappingCallBindings, new Comparator<CGMappingCallBinding>(){

            @Override
            public int compare(CGMappingCallBinding o1, CGMappingCallBinding o2) {
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareTo(n2);
            }
        });
        cgMappingCall.getMappingCallBindings().addAll(cgMappingCallBindings);
        return cgMappingCall;
    }

    @Nullable
    public CGNamedElement visitMappingCallBinding(@NonNull MappingCallBinding asMappingCallBinding) {
        Variable asBoundVariable = asMappingCallBinding.getBoundVariable();
        CGMappingCallBinding cgMappingCallBinding = QVTiCGModelFactory.eINSTANCE.createCGMappingCallBinding();
        cgMappingCallBinding.setName(asBoundVariable.getName());
        cgMappingCallBinding.setAst((Element)asMappingCallBinding);
        cgMappingCallBinding.setRequired(asBoundVariable.isRequired());
        cgMappingCallBinding.setLoop(asMappingCallBinding.isIsLoop());
        cgMappingCallBinding.setValueOrValues((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asMappingCallBinding.getValue()));
        cgMappingCallBinding.setTypeId(this.analyzer.getTypeId(asBoundVariable.getTypeId()));
        return cgMappingCallBinding;
    }

    @Nullable
    public CGNamedElement visitMiddlePropertyAssignment(@NonNull MiddlePropertyAssignment asPropertyAssignment) {
        CGMiddlePropertyAssignment cgPropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGMiddlePropertyAssignment();
        cgPropertyAssignment.setSlotValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asPropertyAssignment.getSlotExpression()));
        Property asProperty = asPropertyAssignment.getTargetProperty();
        cgPropertyAssignment.setReferredProperty(asProperty);
        cgPropertyAssignment.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.OCL_VOID));
        cgPropertyAssignment.setInitValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asPropertyAssignment.getValue()));
        EStructuralFeature eStructuralFeature = (EStructuralFeature)asProperty.getETarget();
        if (eStructuralFeature != null) {
            try {
                this.genModelHelper.getGetAccessor(eStructuralFeature);
                cgPropertyAssignment.setEStructuralFeature(eStructuralFeature);
            }
            catch (GenModelException genModelException) {
                // empty catch block
            }
        }
        return cgPropertyAssignment;
    }

    @Nullable
    public CGNamedElement visitMiddlePropertyCallExp(@NonNull MiddlePropertyCallExp asMiddlePropertyCallExp) {
        Property asOppositeProperty = (Property)DomainUtil.nonNullModel((Object)asMiddlePropertyCallExp.getReferredProperty());
        Property asProperty = (Property)DomainUtil.nonNullModel((Object)asOppositeProperty.getOpposite());
        this.globalContext.addToMiddleProperty(asOppositeProperty);
        CGMiddlePropertyCallExp cgPropertyCallExp = QVTiCGModelFactory.eINSTANCE.createCGMiddlePropertyCallExp();
        cgPropertyCallExp.setReferredProperty(asOppositeProperty);
        this.setAst((CGTypedElement)cgPropertyCallExp, (TypedElement)asMiddlePropertyCallExp);
        cgPropertyCallExp.setRequired(asProperty.isRequired());
        CGValuedElement cgSource = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asMiddlePropertyCallExp.getSource());
        cgPropertyCallExp.setSource(cgSource);
        return cgPropertyCallExp;
    }

    @NonNull
    public CGValuedElement visitOperationCallExp(@NonNull OperationCallExp asOperationCallExp) {
        Operation pOperation = asOperationCallExp.getReferredOperation();
        if (pOperation instanceof Function) {
            CGFunctionCallExp cgFunctionCallExp = QVTiCGModelFactory.eINSTANCE.createCGFunctionCallExp();
            cgFunctionCallExp.setReferredOperation(pOperation);
            this.setAst((CGTypedElement)cgFunctionCallExp, (TypedElement)asOperationCallExp);
            cgFunctionCallExp.setRequired(pOperation.isRequired());
            for (OCLExpression pArgument : asOperationCallExp.getArgument()) {
                CGValuedElement cgArgument = (CGValuedElement)this.doVisit(CGValuedElement.class, (Element)pArgument);
                cgFunctionCallExp.getArguments().add(cgArgument);
            }
            return cgFunctionCallExp;
        }
        return super.visitOperationCallExp(asOperationCallExp);
    }

    @Nullable
    public CGNamedElement visitPattern(@NonNull Pattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitPredicate(@NonNull Predicate asPredicate) {
        CGPredicate cgPredicate = QVTiCGModelFactory.eINSTANCE.createCGPredicate();
        cgPredicate.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        cgPredicate.setConditionExpression((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asPredicate.getConditionExpression()));
        return cgPredicate;
    }

    @Nullable
    public CGNamedElement visitPropertyAssignment(@NonNull PropertyAssignment asPropertyAssignment) {
        EStructuralFeature eStructuralFeature;
        Property asTargetProperty = (Property)DomainUtil.nonNullModel((Object)asPropertyAssignment.getTargetProperty());
        LibraryProperty libraryProperty = this.metaModelManager.getImplementation(null, asTargetProperty);
        CGPropertyAssignment cgPropertyAssignment = null;
        if (this.isEcoreProperty(libraryProperty) && (eStructuralFeature = (EStructuralFeature)asTargetProperty.getETarget()) != null) {
            try {
                this.genModelHelper.getGetAccessor(eStructuralFeature);
                CGEcorePropertyAssignment cgEcorePropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGEcorePropertyAssignment();
                cgEcorePropertyAssignment.setEStructuralFeature(eStructuralFeature);
                cgPropertyAssignment = cgEcorePropertyAssignment;
            }
            catch (GenModelException genModelException) {
                // empty catch block
            }
        }
        if (cgPropertyAssignment == null) {
            cgPropertyAssignment = QVTiCGModelFactory.eINSTANCE.createCGPropertyAssignment();
        }
        cgPropertyAssignment.setSlotValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asPropertyAssignment.getSlotExpression()));
        cgPropertyAssignment.setReferredProperty(asTargetProperty);
        cgPropertyAssignment.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.OCL_VOID));
        cgPropertyAssignment.setInitValue((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)asPropertyAssignment.getValue()));
        CGExecutorProperty cgExecutorProperty = ((CodeGenAnalyzer)this.context).createExecutorProperty(asTargetProperty);
        cgPropertyAssignment.setExecutorProperty(cgExecutorProperty);
        return cgPropertyAssignment;
    }

    @Nullable
    public CGNamedElement visitRealizedVariable(@NonNull RealizedVariable object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitRule(@NonNull Rule object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitVariableAssignment(@NonNull VariableAssignment object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitTransformation(@NonNull Transformation asTransformation) {
        CGTransformation cgTransformation = QVTiCGModelFactory.eINSTANCE.createCGTransformation();
        this.setAst((CGNamedElement)cgTransformation, (NamedElement)asTransformation);
        List<CGTypedModel> cgTypedModels = cgTransformation.getTypedModels();
        for (TypedModel asTypedModel : asTransformation.getModelParameter()) {
            CGTypedModel cgTypedModel = (CGTypedModel)this.doVisit(CGTypedModel.class, (Element)asTypedModel);
            cgTypedModel.setModelIndex(cgTypedModels.size());
            cgTypedModels.add(cgTypedModel);
        }
        for (Rule asRule : asTransformation.getRule()) {
            CGMapping cgMapping = (CGMapping)this.doVisit(CGMapping.class, (Element)asRule);
            cgTransformation.getMappings().add(cgMapping);
        }
        for (Operation asOperation : asTransformation.getOwnedOperation()) {
            CGOperation cgOperation = (CGOperation)this.doVisit(CGOperation.class, (Element)asOperation);
            cgTransformation.getOperations().add(cgOperation);
        }
        return cgTransformation;
    }

    @Nullable
    public CGNamedElement visitTypedModel(@NonNull TypedModel asTypedModel) {
        CGTypedModel cgTypedModel = QVTiCGModelFactory.eINSTANCE.createCGTypedModel();
        this.setAst(cgTypedModel, (NamedElement)asTypedModel);
        this.analyzer.addTypedModel(asTypedModel, cgTypedModel);
        return cgTypedModel;
    }

    @Nullable
    public CGNamedElement visitUnit(@NonNull Unit object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public CGNamedElement visitVariablePredicate(@NonNull VariablePredicate asPredicate) {
        CGVariablePredicate cgPredicate = QVTiCGModelFactory.eINSTANCE.createCGVariablePredicate();
        cgPredicate.setAst((Element)asPredicate);
        Variable targetVariable = asPredicate.getTargetVariable();
        cgPredicate.setName(targetVariable.getName());
        cgPredicate.setTypeId(this.analyzer.getTypeId((TypeId)TypeId.BOOLEAN));
        OCLExpression conditionExpression = asPredicate.getConditionExpression();
        cgPredicate.setConditionExpression((CGValuedElement)this.doVisit(CGValuedElement.class, (Element)conditionExpression));
        CGVariable cgVariable = this.createCGVariable(targetVariable);
        cgPredicate.setPredicateVariable(cgVariable);
        return cgPredicate;
    }
}

