/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.lib;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.m2m.atl.engine.emfvm.lib.ReferenceModel;

public class Model {
    protected static ResourceSet resourceSet;
    protected ReferenceModel referenceModel;
    protected Resource resource;
    private boolean canDisposeOfEMFResource;
    public boolean isTarget = false;
    private Map elementsByType = new HashMap();
    private List delayedInvocations = new ArrayList();

    static {
        Map etfm = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        if (!etfm.containsKey("*")) {
            etfm.put("*", new XMIResourceFactoryImpl());
        }
        resourceSet = new ResourceSetImpl();
        Map loadOptions = resourceSet.getLoadOptions();
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
    }

    public Model(ReferenceModel referenceModel, URL url) throws IOException {
        this(referenceModel, URI.createURI((String)url.toString()), false);
    }

    public Model(ReferenceModel referenceModel, URI uri, boolean createNewModel) throws IOException {
        this.referenceModel = referenceModel;
        this.resource = createNewModel ? resourceSet.createResource(uri) : resourceSet.getResource(uri, true);
        this.canDisposeOfEMFResource = true;
    }

    public Model(ReferenceModel referenceModel, Resource resource) {
        this.referenceModel = referenceModel;
        this.resource = resource;
        this.canDisposeOfEMFResource = false;
    }

    protected Model(Resource resource) {
        this.referenceModel = (ReferenceModel)this;
        this.resource = resource;
        this.canDisposeOfEMFResource = false;
    }

    public Set getElementsByType(EClass metaElement) {
        LinkedHashSet<EObject> ret = (LinkedHashSet<EObject>)this.elementsByType.get(metaElement);
        if (ret == null) {
            ret = new LinkedHashSet<EObject>();
            Iterator i = this.getContents();
            while (i.hasNext()) {
                EObject element = (EObject)i.next();
                if (!metaElement.isInstance((Object)element)) continue;
                ret.add(element);
            }
            this.elementsByType.put(metaElement, ret);
        }
        return ret;
    }

    public ReferenceModel getReferenceModel() {
        return this.referenceModel;
    }

    public EObject newElement(EClass metaElement) {
        EObject ret = null;
        ret = metaElement.getEPackage().getEFactoryInstance().create(metaElement);
        this.resource.getContents().add((Object)ret);
        return ret;
    }

    public Iterator getContents() {
        return this.resource.getAllContents();
    }

    public void save(String uri) throws IOException {
        this.save(URI.createURI((String)uri));
    }

    public void save(URI uri) throws IOException {
        this.commitToResource();
        this.resource.setURI(uri);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", "ISO-8859-1");
        options.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.FALSE);
        this.resource.save(options);
    }

    public void commitToResource() {
        ArrayList<EObject> toDelete = new ArrayList<EObject>();
        TreeIterator i = this.resource.getAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (eo.eContainer() == null) continue;
            toDelete.add(eo);
        }
        this.resource.getContents().removeAll(toDelete);
        try {
            this.applyDelayedInvocations();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void dispose() {
        if (this.canDisposeOfEMFResource) {
            resourceSet.getResources().remove((Object)this.resource);
        }
        if (this != this.referenceModel) {
            this.resource = null;
        }
    }

    public boolean contains(EObject eo) {
        TreeIterator i = this.resource.getAllContents();
        while (i.hasNext()) {
            EObject current = (EObject)i.next();
            if (!current.equals(eo)) continue;
            return true;
        }
        return false;
    }

    public void addDelayedInvocation(Method method, Object self, String opName, Object[] arguments) {
        this.addDelayedInvocation(new Invocation(method, self, opName, arguments));
    }

    private void addDelayedInvocation(Invocation invocation) {
        if (invocation.opName.equals("applyProfile")) {
            this.delayedInvocations.add(0, invocation);
        } else if (invocation.opName.equals("applyStereotype") || invocation.opName.equals("applyAllStereotypes") || invocation.opName.equals("applyAllRequiredStereotypes")) {
            int lastApplyProfile = this.getLastStereotypeMethod("applyProfile", this.delayedInvocations);
            if (lastApplyProfile < this.delayedInvocations.size() - 1) {
                this.delayedInvocations.add(lastApplyProfile + 1, invocation);
            } else {
                this.delayedInvocations.add(invocation);
            }
        } else {
            this.delayedInvocations.add(invocation);
        }
    }

    private int getLastStereotypeMethod(String opName, List delayedInvocations) {
        int rang = 0;
        int i = 0;
        while (i < delayedInvocations.size()) {
            Invocation invoc = (Invocation)delayedInvocations.get(rang);
            if (invoc.opName.equals(opName)) {
                rang = i;
            }
            ++i;
        }
        return rang;
    }

    private void applyDelayedInvocations() throws InvocationTargetException, IllegalAccessException {
        for (Invocation invocation : this.delayedInvocations) {
            invocation.method.invoke(invocation.self, invocation.arguments);
        }
    }

    private class Invocation {
        public Method method;
        public Object self;
        public String opName;
        public Object[] arguments;

        public Invocation(Method method, Object self, String opName, Object[] arguments) {
            this.method = method;
            this.self = self;
            this.opName = opName;
            this.arguments = arguments;
        }
    }
}

