/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.rest;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import jakarta.inject.Inject;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.telemetry.tracing.tck.TestLibraries;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporterProvider;
import org.eclipse.microprofile.telemetry.tracing.tck.rest.PropagationHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class W3BaggagePropagationTest
extends Arquillian {
    @ArquillianResource
    private URL url;
    @Inject
    private InMemorySpanExporter spanExporter;
    private PropagationHelper.SpanResourceClient client;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemorySpanExporter.class, InMemorySpanExporterProvider.class, PropagationHelper.class, PropagationHelper.SpanResourceClient.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsServiceProvider(ConfigurableSpanExporterProvider.class, new Class[]{InMemorySpanExporterProvider.class})).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.traces.exporter=in-memory\notel.propagators=tracecontext,baggage"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.spanExporter != null) {
            this.spanExporter.reset();
            try {
                this.client = (PropagationHelper.SpanResourceClient)RestClientBuilder.newBuilder().baseUri(this.url.toURI()).build(PropagationHelper.SpanResourceClient.class);
            }
            catch (IllegalStateException | URISyntaxException | RestClientDefinitionException e) {
                Assert.fail((String)"Failed to create rest client", (Throwable)e);
            }
        }
    }

    @Test
    void span() {
        Baggage baggage = Baggage.builder().put("test.baggage.key", "test.baggage.value", BaggageEntryMetadata.create((String)"test.baggage.metadata")).build();
        try (Scope s = baggage.makeCurrent();){
            this.client.span();
        }
        this.spanExporter.assertSpanCount(2);
        SpanData server = this.spanExporter.getFirst(SpanKind.SERVER);
        Assert.assertEquals((String)"test.baggage.value", (String)((String)server.getAttributes().get(PropagationHelper.BAGGAGE_VALUE_ATTR)));
        Assert.assertEquals((String)"test.baggage.metadata", (String)((String)server.getAttributes().get(PropagationHelper.BAGGAGE_METADATA_ATTR)));
        Assert.assertTrue((boolean)((List)server.getAttributes().get(PropagationHelper.PROPAGATION_HEADERS_ATTR)).contains("traceparent"));
        Assert.assertTrue((boolean)((List)server.getAttributes().get(PropagationHelper.PROPAGATION_HEADERS_ATTR)).contains("baggage"));
    }
}

