/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics;

import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import jakarta.inject.Inject;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.common.TimeoutMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.InMemoryMetricReader;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.PullExporterAutoConfigurationCustomizerProvider;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TimeoutTelemetryTest
extends Arquillian {
    @Inject
    private TimeoutMetricBean timeoutBean;

    @Deployment
    public static WebArchive deploy() {
        Properties props = new Properties();
        props.put("otel.sdk.disabled", "false");
        props.put("otel.traces.exporter", "none");
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().setValue(TimeoutMetricBean.class, "counterTestWorkForMillis", Timeout.class, TCKConfig.getConfig().getTimeoutInStr(500L)).setValue(TimeoutMetricBean.class, "histogramTestWorkForMillis", Timeout.class, TCKConfig.getConfig().getTimeoutInStr(2000L)).mergeProperties(props);
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftMetricTimeout.jar")).addClasses(new Class[]{TimeoutMetricBean.class})).addPackage(Packages.UTILS)).addPackage(Packages.TELEMETRY_METRIC_UTILS)).addAsManifestResource((Asset)config, "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsServiceProvider(AutoConfigurationCustomizerProvider.class, new Class[]{PullExporterAutoConfigurationCustomizerProvider.class});
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricTimeout.war")).addAsLibrary((Archive)jar);
        return war;
    }

    @Test
    public void testTimeoutMetric() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(TimeoutMetricBean.class, "counterTestWorkForMillis");
        m.baselineMetrics();
        Exceptions.expectTimeout(() -> this.timeoutBean.counterTestWorkForMillis(TCKConfig.getConfig().getTimeoutInMillis(2000L)));
        Exceptions.expectTimeout(() -> this.timeoutBean.counterTestWorkForMillis(TCKConfig.getConfig().getTimeoutInMillis(2000L)));
        this.timeoutBean.counterTestWorkForMillis(TCKConfig.getConfig().getTimeoutInMillis(100L));
        MatcherAssert.assertThat((String)"calls timed out", (Object)m.getTimeoutCalls(TelemetryMetricDefinition.TimeoutTimedOut.TRUE).delta(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"calls not timed out", (Object)m.getTimeoutCalls(TelemetryMetricDefinition.TimeoutTimedOut.FALSE).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful invocations", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed invocations", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)2L));
    }

    @Test
    public void testTimeoutHistogram() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(TimeoutMetricBean.class, "histogramTestWorkForMillis");
        this.timeoutBean.histogramTestWorkForMillis(TCKConfig.getConfig().getTimeoutInMillis(300L));
        Exceptions.expectTimeout(() -> this.timeoutBean.histogramTestWorkForMillis(TCKConfig.getConfig().getTimeoutInMillis(5000L)));
        m.getTimeoutExecutionDuration().assertBucketCounts(300L, 2000L);
        m.getTimeoutExecutionDuration().assertBoundaries();
    }

    @Test(dependsOnMethods={"testTimeoutMetric", "testTimeoutHistogram"})
    public void testMetricUnits() throws InterruptedException, ExecutionException {
        InMemoryMetricReader reader = InMemoryMetricReader.current();
        for (TelemetryMetricDefinition metric : TelemetryMetricDefinition.values()) {
            if (!metric.getName().startsWith("ft.timeout")) continue;
            String unit = reader.getUnit(metric.getName());
            if (metric.getUnit() == null) {
                Assert.assertTrue((boolean)unit.isEmpty(), (String)("Unexpected metadata for metric " + metric.getName()));
                continue;
            }
            Assert.assertFalse((boolean)unit.isEmpty(), (String)("Missing metadata for metric " + metric.getName()));
            Assert.assertEquals((String)unit, (String)metric.getUnit(), (String)("Incorrect unit for metric " + metric.getName()));
        }
    }
}

