/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics;

import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.common.RetryMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.InMemoryMetricReader;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.PullExporterAutoConfigurationCustomizerProvider;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RetryTelemetryTest
extends Arquillian {
    @Inject
    private RetryMetricBean retryBean;

    @Deployment
    public static WebArchive deploy() {
        Properties props = new Properties();
        props.put("otel.sdk.disabled", "false");
        props.put("otel.traces.exporter", "none");
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().autoscaleMethod(RetryMetricBean.class, "failAfterDelay").mergeProperties(props);
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftMetricRetry.jar")).addClasses(new Class[]{RetryMetricBean.class})).addPackage(Packages.UTILS)).addPackage(Packages.TELEMETRY_METRIC_UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsManifestResource((Asset)config, "microprofile-config.properties")).addAsServiceProvider(AutoConfigurationCustomizerProvider.class, new Class[]{PullExporterAutoConfigurationCustomizerProvider.class});
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricRetry.war")).addAsLibrary((Archive)jar);
        return war;
    }

    @Test
    public void testRetryMetricSuccessfulImmediately() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(RetryMetricBean.class, "failSeveralTimes");
        m.baselineMetrics();
        this.retryBean.failSeveralTimes(0, new RetryMetricBean.CallCounter());
        this.assertRetryCallsIncremented(m, TelemetryMetricDefinition.RetryRetried.FALSE, TelemetryMetricDefinition.RetryResult.VALUE_RETURNED, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testRetryMetricSuccessfulAfterRetry() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(RetryMetricBean.class, "failSeveralTimes");
        m.baselineMetrics();
        this.retryBean.failSeveralTimes(3, new RetryMetricBean.CallCounter());
        this.assertRetryCallsIncremented(m, TelemetryMetricDefinition.RetryRetried.TRUE, TelemetryMetricDefinition.RetryResult.VALUE_RETURNED, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testRetryMetricNonRetryableImmediately() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(RetryMetricBean.class, "failSeveralTimesThenNonRetryable");
        m.baselineMetrics();
        Assert.expectThrows(RetryMetricBean.NonRetryableException.class, () -> this.retryBean.failSeveralTimesThenNonRetryable(0, new RetryMetricBean.CallCounter()));
        this.assertRetryCallsIncremented(m, TelemetryMetricDefinition.RetryRetried.FALSE, TelemetryMetricDefinition.RetryResult.EXCEPTION_NOT_RETRYABLE, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testRetryMetricNonRetryableAfterRetries() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(RetryMetricBean.class, "failSeveralTimesThenNonRetryable");
        m.baselineMetrics();
        Assert.expectThrows(RetryMetricBean.NonRetryableException.class, () -> this.retryBean.failSeveralTimesThenNonRetryable(3, new RetryMetricBean.CallCounter()));
        this.assertRetryCallsIncremented(m, TelemetryMetricDefinition.RetryRetried.TRUE, TelemetryMetricDefinition.RetryResult.EXCEPTION_NOT_RETRYABLE, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testRetryMetricMaxRetries() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(RetryMetricBean.class, "failSeveralTimes");
        m.baselineMetrics();
        Exceptions.expectTestException(() -> this.retryBean.failSeveralTimes(20, new RetryMetricBean.CallCounter()));
        Exceptions.expectTestException(() -> this.retryBean.failSeveralTimes(20, new RetryMetricBean.CallCounter()));
        this.assertRetryCallsIncremented(m, TelemetryMetricDefinition.RetryRetried.TRUE, TelemetryMetricDefinition.RetryResult.MAX_RETRIES_REACHED, 2L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)10L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)2L));
    }

    @Test
    public void testRetryMetricMaxRetriesHitButNoRetry() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(RetryMetricBean.class, "maxRetriesZero");
        m.baselineMetrics();
        Exceptions.expectTestException(() -> this.retryBean.maxRetriesZero());
        this.assertRetryCallsIncremented(m, TelemetryMetricDefinition.RetryRetried.FALSE, TelemetryMetricDefinition.RetryResult.MAX_RETRIES_REACHED, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testRetryMetricMaxDuration() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(RetryMetricBean.class, "failAfterDelay");
        m.baselineMetrics();
        Duration testDelay = TCKConfig.getConfig().getTimeoutInDuration(100);
        Exceptions.expectTestException(() -> this.retryBean.failAfterDelay(testDelay));
        this.assertRetryCallsIncremented(m, TelemetryMetricDefinition.RetryRetried.TRUE, TelemetryMetricDefinition.RetryResult.MAX_DURATION_REACHED, 1L);
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testRetryMetricMaxDurationNoRetries() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(RetryMetricBean.class, "failAfterDelay");
        m.baselineMetrics();
        Duration testDelay = TCKConfig.getConfig().getTimeoutInDuration(1500);
        Exceptions.expectTestException(() -> this.retryBean.failAfterDelay(testDelay));
        this.assertRetryCallsIncremented(m, TelemetryMetricDefinition.RetryRetried.FALSE, TelemetryMetricDefinition.RetryResult.MAX_DURATION_REACHED, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test(dependsOnMethods={"testRetryMetricSuccessfulImmediately", "testRetryMetricSuccessfulAfterRetry", "testRetryMetricNonRetryableImmediately", "testRetryMetricNonRetryableAfterRetries", "testRetryMetricMaxRetries", "testRetryMetricMaxRetriesHitButNoRetry", "testRetryMetricMaxDuration", "testRetryMetricMaxDurationNoRetries"})
    public void testMetricUnits() throws InterruptedException, ExecutionException {
        InMemoryMetricReader reader = InMemoryMetricReader.current();
        for (TelemetryMetricDefinition metric : TelemetryMetricDefinition.values()) {
            if (!metric.getName().startsWith("ft.retry")) continue;
            String unit = reader.getUnit(metric.getName());
            if (metric.getUnit() == null) {
                Assert.assertTrue((boolean)unit.isEmpty(), (String)("Unexpected metadata for metric " + metric.getName()));
                continue;
            }
            Assert.assertFalse((boolean)unit.isEmpty(), (String)("Missing metadata for metric " + metric.getName()));
            Assert.assertEquals((String)unit, (String)metric.getUnit(), (String)("Incorrect unit for metric " + metric.getName()));
        }
    }

    private void assertRetryCallsIncremented(TelemetryMetricGetter m, TelemetryMetricDefinition.RetryRetried retriedValue, TelemetryMetricDefinition.RetryResult resultValue, Long expectedDelta) {
        for (TelemetryMetricDefinition.RetryRetried retried : TelemetryMetricDefinition.RetryRetried.values()) {
            for (TelemetryMetricDefinition.RetryResult result : TelemetryMetricDefinition.RetryResult.values()) {
                if (retried == retriedValue && result == resultValue) {
                    MatcherAssert.assertThat((String)("Retry calls (" + retried + ", " + result + ")"), (Object)m.getRetryCalls(retried, result).delta(), (Matcher)Matchers.is((Object)expectedDelta));
                    continue;
                }
                MatcherAssert.assertThat((String)("Retry calls (" + retried + ", " + result + ")"), (Object)m.getRetryCalls(retried, result).delta(), (Matcher)Matchers.is((Object)0L));
            }
        }
    }
}

