/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import jakarta.inject.Inject;
import java.time.Duration;
import java.util.function.Consumer;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead1Retry0MethodSyncBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead1Retry1SyncClassBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead1Retry1SyncMethodBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead1RetryManySyncClassBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead1RetryManySyncMethodBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadRetryAbortOnSyncBean;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncTaskManager;
import org.eclipse.microprofile.fault.tolerance.tck.util.Barrier;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class BulkheadSynchRetryTest
extends Arquillian {
    @Inject
    private Bulkhead1RetryManySyncMethodBean longRetryMethodBean;
    @Inject
    private Bulkhead1RetryManySyncClassBean longRetryClassBean;
    @Inject
    private Bulkhead1Retry1SyncMethodBean retry1DelayMethodBean;
    @Inject
    private Bulkhead1Retry1SyncClassBean retry1DelayClassBean;
    @Inject
    private BulkheadRetryAbortOnSyncBean retryAbortOnBean;
    @Inject
    private Bulkhead1Retry0MethodSyncBean zeroRetryBean;

    @Deployment
    public static WebArchive deploy() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().autoscaleMethod(Bulkhead1RetryManySyncMethodBean.class, "test").autoscaleClass(Bulkhead1RetryManySyncClassBean.class).autoscaleMethod(Bulkhead1Retry1SyncMethodBean.class, "test").autoscaleClass(Bulkhead1Retry1SyncClassBean.class).autoscaleClass(BulkheadRetryAbortOnSyncBean.class).autoscaleMethod(Bulkhead1Retry0MethodSyncBean.class, "test");
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadSynchRetryTest.jar")).addPackage(Bulkhead1RetryManySyncMethodBean.class.getPackage())).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsManifestResource((Asset)config, "microprofile-config.properties");
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadSynchRetryTest.war")).addAsLibrary((Archive)testJar);
    }

    public void testRetryBulkheadExceptionMethod() throws InterruptedException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask<Void> taskA = taskManager.runBarrierTask(this.longRetryMethodBean::test);
            taskA.assertAwaits();
            AsyncTaskManager.BarrierTask<Void> taskB = taskManager.runBarrierTask(this.longRetryMethodBean::test);
            taskB.assertNotAwaiting();
            taskA.openBarrier();
            taskA.assertSuccess();
            taskB.assertAwaits();
            taskB.openBarrier();
            taskB.assertSuccess();
        }
    }

    public void testRetryBulkheadExceptionClass() throws InterruptedException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask<Void> taskA = taskManager.runBarrierTask(this.longRetryClassBean::test);
            taskA.assertAwaits();
            AsyncTaskManager.BarrierTask<Void> taskB = taskManager.runBarrierTask(this.longRetryClassBean::test);
            taskB.assertNotAwaiting();
            taskA.openBarrier();
            taskA.assertSuccess();
            taskB.assertAwaits();
            taskB.openBarrier();
            taskB.assertSuccess();
        }
    }

    @Test
    public void testRetryTestExceptionClass() throws InterruptedException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask<Void> taskA = taskManager.runBarrierTask(barrier -> this.retry1DelayClassBean.test((Barrier)barrier, new TestException()));
            taskA.assertAwaits();
            taskA.openBarrier();
            Thread.sleep(TCKConfig.getConfig().getTimeoutInMillis(100L));
            AsyncTaskManager.BarrierTask<Void> taskB = taskManager.runBarrierTask(barrier -> this.retry1DelayClassBean.test((Barrier)barrier, null));
            taskB.assertAwaits();
            taskA.assertThrows(BulkheadException.class);
            taskB.openBarrier();
            taskB.assertSuccess();
        }
    }

    @Test
    public void testRetryTestExceptionMethod() throws InterruptedException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask<Void> taskA = taskManager.runBarrierTask(barrier -> this.retry1DelayMethodBean.test((Barrier)barrier, new TestException()));
            taskA.assertAwaits();
            taskA.openBarrier();
            Thread.sleep(TCKConfig.getConfig().getTimeoutInMillis(100L));
            AsyncTaskManager.BarrierTask<Void> taskB = taskManager.runBarrierTask(barrier -> this.retry1DelayMethodBean.test((Barrier)barrier, null));
            taskB.assertAwaits();
            taskA.assertThrows(BulkheadException.class);
            taskB.openBarrier();
            taskB.assertSuccess();
        }
    }

    @Test
    public void testNoRetriesWithoutRetryOn() {
        BulkheadSynchRetryTest.testNoRetries(barrier -> this.retry1DelayClassBean.test((Barrier)barrier, null));
    }

    @Test
    public void testNoRetriesWithAbortOn() {
        BulkheadSynchRetryTest.testNoRetries(this.retryAbortOnBean::test);
    }

    @Test
    public void testNoRetriesWithMaxRetriesZero() {
        BulkheadSynchRetryTest.testNoRetries(this.zeroRetryBean::test);
    }

    private static void testNoRetries(Consumer<Barrier> testMethod) {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask<Void> taskA = taskManager.runBarrierTask(testMethod);
            taskA.assertAwaits();
            long startTime = System.nanoTime();
            AsyncTaskManager.BarrierTask<Void> taskB = taskManager.runBarrierTask(testMethod);
            taskB.assertThrows(BulkheadException.class);
            long endTime = System.nanoTime();
            MatcherAssert.assertThat((String)"Task took to long to return, may have done retries", (Object)Duration.ofNanos(endTime - startTime), (Matcher)Matchers.lessThan((Comparable)TCKConfig.getConfig().getTimeoutInDuration(800)));
        }
    }
}

