/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import jakarta.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.fallback.clientserver.FallbackClassLevelClient;
import org.eclipse.microprofile.fault.tolerance.tck.fallback.clientserver.FallbackClient;
import org.eclipse.microprofile.fault.tolerance.tck.fallback.clientserver.FallbackOnlyClient;
import org.eclipse.microprofile.fault.tolerance.tck.fallback.clientserver.FallbackWithBeanClient;
import org.eclipse.microprofile.fault.tolerance.tck.fallback.clientserver.MyBean;
import org.eclipse.microprofile.fault.tolerance.tck.fallback.clientserver.SecondStringFallbackHandler;
import org.eclipse.microprofile.fault.tolerance.tck.fallback.clientserver.StringFallbackHandler;
import org.eclipse.microprofile.fault.tolerance.tck.fallback.clientserver.StringFallbackHandlerWithBean;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FallbackTest
extends Arquillian {
    @Inject
    private FallbackClient fallbackClient;
    @Inject
    private FallbackWithBeanClient fallbackWithBeanClient;
    @Inject
    private FallbackClassLevelClient fallbackClassLevelClient;
    @Inject
    private FallbackOnlyClient fallbackOnlyClient;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftfallback.jar")).addClasses(new Class[]{FallbackClient.class, FallbackWithBeanClient.class, FallbackClassLevelClient.class, StringFallbackHandler.class, SecondStringFallbackHandler.class, StringFallbackHandlerWithBean.class, MyBean.class, FallbackOnlyClient.class, TestException.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftFallback.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testFallbackSuccess() {
        String result;
        try {
            result = this.fallbackClient.serviceA();
            Assert.assertTrue((boolean)result.contains("serviceA"), (String)"The message should be \"fallback for serviceA\"");
        }
        catch (TestException ex) {
            Assert.fail((String)"serviceA should not throw a TestException in testFallbackSuccess", (Throwable)ex);
        }
        Assert.assertEquals((int)this.fallbackClient.getCounterForInvokingServiceA(), (int)2, (String)"The execution count should be 2 (1 retry + 1)");
        try {
            result = this.fallbackClient.serviceB();
            Assert.assertTrue((boolean)result.contains("serviceB"), (String)"The message should be \"fallback for serviceB\"");
        }
        catch (TestException ex) {
            Assert.fail((String)"serviceB should not throw a TestException in testFallbackSuccess", (Throwable)ex);
        }
        Assert.assertEquals((int)this.fallbackClient.getCounterForInvokingServiceB(), (int)3, (String)"The execution count should be 3 (2 retries + 1)");
    }

    @Test
    public void testFallbackWithBeanSuccess() {
        String result;
        try {
            result = this.fallbackWithBeanClient.serviceA();
            Assert.assertTrue((boolean)result.contains("serviceA"), (String)"The message should be \"fallback for serviceA\"");
            Assert.assertTrue((boolean)result.contains("34"), (String)"The message should be \"fallback for serviceA myBean.getCount()=34\"");
        }
        catch (TestException ex) {
            Assert.fail((String)"serviceA should not throw a TestException in testFallbackWithBeanSuccess", (Throwable)ex);
        }
        Assert.assertEquals((int)this.fallbackWithBeanClient.getCounterForInvokingServiceA(), (int)2, (String)"The execution count should be 2 (1 retry + 1)");
        try {
            result = this.fallbackWithBeanClient.serviceB();
            Assert.assertTrue((boolean)result.contains("serviceB"), (String)"The message should be \"fallback for serviceB\"");
            Assert.assertTrue((boolean)result.contains("35"), (String)"The message should be \"fallback for serviceB myBean.getCount()=35\"");
        }
        catch (TestException ex) {
            Assert.fail((String)"serviceB should not throw a TestException in testFallbackWithBeanSuccess", (Throwable)ex);
        }
        Assert.assertEquals((int)this.fallbackWithBeanClient.getCounterForInvokingServiceB(), (int)3, (String)"The execution count should be 3 (2 retries + 1)");
    }

    @Test
    public void testClassLevelFallbackSuccess() {
        String result;
        try {
            result = this.fallbackClassLevelClient.serviceA();
            Assert.assertTrue((boolean)result.contains("serviceA"), (String)"The message should be \"fallback for serviceA\"");
        }
        catch (TestException ex) {
            Assert.fail((String)"serviceA should not throw a TestException in testFallbackSuccess", (Throwable)ex);
        }
        Assert.assertEquals((int)this.fallbackClassLevelClient.getCounterForInvokingServiceA(), (int)2, (String)"The execution count should be 2 (1 retry + 1)");
        try {
            result = this.fallbackClassLevelClient.serviceB();
            Assert.assertTrue((boolean)result.contains("second fallback for serviceB"), (String)"The message should be \"second fallback for serviceB\"");
            Assert.assertTrue((boolean)result.contains(TestException.class.getName()), (String)("The message should be " + TestException.class.getName()));
        }
        catch (TestException ex) {
            Assert.fail((String)"serviceB should not throw a TestException in testFallbackSuccess", (Throwable)ex);
        }
        Assert.assertEquals((int)this.fallbackClassLevelClient.getCounterForInvokingServiceB(), (int)3, (String)"The execution count should be 3 (2 retries + 1)");
    }

    @Test
    public void testFallbacktNoTimeout() {
        try {
            String result = this.fallbackClient.serviceC(10L);
            Assert.assertTrue((boolean)result.contains("serviceC"), (String)"The message should be \"fallback for serviceC\"");
        }
        catch (TimeoutException ex) {
            Assert.fail((String)"serviceC should not throw a TimeoutException in testFallbacktNoTimeout");
        }
        catch (TestException ex) {
            Assert.fail((String)"serviceC should not throw a TestException in testFallbacktNoTimeout", (Throwable)ex);
        }
        Assert.assertEquals((int)this.fallbackClient.getCounterForInvokingServiceC(), (int)2, (String)"The execution count should be 2 (1 retry + 1)");
    }

    @Test
    public void testFallbackTimeout() {
        try {
            String result = this.fallbackClient.serviceC(1000L);
            Assert.assertTrue((boolean)result.contains("serviceC"), (String)"The message should be \"fallback for serviceC\"");
        }
        catch (TimeoutException ex) {
            Assert.fail((String)"serviceC should not throw a TimeoutException in testFallbackTimeout");
        }
        catch (TestException ex) {
            Assert.fail((String)"serviceC should not throw a TestException in testFallbackTimeout", (Throwable)ex);
        }
        Assert.assertEquals((int)this.fallbackClient.getCounterForInvokingServiceC(), (int)2, (String)"The execution count should be 2 (1 retry + 1)");
    }

    @Test
    public void testFallbackMethodSuccess() {
        try {
            String result = this.fallbackClient.serviceD();
            Assert.assertTrue((boolean)result.contains("method for serviceD"), (String)"The message should be \"fallback method for serviceD\"");
        }
        catch (TestException ex) {
            Assert.fail((String)"serviceD should not throw a RuntimeException in testFallbackMethodSuccess", (Throwable)ex);
        }
        Assert.assertEquals((int)this.fallbackClient.getCounterForInvokingServiceD(), (int)2, (String)"The execution count should be 2 (1 retry + 1)");
    }

    @Test
    public void testFallbackMethodWithArgsSuccess() {
        try {
            String result = this.fallbackClient.serviceE("serviceE", 42);
            Assert.assertTrue((boolean)result.contains("method for serviceE"), (String)"The message should be \"fallback method for serviceE\"");
        }
        catch (TestException ex) {
            Assert.fail((String)"serviceE should not throw a RuntimeException in testFallbackMethodWithArgsSuccess", (Throwable)ex);
        }
        Assert.assertEquals((int)this.fallbackClient.getCounterForInvokingServiceE(), (int)2, (String)"The execution count should be 2 (1 retry + 1)");
    }

    @Test
    public void testStandaloneHandlerFallback() {
        try {
            String result = this.fallbackOnlyClient.serviceA();
            Assert.assertTrue((boolean)result.contains("serviceA"), (String)"The message should be \"fallback for serviceA\"");
        }
        catch (TestException ex) {
            Assert.fail((String)"serviceA should not throw a RuntimeException in testStandaloneClassLevelFallback", (Throwable)ex);
        }
        Assert.assertEquals((int)this.fallbackOnlyClient.getCounterForInvokingServiceA(), (int)1, (String)"The getCounterForInvokingServiceA should be 1");
    }

    @Test
    public void testStandaloneMethodFallback() {
        try {
            String result = this.fallbackOnlyClient.serviceB();
            Assert.assertTrue((boolean)result.contains("serviceB"), (String)"The message should be \"fallback method for serviceB\"");
        }
        catch (TestException ex) {
            Assert.fail((String)"serviceB should not throw a RuntimeException in testStandaloneMethodFallback", (Throwable)ex);
        }
        Assert.assertEquals((int)this.fallbackOnlyClient.getCounterForInvokingServiceB(), (int)1, (String)"The getCounterForInvokingServiceB should be 1");
    }
}

