/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.pullup;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.pullup.AcceleoPullUpFirstInputWizardPage;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.pullup.AcceleoPullUpRefactoring;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.pullup.AcceleoPullUpSecondInputWizardPage;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;

public class AcceleoPullUpWizard
extends RefactoringWizard {
    public AcceleoPullUpWizard(Refactoring refactoring, String name) {
        super(refactoring, 36);
        this.setDefaultPageTitle(name);
    }

    protected void addUserInputPages() {
        Refactoring refactoring = this.getRefactoring();
        if (refactoring instanceof AcceleoPullUpRefactoring) {
            AcceleoPullUpRefactoring acceleoPullUpRefactoring = (AcceleoPullUpRefactoring)refactoring;
            Module module = acceleoPullUpRefactoring.getModule();
            this.addPage((IWizardPage)new AcceleoPullUpFirstInputWizardPage(AcceleoUIMessages.getString("AcceleoEditorPullUpRefactoring.PullUpFirstInputWizardPage"), module));
            this.addPage((IWizardPage)new AcceleoPullUpSecondInputWizardPage(AcceleoUIMessages.getString("AcceleoEditorPullUpRefactoring.PullUpSecondInputWizardPage")));
        }
    }

    public boolean performCancel() {
        Refactoring refactoring = this.getRefactoring();
        if (refactoring instanceof AcceleoPullUpRefactoring) {
            AcceleoPullUpRefactoring acceleoPullUpRefactoring = (AcceleoPullUpRefactoring)refactoring;
            IContainer iContainer = acceleoPullUpRefactoring.getContainer();
            String fileName = acceleoPullUpRefactoring.getFileName();
            if (iContainer == null || fileName == null) {
                return super.performCancel();
            }
            IResource member = iContainer.findMember(fileName);
            if (member instanceof IFile && acceleoPullUpRefactoring.isPullUpInNewFile()) {
                try {
                    member.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
                }
            }
        }
        return super.performCancel();
    }
}

