/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint.description.util;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.sirius.business.internal.migration.IMigrationHandler;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class DescriptionResourceImpl
extends XMIResourceImpl {
    public static final String OPTION_USE_URI_FRAGMENT_AS_ID = "SIRIUS_USE_URI_FRAGMENT_AS_ID";
    private boolean useURIFragmentAsId;
    private Optional<IMigrationHandler> migrationHandler = Optional.ofNullable(SiriusPlugin.getDefault().getMigrationHandler());

    protected DescriptionResourceImpl(URI uri) {
        super(uri);
    }

    protected XMLHelper createXMLHelper() {
        if (!this.migrationHandler.isPresent()) {
            return super.createXMLHelper();
        }
        return this.migrationHandler.get().createXMLHelper((XMLResource)this);
    }

    protected XMLLoad createXMLLoad(Map<?, ?> options) {
        XMLLoad xmlLoad = null;
        if (this.migrationHandler.isPresent()) {
            xmlLoad = this.migrationHandler.get().createXMLLoad(options, (XMLResource)this);
        }
        if (xmlLoad == null) {
            xmlLoad = super.createXMLLoad(options);
        }
        return xmlLoad;
    }

    public void setModified(boolean isModified) {
        super.setModified(isModified);
        if (isModified) {
            this.getIDToEObjectMap().clear();
        }
    }

    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded) {
            this.useURIFragmentAsId = Boolean.TRUE.equals(options.get(OPTION_USE_URI_FRAGMENT_AS_ID)) && this.getURI().isPlatformPlugin();
            Resource.Diagnostic migrationMismatchDiagnostic = null;
            if (this.migrationHandler.isPresent()) {
                migrationMismatchDiagnostic = this.migrationHandler.get().handleMigrationOptions(this.getURI(), this.getDefaultLoadOptions(), this.getDefaultSaveOptions());
            }
            super.load(options);
            if (migrationMismatchDiagnostic != null) {
                this.getErrors().add(migrationMismatchDiagnostic);
            }
        }
    }

    public EObject getEObject(String uriFragment) {
        Option<String> optionalRewrittenFragment = Options.newNone();
        if (this.migrationHandler.isPresent()) {
            optionalRewrittenFragment = this.migrationHandler.get().getOptionalRewrittenFragment(uriFragment);
        }
        if (optionalRewrittenFragment.some()) {
            return this.getEObject((String)optionalRewrittenFragment.get());
        }
        if (this.useURIFragmentAsId) {
            return this.getEObjectUsingURIFragmentAsId(uriFragment);
        }
        return super.getEObject(uriFragment);
    }

    private EObject getEObjectUsingURIFragmentAsId(String uriFragment) {
        EObject eObject = null;
        if (this.isLoading) {
            eObject = this.getEObjectAndUpdateIDMap(uriFragment);
        } else {
            eObject = this.getEObjectByID(uriFragment);
            if (eObject == null) {
                eObject = this.getEObjectAndUpdateIDMap(uriFragment);
            }
        }
        return eObject;
    }

    private EObject getEObjectAndUpdateIDMap(String uriFragment) {
        EObject eObject = super.getEObject(uriFragment);
        if (eObject != null) {
            this.setID(eObject, uriFragment);
        }
        return eObject;
    }
}

