/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.logger;

import java.text.MessageFormat;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.logger.MarkerRuntimeLogger;
import org.eclipse.sirius.business.api.logger.RuntimeLogger;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class MarkerRuntimeLoggerImpl
implements RuntimeLogger,
MarkerRuntimeLogger {
    @Override
    public void error(EObject odesignObject, EStructuralFeature feature, String message) {
        MarkerRuntimeLoggerImpl.addMarkerFor(odesignObject, feature, message, 2);
    }

    @Override
    public void error(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
        String message = "";
        if (exception != null) {
            message = exception.getMessage();
        }
        this.error(odesignObject, feature, message);
    }

    @Override
    public void info(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
        String message = "";
        if (exception != null) {
            message = exception.getMessage();
        }
        this.info(odesignObject, feature, message);
    }

    @Override
    public void info(EObject odesignObject, EStructuralFeature feature, String message) {
        MarkerRuntimeLoggerImpl.addMarkerFor(odesignObject, feature, message, 0);
    }

    @Override
    public void warning(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
        String message = "";
        if (exception != null) {
            message = exception.getMessage();
        }
        this.warning(odesignObject, feature, message);
    }

    @Override
    public void warning(EObject odesignObject, EStructuralFeature feature, String message) {
        MarkerRuntimeLoggerImpl.addMarkerFor(odesignObject, feature, message, 1);
    }

    @Override
    public void clearAll() {
    }

    @Override
    public void clear(EObject object) {
        Resource objectResource;
        if (object != null && (objectResource = object.eResource()) != null && objectResource.getURI() != null && objectResource.getURI().isPlatformResource()) {
            IWorkspaceRoot root = EcorePlugin.getWorkspaceRoot();
            String relativePath = objectResource.getURI().toPlatformString(true);
            if (relativePath != null && root != null) {
                try {
                    if (!"".equals(relativePath) && root.findMember(relativePath) != null) {
                        IMarker[] markers;
                        IMarker[] iMarkerArray = markers = root.findMember(relativePath).findMarkers("org.eclipse.sirius.viewpointMarker", false, 0);
                        int n = markers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMarker marker = iMarkerArray[n2];
                            marker.delete();
                            ++n2;
                        }
                    }
                }
                catch (CoreException e) {
                    SiriusPlugin.getDefault().getLog().log(e.getStatus());
                }
                for (EObject subobject : object.eContents()) {
                    this.clear(subobject);
                }
            }
        }
    }

    private static void addMarkerFor(EObject markerTarget, EStructuralFeature feature, String message, int markerSeverity) {
        try {
            IResource resource = MarkerRuntimeLoggerImpl.findMarkerTargetResource(markerTarget);
            if (resource != null && !MarkerRuntimeLoggerImpl.checkIfAlreadyMarked(resource, markerTarget, message, markerSeverity)) {
                IMarker marker = resource.createMarker("org.eclipse.sirius.viewpointMarker");
                marker.setAttribute("severity", markerSeverity);
                marker.setAttribute("viewpointURIMarker", (Object)EcoreUtil.getURI((EObject)markerTarget).toString());
                String markerMessage = "";
                if (feature != null) {
                    markerMessage = MessageFormat.format(Messages.MarkerRuntimeLoggerImpl_feature, feature.getName());
                    if (message != null) {
                        markerMessage = MessageFormat.format(Messages.MarkerRuntimeLoggerImpl_featureWithMessage, feature.getName(), message);
                    }
                } else if (message != null) {
                    markerMessage = message;
                }
                marker.setAttribute("message", (Object)markerMessage);
            }
        }
        catch (CoreException e) {
            SiriusPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    private static IResource findMarkerTargetResource(EObject markerTarget) {
        Resource markerTargetResource;
        if (markerTarget != null && (markerTargetResource = markerTarget.eResource()) != null && markerTargetResource.getURI() != null && markerTargetResource.getURI().isPlatformResource()) {
            String relativePath = markerTargetResource.getURI().toPlatformString(true);
            IWorkspaceRoot root = EcorePlugin.getWorkspaceRoot();
            if (root != null) {
                return root.findMember(relativePath);
            }
        }
        return null;
    }

    private static boolean checkIfAlreadyMarked(IResource resource, EObject markerTarget, String markerMessage, int markerSeverity) throws CoreException {
        IMarker[] markers = resource.findMarkers("org.eclipse.sirius.viewpointMarker", false, 0);
        if (markers != null && markers.length != 0) {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                Object target = marker.getAttribute("viewpointURIMarker");
                Object severity = marker.getAttribute("severity");
                Object message = marker.getAttribute("message");
                if (MarkerRuntimeLoggerImpl.matchesTarget(markerTarget, target) && MarkerRuntimeLoggerImpl.matchesSeverity(markerSeverity, severity) && MarkerRuntimeLoggerImpl.matchesMessage(markerMessage, message)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean matchesTarget(EObject markerTarget, Object target) {
        return target instanceof String && ((String)target).equals(EcoreUtil.getURI((EObject)markerTarget).toString());
    }

    private static boolean matchesSeverity(Integer markerSeverity, Object severity) {
        return severity instanceof Integer && ((Integer)severity).equals(markerSeverity);
    }

    private static boolean matchesMessage(String markerMessage, Object message) {
        return message instanceof String && ((String)message).equals(markerMessage);
    }
}

