/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.image;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.image.ImageManager;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;

public class ImageManagerForWorkspaceResource
implements ImageManager {
    protected static final String BASE64 = "base64";
    protected static final CharSequence SLASH = "/";
    private static final CharSequence QUOTE = "\"";
    protected Map<String, String> htmlToOriginalImagePath = new LinkedHashMap<String, String>();

    @Override
    public String createFile(EObject contextObject, String simpleImageName, String base64) {
        IFile imageFile;
        String pathToImage = null;
        String platformString = contextObject.eResource().getURI().toPlatformString(true);
        IFile airdFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformString));
        IFolder imageFolder = airdFile.getProject().getFolder("images");
        String wsImageName = "images" + SLASH + simpleImageName;
        if (!imageFolder.exists()) {
            try {
                imageFolder.create(true, true, null);
            }
            catch (CoreException e) {
                SiriusPlugin.getDefault().error(MessageFormat.format(Messages.UpdateBase64ImageEncodingPreCommitListener_imageCreationFailure, wsImageName), e);
            }
        }
        if (this.createIFile(base64, imageFile = airdFile.getProject().getFile(wsImageName))) {
            String imageFullPath;
            pathToImage = imageFullPath = imageFile.getFullPath().toString().replaceFirst("^" + SLASH, "");
        }
        return pathToImage;
    }

    private boolean createIFile(String base64, IFile imageFile) {
        byte[] decodedBytes = Base64.getDecoder().decode(base64);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(decodedBytes);){
                imageFile.create((InputStream)input, true, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            SiriusPlugin.getDefault().error(MessageFormat.format(Messages.UpdateBase64ImageEncodingPreCommitListener_imageCreationFailure, imageFile.getFullPath()), e);
            return false;
        }
        return true;
    }

    @Override
    public void undoCreatedFiles(Session session, Map<String, String> createdFiles) {
        for (String createFileName : createdFiles.values()) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(createFileName));
            if (file == null) continue;
            try {
                file.delete(true, null);
            }
            catch (CoreException e) {
                SiriusPlugin.getDefault().error(MessageFormat.format(Messages.UpdateBase64ImageEncodingPreCommitListener_imageCreationFailure, file.getFullPath()), e);
            }
        }
    }

    @Override
    public void redoCreateFiles(Session session, Map<String, String> createdFiles) {
        for (String object : createdFiles.keySet()) {
            if (!(object instanceof String)) continue;
            String base64String = object;
            String createFileName = createdFiles.get(base64String);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(createFileName));
            this.createIFile(base64String, file);
        }
    }

    @Override
    public String computeAndConvertPathsToHtmlFromOriginal(EObject contextObject, String textWithOriginalImagePaths) {
        String returnedString = textWithOriginalImagePaths;
        Pattern pattern = Pattern.compile("<img.*?src=\"(.*?)\".*?/>");
        Matcher matcher = pattern.matcher(textWithOriginalImagePaths);
        while (matcher.find()) {
            String originalPath = matcher.group(1);
            String workspaceRelativePath = "../" + originalPath;
            this.htmlToOriginalImagePath.put(workspaceRelativePath, matcher.group(1));
            returnedString = this.replaceString(returnedString, originalPath, workspaceRelativePath);
        }
        return returnedString;
    }

    protected String replaceString(String string, String oldPart, String newPart) {
        return string.replace(QUOTE + oldPart + QUOTE, QUOTE + newPart + QUOTE);
    }

    @Override
    public String convertToOriginalPathFromPathUsedForHtml(EObject contextObject, String textWithPathForHtml) {
        String returnedString = textWithPathForHtml;
        Pattern pattern = Pattern.compile("<img.*?src=\"(.*?)\".*?/>");
        Matcher matcher = pattern.matcher(textWithPathForHtml);
        while (matcher.find()) {
            String strToReplace = matcher.group(1);
            String originalPath = this.htmlToOriginalImagePath.get(strToReplace);
            if (originalPath != null) {
                returnedString = this.replaceString(returnedString, strToReplace, originalPath);
                continue;
            }
            if (strToReplace.contains(BASE64)) continue;
            SiriusPlugin.getDefault().getLog().error(MessageFormat.format(Messages.ImageManagerForWorkspaceResource_errorGettingTheOriginalPath, strToReplace, new EObjectQuery(contextObject).getGenericDecription()));
        }
        return returnedString;
    }
}

