/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.policies;

import com.google.common.collect.Iterables;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.PropertyHandlerEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.AbsoluteBoundsFilter;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;

public class RegionCollapseAwarePropertyHandlerEditPolicy
extends PropertyHandlerEditPolicy {
    public org.eclipse.gef.commands.Command getCommand(Request request) {
        ChangePropertyValueRequest cpvr;
        org.eclipse.gef.commands.Command command = super.getCommand(request);
        if (request instanceof ChangePropertyValueRequest && Properties.ID_COLLAPSED.equals((cpvr = (ChangePropertyValueRequest)request).getPropertyID()) && cpvr.getValue() instanceof Boolean) {
            command = this.getLayoutConstraintsCommand((Boolean)cpvr.getValue(), command);
        }
        return command;
    }

    private org.eclipse.gef.commands.Command getLayoutConstraintsCommand(boolean collapsed, org.eclipse.gef.commands.Command initialCommand) {
        AbstractDiagramElementContainerEditPart regionPart;
        View notationView;
        if (this.getHost() instanceof IResizableCompartmentEditPart && this.getHost().getParent() instanceof AbstractDiagramElementContainerEditPart && (notationView = (regionPart = (AbstractDiagramElementContainerEditPart)this.getHost().getParent()).getNotationView()) instanceof Node && ((Node)notationView).getLayoutConstraint() instanceof Size && notationView.getElement() instanceof DDiagramElementContainer) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(editingDomain, collapsed ? Messages.RegionCollapseAwarePropertyHandlerEditPolicy_collapseRegionCommandLabel : Messages.RegionCollapseAwarePropertyHandlerEditPolicy_expandRegionCommandLabel);
            ICommandProxy result = new ICommandProxy((ICommand)ctc);
            if (initialCommand != null) {
                ctc.add((IUndoableOperation)new CommandProxy(initialCommand));
            }
            Size size = (Size)((Node)notationView).getLayoutConstraint();
            DDiagramElementContainer ddec = (DDiagramElementContainer)notationView.getElement();
            Iterable boundsFilters = Iterables.filter((Iterable)ddec.getGraphicalFilters(), AbsoluteBoundsFilter.class);
            AbsoluteBoundsFilter expandedBoundsMarker = Iterables.isEmpty((Iterable)boundsFilters) ? null : (AbsoluteBoundsFilter)boundsFilters.iterator().next();
            Dimension newGmfSize = new Dimension(size.getWidth(), size.getHeight());
            int parentStackDirection = regionPart.getParentStackDirection();
            if (parentStackDirection == 5) {
                if (!collapsed) {
                    newGmfSize.setHeight(expandedBoundsMarker == null ? -1 : expandedBoundsMarker.getHeight());
                } else if (size.getHeight() != -1) {
                    newGmfSize.setHeight(28);
                }
            } else if (parentStackDirection == 24) {
                if (!collapsed) {
                    newGmfSize.setWidth(expandedBoundsMarker == null ? -1 : expandedBoundsMarker.getWidth());
                } else if (!this.isTruncatedLabel(regionPart)) {
                    newGmfSize.setWidth(-1);
                }
            }
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(editingDomain, Messages.RegionCollapseAwarePropertyHandlerEditPolicy_gmfSizeUpdateCommandLabel, (IAdaptable)new EObjectAdapter((EObject)notationView), newGmfSize);
            ctc.add((IUndoableOperation)setBoundsCommand);
            if (collapsed) {
                if (expandedBoundsMarker != null) {
                    ctc.add((IUndoableOperation)new GMFCommandWrapper(editingDomain, (Command)new SetCommand((EditingDomain)editingDomain, (EObject)expandedBoundsMarker, (EStructuralFeature)DiagramPackage.eINSTANCE.getAbsoluteBoundsFilter_Height(), (Object)size.getHeight())));
                    ctc.add((IUndoableOperation)new GMFCommandWrapper(editingDomain, (Command)new SetCommand((EditingDomain)editingDomain, (EObject)expandedBoundsMarker, (EStructuralFeature)DiagramPackage.eINSTANCE.getAbsoluteBoundsFilter_Width(), (Object)size.getWidth())));
                } else {
                    expandedBoundsMarker = DiagramFactory.eINSTANCE.createAbsoluteBoundsFilter();
                    expandedBoundsMarker.setHeight(Integer.valueOf(size.getHeight()));
                    expandedBoundsMarker.setWidth(Integer.valueOf(size.getWidth()));
                    ctc.add((IUndoableOperation)new GMFCommandWrapper(editingDomain, (Command)new AddCommand((EditingDomain)editingDomain, ddec.getGraphicalFilters(), (Object)expandedBoundsMarker)));
                }
            } else if (expandedBoundsMarker != null) {
                ctc.add((IUndoableOperation)new GMFCommandWrapper(editingDomain, (Command)new RemoveCommand((EditingDomain)editingDomain, ddec.getGraphicalFilters(), (Object)expandedBoundsMarker)));
            }
            return result;
        }
        return initialCommand;
    }

    private boolean isTruncatedLabel(AbstractDiagramElementContainerEditPart regionPart) {
        SiriusWrapLabel nodeLabel = regionPart.getNodeLabel();
        return nodeLabel != null && (nodeLabel.isTextTruncated() || nodeLabel.getText() != null && !nodeLabel.getText().equals(nodeLabel.getSubStringText()));
    }
}

