/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.future;

import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.DefaultVerifiableSshFuture;

public class DefaultAuthFuture
extends DefaultVerifiableSshFuture<AuthFuture>
implements AuthFuture {
    public DefaultAuthFuture(Object id, Object lock) {
        super(id, lock);
    }

    @Override
    public AuthFuture verify(long timeoutMillis) throws IOException {
        Boolean result = this.verifyResult(Boolean.class, timeoutMillis);
        if (!result.booleanValue()) {
            throw this.formatExceptionMessage(SshException::new, "Authentication failed while waiting %d msec.", timeoutMillis);
        }
        return this;
    }

    @Override
    public Throwable getException() {
        Object v = this.getValue();
        if (v instanceof Throwable) {
            return (Throwable)v;
        }
        return null;
    }

    @Override
    public boolean isSuccess() {
        Object v = this.getValue();
        return v instanceof Boolean && (Boolean)v != false;
    }

    @Override
    public boolean isFailure() {
        Object v = this.getValue();
        if (v instanceof Boolean) {
            return (Boolean)v == false;
        }
        return true;
    }

    @Override
    public void setAuthed(boolean authed) {
        this.setValue(authed);
    }

    @Override
    public void setException(Throwable exception) {
        Objects.requireNonNull(exception, "No exception provided");
        this.setValue(exception);
    }
}

