/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset.rw;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.json.io.JSWriter;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetWriter;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.riot.resultset.rw.JSONResultsKW;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.resultset.ResultSetApply;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.ResultSetProcessor;
import org.apache.jena.sparql.util.Context;

public class ResultSetWriterJSON
implements ResultSetWriter {
    public static ResultSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.SPARQLResultSetJSON)) {
            throw new ResultSetException("ResultSetWriter for JSON asked for a " + lang);
        }
        return new ResultSetWriterJSON();
    };

    private ResultSetWriterJSON() {
    }

    @Override
    public void write(Writer out, ResultSet resultSet, Context context2) {
        throw new UnsupportedOperationException("Writing JSON results to a java.io.Writer. Use an OutputStream.");
    }

    @Override
    public void write(OutputStream outStream, boolean result, Context context2) {
        JSWriter out = new JSWriter(outStream);
        out.startOutput();
        out.startObject();
        out.key(JSONResultsKW.kHead);
        out.startObject();
        out.finishObject();
        out.pair(JSONResultsKW.kBoolean, result);
        out.finishObject();
        out.finishOutput();
        IO.flush((OutputStream)outStream);
    }

    @Override
    public void write(OutputStream out, ResultSet resultSet, Context context2) {
        JSONOutputResultSet jsonOut = new JSONOutputResultSet(out, context2);
        ResultSetApply a = new ResultSetApply(resultSet, jsonOut);
        a.apply();
    }

    private static class JSONOutputResultSet
    implements ResultSetProcessor {
        private static final boolean multiLineValues = false;
        private static final boolean multiLineVarNames = false;
        private final IndentedWriter out;
        private final NodeToLabel labels;
        boolean firstSolution = true;
        boolean firstBindingInSolution = true;

        private JSONOutputResultSet(OutputStream outStream, Context context2) {
            this(new IndentedWriter(outStream), context2);
        }

        private JSONOutputResultSet(IndentedWriter indentedOut, Context context2) {
            this.out = indentedOut;
            boolean outputGraphBNodeLabels = context2 != null && context2.isTrue(ARQ.outputGraphBNodeLabels);
            this.labels = outputGraphBNodeLabels ? SyntaxLabels.createNodeToLabelAsGiven() : SyntaxLabels.createNodeToLabel();
        }

        @Override
        public void start(ResultSet rs) {
            this.println("{");
            this.out.incIndent();
            this.doHead(rs);
            this.println(JSONOutputResultSet.quoteName(JSONResultsKW.kResults), ": {");
            this.out.incIndent();
            this.println(JSONOutputResultSet.quoteName(JSONResultsKW.kBindings), ": [");
            this.out.incIndent();
            this.firstSolution = true;
        }

        @Override
        public void finish(ResultSet rs) {
            this.out.println();
            this.out.decIndent();
            this.println("]");
            this.out.decIndent();
            this.println("}");
            this.out.decIndent();
            this.println("}");
            this.out.flush();
        }

        private void doHead(ResultSet rs) {
            this.println(JSONOutputResultSet.quoteName(JSONResultsKW.kHead), ": {");
            this.out.incIndent();
            this.doLink(rs);
            this.doVars(rs);
            this.out.decIndent();
            this.println("} ,");
        }

        private void doLink(ResultSet rs) {
        }

        private void doVars(ResultSet rs) {
            this.print(JSONOutputResultSet.quoteName(JSONResultsKW.kVars), ": [ ");
            this.out.incIndent();
            Iterator<String> iter = rs.getResultVars().iterator();
            while (iter.hasNext()) {
                String varname = iter.next();
                this.print("\"", varname, "\"");
                if (!iter.hasNext()) continue;
                this.print(" , ");
            }
            this.println(" ]");
            this.out.decIndent();
        }

        @Override
        public void start(QuerySolution qs) {
            if (!this.firstSolution) {
                this.println(" ,");
            }
            this.firstSolution = false;
            this.println("{");
            this.out.incIndent();
            this.firstBindingInSolution = true;
        }

        @Override
        public void finish(QuerySolution qs) {
            this.println(new String[0]);
            this.out.decIndent();
            this.print("}");
        }

        @Override
        public void binding(String varName, RDFNode value) {
            if (value == null) {
                return;
            }
            if (!this.firstBindingInSolution) {
                this.println(" ,");
            }
            this.firstBindingInSolution = false;
            this.print(JSONOutputResultSet.quote(varName), ": { ");
            this.out.incIndent();
            if (value.isLiteral()) {
                this.printLiteral((Literal)value);
            } else if (value.isResource()) {
                this.printResource((Resource)value);
            } else {
                Log.warn((Object)this, (String)("Unknown RDFNode type in result set: " + value.getClass()));
            }
            this.out.decIndent();
            this.print(" ");
            this.print("}");
        }

        private void printUnbound() {
            this.print(JSONOutputResultSet.quoteName(JSONResultsKW.kType), ": ", JSONOutputResultSet.quote(JSONResultsKW.kUnbound), " , ");
            this.print(JSONOutputResultSet.quoteName(JSONResultsKW.kValue), ": null");
        }

        private void printLiteral(Literal literal) {
            String datatype = literal.getDatatypeURI();
            String lang = literal.getLanguage();
            if (Util.isSimpleString((Literal)literal) || Util.isLangString((Literal)literal)) {
                this.print(JSONOutputResultSet.quoteName(JSONResultsKW.kType), ": ", JSONOutputResultSet.quote(JSONResultsKW.kLiteral), " , ");
                if (lang != null && !lang.equals("")) {
                    this.print(JSONOutputResultSet.quoteName(JSONResultsKW.kXmlLang), ": ", JSONOutputResultSet.quote(lang), " , ");
                }
            } else {
                this.print(JSONOutputResultSet.quoteName(JSONResultsKW.kType), ": ", JSONOutputResultSet.quote(JSONResultsKW.kLiteral), " , ");
                this.print(JSONOutputResultSet.quoteName(JSONResultsKW.kDatatype), ": ", JSONOutputResultSet.quote(datatype), " , ");
            }
            this.print(JSONOutputResultSet.quoteName(JSONResultsKW.kValue), ": ", JSONOutputResultSet.quote(literal.getLexicalForm()));
        }

        private void printResource(Resource resource) {
            if (!resource.isAnon()) {
                this.print(JSONOutputResultSet.quoteName(JSONResultsKW.kType), ": ", JSONOutputResultSet.quote(JSONResultsKW.kUri), " , ");
                this.print(JSONOutputResultSet.quoteName(JSONResultsKW.kValue), ": ", JSONOutputResultSet.quote(resource.getURI()));
                return;
            }
            String label = (String)this.labels.get(null, resource.asNode());
            label = label.substring(2);
            this.print(JSONOutputResultSet.quoteName(JSONResultsKW.kType), ": ", JSONOutputResultSet.quote(JSONResultsKW.kBnode), " , ");
            this.print(JSONOutputResultSet.quoteName(JSONResultsKW.kValue), ": ", JSONOutputResultSet.quote(label));
        }

        private void print(String ... strings) {
            for (String s : strings) {
                this.out.print(s);
            }
        }

        private void println(String ... strings) {
            this.print(strings);
            this.out.println();
        }

        private static String quote(String string) {
            return JSWriter.outputQuotedString(string);
        }

        private static String quoteName(String string) {
            return JSONOutputResultSet.quote(string);
        }
    }
}

