/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.client.OAuthClient;
import net.oauth.client.httpclient4.HttpClient4;
import net.oauth.http.HttpClient;
import org.eclipse.lyo.client.IOslcClient;
import org.eclipse.lyo.client.OslcClient;
import org.eclipse.lyo.client.UnderlyingHttpClient;
import org.eclipse.lyo.core.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OslcOAuthClient
implements IOslcClient {
    private OAuthAccessor oauthAccessor;
    private String oauthRealmName;
    private UnderlyingHttpClient underlyingHttpClient;
    private OslcClient oslcClient;
    private static final Logger log = LoggerFactory.getLogger(OslcOAuthClient.class);

    public OslcOAuthClient(OAuthAccessor accessor, String realm, ClientBuilder clientBuilder, UnderlyingHttpClient underlyingHttpClient) {
        this.oauthAccessor = accessor;
        this.oauthRealmName = "Jazz";
        if (!StringUtils.isNullOrEmpty((String)realm)) {
            this.oauthRealmName = realm;
        }
        this.oslcClient = null == clientBuilder ? new OslcClient() : new OslcClient(clientBuilder);
        this.underlyingHttpClient = underlyingHttpClient;
    }

    public OslcClient getOslcClient() {
        return this.oslcClient;
    }

    private Map<String, String> appendAuthorizationHeader(String url, String httpMethod, Map<String, String> requestHeaders) throws IOException, OAuthException, URISyntaxException {
        if (requestHeaders == null) {
            requestHeaders = new HashMap<String, String>();
        }
        requestHeaders.put("Authorization", this.getAuthorizationHeader(url, httpMethod));
        return requestHeaders;
    }

    private String getAuthorizationHeader(String url, String httpMethod) throws IOException, OAuthException, URISyntaxException {
        if (!this.performedOAuthNegotiation()) {
            throw new IllegalStateException("You need to obtain an AccessToken by first calling performOAuthNegotiation()");
        }
        return this.oauthAccessor.newRequestMessage(httpMethod, url, null).getAuthorizationHeader(this.oauthRealmName);
    }

    private boolean performedOAuthNegotiation() {
        return null != this.oauthAccessor.accessToken;
    }

    public Optional<String> performOAuthNegotiation(String callbackURL) throws IOException, OAuthException, URISyntaxException {
        return this.performOAuthNegotiationInternal(false, callbackURL);
    }

    private Optional<String> performOAuthNegotiationInternal(boolean restart, String callbackURL) throws IOException, OAuthException, URISyntaxException {
        if (this.oauthAccessor.requestToken == null) {
            OAuthClient client = new OAuthClient((HttpClient)new HttpClient4(){

                public org.apache.http.client.HttpClient getHttpClient(URL url) {
                    return OslcOAuthClient.this.underlyingHttpClient.get(OslcOAuthClient.this.oslcClient.getClient());
                }
            });
            OAuthMessage message = client.getRequestTokenResponse(this.oauthAccessor, "GET", null);
            String userAuthorizationURL = this.oauthAccessor.consumer.serviceProvider.userAuthorizationURL + "?oauth_token=" + this.oauthAccessor.requestToken + "&oauth_callback=" + URLEncoder.encode(callbackURL, "UTF-8");
            return Optional.of(userAuthorizationURL);
        }
        if (this.oauthAccessor.accessToken == null) {
            try {
                OAuthClient client = new OAuthClient((HttpClient)new HttpClient4(){

                    public org.apache.http.client.HttpClient getHttpClient(URL url) {
                        return OslcOAuthClient.this.underlyingHttpClient.get(OslcOAuthClient.this.oslcClient.getClient());
                    }
                });
                OAuthMessage oAuthMessage = client.getAccessToken(this.oauthAccessor, "POST", null);
            }
            catch (OAuthException e) {
                log.debug("OAuthException caught: " + e.getMessage());
                if (restart) {
                    log.error("Failed to get access key.", (Throwable)e);
                }
                this.oauthAccessor.accessToken = null;
                this.oauthAccessor.requestToken = null;
                this.performOAuthNegotiationInternal(true, callbackURL);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public Client getClient() {
        return this.getOslcClient().getClient();
    }

    @Override
    public Response getResource(String url) {
        return this.getResource(url, null, "application/rdf+xml", null, true);
    }

    @Override
    public Response getResource(String url, String mediaType) {
        return this.getResource(url, null, mediaType, null, true);
    }

    @Override
    public Response getResource(String url, Map<String, String> requestHeaders) {
        return this.getResource(url, requestHeaders, "application/rdf+xml", null, true);
    }

    @Override
    public Response getResource(String url, Map<String, String> requestHeaders, String mediaType) {
        return this.getResource(url, requestHeaders, mediaType, null, true);
    }

    @Override
    public Response getResource(String url, Map<String, String> requestHeaders, String mediaType, String configurationContext) {
        return this.getResource(url, requestHeaders, mediaType, configurationContext, true);
    }

    @Override
    public Response getResource(String url, Map<String, String> requestHeaders, String mediaType, boolean handleRedirects) {
        return this.getResource(url, requestHeaders, mediaType, null, handleRedirects);
    }

    @Override
    public Response getResource(String url, Map<String, String> requestHeaders, String mediaType, String configurationContext, boolean handleRedirects) {
        Map<String, String> headers = null;
        try {
            headers = this.appendAuthorizationHeader(url, "GET", requestHeaders);
        }
        catch (IOException | URISyntaxException | OAuthException e) {
            throw new IllegalStateException(e);
        }
        return this.oslcClient.getResource(url, headers, mediaType, configurationContext, handleRedirects);
    }

    @Override
    public Response deleteResource(String url) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response deleteResource(String url, String configurationContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response createResource(String url, Object artifact, String mediaType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response createResource(String url, Object artifact, String mediaType, String acceptType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response createResource(String url, Object artifact, String mediaType, String acceptType, String configurationContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response updateResource(String url, Object artifact, String mediaType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response updateResource(String url, Object artifact, String mediaType, String acceptType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response updateResource(String url, Object artifact, String mediaType, String acceptType, String ifMatch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response updateResource(String url, Object artifact, String mediaType, String acceptType, String ifMatch, String configurationContext) {
        throw new UnsupportedOperationException();
    }
}

