/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.motioncalculator.json.http.ui;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class HttpMotionCalculatorPreferencesPage extends FieldEditorPreferencePage
        implements IWorkbenchPreferencePage
{
    public HttpMotionCalculatorPreferencesPage() {
        super(GRID);
    }

    @Override
    public void createFieldEditors() {
        addField(new StringFieldEditor("HREF", "&Server http://", getFieldEditorParent()));
        addField(new BooleanFieldEditor("WRITE_MESSAGES", "Write &Messages to console :",
                BooleanFieldEditor.SEPARATE_LABEL, getFieldEditorParent()));
    }

    @Override
    public void init(IWorkbench workbench) {
        // second parameter is typically the plug-in id
        setPreferenceStore(
                new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.lsat.motioncalculator.json.http"));
        setDescription("Configures the http endpoint of the motion calculator server.\n\n");
    }
}
