/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.algorithms;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.graph.DoubleWeightedGraph;
import org.eclipse.lsat.common.ludus.backend.graph.Graph;

public final class Howard {
    private static final double SMALL_CONSTANT_EPSILON = 1.0E-9;
    private static final int MAX_ITERATIONS = 1000;

    private Howard() {
    }

    public static <V, E> Tuple<Value, List<E>> runHoward(DoubleWeightedGraph<V, E, Value> graph) {
        Object maxE = Collections.max(graph.getEdges(), Comparator.comparing(e -> (Value)graph.getWeight1(e)));
        Value maxWeight1 = graph.getWeight1(maxE);
        Object minE = Collections.min(graph.getEdges(), Comparator.comparing(e -> (Value)graph.getWeight1(e)));
        Value minWeight1 = graph.getWeight1(minE);
        Value epsilon = maxWeight1.subtract(minWeight1).multiply(new Value(1.0E-9));
        return Howard.runHoward(graph, epsilon);
    }

    public static <V, E> Tuple<Value, List<E>> runHoward(DoubleWeightedGraph<V, E, Value> graph, Value eps) {
        Object maxE = Collections.max(graph.getEdges(), Comparator.comparing(e -> (Value)graph.getWeight1(e)));
        Value maxWeight1 = graph.getWeight1(maxE);
        Value r_max = new Value(graph.getEdges().size()).multiply(maxWeight1).add(new Value(1.0));
        HashMap d = new HashMap();
        HashMap p = new HashMap();
        for (Object v : graph.getVertices()) {
            d.put(v, Value.POSITIVE_INFINITY);
        }
        for (Object e2 : graph.getEdges()) {
            Object source = graph.getEdgeSource(e2);
            Object target = graph.getEdgeTarget(e2);
            if (!graph.getWeight1(e2).smallerThan((Value)d.get(source))) continue;
            d.put(source, graph.getWeight1(e2));
            p.put(source, target);
        }
        Value r = r_max;
        Object r_handle = null;
        List<E> r_cycle = null;
        boolean changed = true;
        int cycleCount = 0;
        while (changed && cycleCount < 1000) {
            Tuple<Value, Optional<V>> result = Howard.findRatio(graph, r, p);
            if (result.getLeft().smallerThan(r)) {
                r = result.getLeft();
                r_handle = result.getRight().get();
                r_cycle = Howard.getCycle(graph, p, r_handle);
                HashSet visited = new HashSet();
                LinkedList frontier = new LinkedList();
                frontier.add(r_handle);
                visited.add(r_handle);
                while (!frontier.isEmpty()) {
                    Object v = frontier.remove();
                    for (Object e3 : graph.incomingEdgesOf(v)) {
                        Object incoming = graph.getEdgeSource(e3);
                        if (visited.contains(incoming) || !p.get(incoming).equals(v)) continue;
                        frontier.add(incoming);
                        Value v1 = ((Value)d.get(v)).add(graph.getWeight1(e3));
                        Value v2 = r.multiply(graph.getWeight2(e3));
                        d.put(incoming, v1.subtract(v2));
                    }
                }
            }
            changed = false;
            for (Object edge : graph.getEdges()) {
                Object u = graph.getEdgeSource(edge);
                Object v = graph.getEdgeTarget(edge);
                Value v1 = ((Value)d.get(v)).add(graph.getWeight1(edge));
                Value v2 = r.multiply(graph.getWeight2(edge));
                Value dist = v1.subtract(v2);
                if (!((Value)d.get(u)).biggerThan(dist.add(eps))) continue;
                d.put(u, dist);
                p.put(u, v);
                changed = true;
            }
            ++cycleCount;
        }
        if (r_handle == null || cycleCount >= 1000) {
            return Tuple.of(Value.NEGATIVE_INFINITY, null);
        }
        return Tuple.of(r, r_cycle);
    }

    private static <V, E> List<E> getCycle(Graph<V, E> graph, Map<V, V> p, V r_handle) {
        LinkedList<E> cycle = new LinkedList<E>();
        V v = r_handle;
        V vInit = r_handle;
        while (true) {
            V vNext = p.get(v);
            E edge = graph.getEdge(v, vNext);
            cycle.add(edge);
            if (vNext.equals(vInit)) break;
            v = vNext;
        }
        return cycle;
    }

    private static <V, E> Tuple<Value, Optional<V>> findRatio(DoubleWeightedGraph<V, E, Value> graph, Value r, Map<V, V> p) {
        HashMap visited = new HashMap();
        for (Object v : graph.getVertices()) {
            visited.put(v, null);
        }
        Value r_prime = r;
        Optional<Object> handle = Optional.empty();
        for (Object v : graph.getVertices()) {
            if (visited.get(v) != null) continue;
            Object u = v;
            do {
                visited.put(u, v);
            } while (visited.get(u = p.get(u)) == null);
            if (!visited.get(u).equals(v)) continue;
            Object x = u;
            Value sum = new Value(0.0);
            Value length = new Value(0.0);
            do {
                Object edge = graph.getEdge(x, p.get(x));
                assert (edge != null);
                sum = sum.add(graph.getWeight1(edge));
                length = length.add(graph.getWeight2(edge));
            } while (!(x = p.get(x)).equals(u));
            Value cycleRatio = sum.divide(length);
            if (!r_prime.biggerThan(cycleRatio)) continue;
            r_prime = cycleRatio;
            handle = Optional.of(u);
        }
        return Tuple.of(r_prime, handle);
    }
}

