/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.diagram.services;

import activity.Action;
import activity.Activity;
import activity.Claim;
import activity.Dependency;
import activity.EventAction;
import activity.Move;
import activity.PeripheralAction;
import activity.RaiseEvent;
import activity.Release;
import activity.RequireEvent;
import activity.ResourceAction;
import activity.SchedulingType;
import activity.SimpleAction;
import activity.SyncBar;
import activity.impl.ActivityQueries;
import activity.util.ActivityUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import machine.IResource;
import machine.Peripheral;
import machine.ResourceType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.util.CollectionUtil;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.lsat.timing.util.MoveHelper;
import org.eclipse.lsat.timing.util.TimingCalculator;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import setting.SettingUtil;
import setting.Settings;

public class ActivityServices {
    private final Map<Settings, TimingCalculator> timingCalculators = new LinkedHashMap<Settings, TimingCalculator>();
    private static final String TIME_LABEL_KEY = "showTimeLabels";
    private static final String ANNOTATION_SOURCE = "org.eclipse.lsat.activity.diagram.services.ActivityServices";

    public static boolean isALAP(PeripheralAction action) {
        return action.getSchedulingType().equals((Object)SchedulingType.ALAP);
    }

    public static Collection<Action> getResourceActions(Activity activity, IResource resource) {
        ArrayList<Action> result = new ArrayList<Action>();
        CollectionUtil.addAll(result, (Iterable)ActivityQueries.getActionsFor((IResource)resource, ResourceAction.class, (Iterable)activity.getNodes()));
        return result;
    }

    public Collection<IResource> getResources(DSemanticDiagram element) {
        return ActivityServices.getResources((Activity)element.getTarget());
    }

    public Collection<EventAction> getEvents(DSemanticDiagram element) {
        return ActivityServices.getEvents((Activity)element.getTarget());
    }

    public static Collection<EventAction> getEvents(Activity activity) {
        if (activity == null) {
            return Collections.emptySet();
        }
        return QueryableIterable.from((Iterable)activity.getNodes()).objectsOfKind(EventAction.class).asSet();
    }

    public static Collection<IResource> getResources(Activity activity) {
        if (activity == null) {
            return Collections.emptySet();
        }
        return QueryableIterable.from((Iterable)activity.getNodes()).objectsOfKind(ResourceAction.class).xcollectOne(a -> a.getResource()).select(r -> ResourceType.EVENT != r.getResource().getResourceType()).asSet();
    }

    public static Collection<IResource> getEventResources(Activity activity) {
        if (activity == null) {
            return Collections.emptySet();
        }
        return QueryableIterable.from((Iterable)activity.getNodes()).objectsOfKind(ResourceAction.class).xcollectOne(a -> a.getResource()).select(r -> r.getResource().getResourceType() == ResourceType.EVENT).asSet();
    }

    public static Collection<IResource> getResourcePlaceholder(DSemanticDiagram element, IResource resource) {
        return ActivityServices.hasPeripherals(element, resource) ? Collections.emptyList() : Collections.singleton(resource);
    }

    public static boolean hasPeripherals(DSemanticDiagram element, IResource resource) {
        Activity activity = ActivityServices.getActivity((DSemanticDecorator)element);
        return !ActivityQueries.getActionsFor((IResource)resource, PeripheralAction.class, (Iterable)activity.getNodes()).isEmpty();
    }

    public static Collection<Peripheral> getPeripherals(DSemanticDiagram element, IResource resource) {
        return ActivityServices.getPeripherals(ActivityServices.getActivity((DSemanticDecorator)element), resource);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isPassive(EObject element) {
        void decorator;
        if (!(element instanceof DSemanticDecorator)) {
            return false;
        }
        DSemanticDecorator dSemanticDecorator = (DSemanticDecorator)element;
        Activity activity = ActivityServices.getActivity((DSemanticDecorator)decorator);
        IResource resource = ActivityServices.getResource((DSemanticDecorator)decorator);
        if (activity == null || resource == null) {
            return false;
        }
        return ActivityUtil.getClaims((Activity)activity, (IResource)resource).stream().allMatch(Claim::isPassive);
    }

    public static Collection<PeripheralAction> getPeripheralActions(EObject containerView) {
        if (!(containerView instanceof DSemanticDecorator)) {
            return Collections.emptyList();
        }
        DSemanticDecorator decorator = (DSemanticDecorator)containerView;
        EObject target = decorator.getTarget();
        if (!(target instanceof Peripheral)) {
            return Collections.emptyList();
        }
        Peripheral peripheral = (Peripheral)target;
        IResource resource = ActivityServices.getResource(decorator);
        Activity activity = ActivityServices.getActivity(decorator);
        if (activity == null || resource == null) {
            return Collections.emptyList();
        }
        return ActivityQueries.getActionsFor((IResource)resource, PeripheralAction.class, (Iterable)activity.getNodes()).select(a -> a.getPeripheral() == peripheral).asList();
    }

    public static IResource getResource(DSemanticDecorator element) {
        return ActivityServices.getTarget(IResource.class, element);
    }

    public static Activity getActivity(DSemanticDecorator element) {
        return ActivityServices.getTarget(Activity.class, element);
    }

    private static <T extends EObject> T getTarget(Class<T> clazz, DSemanticDecorator element) {
        while (!clazz.isInstance(element.getTarget())) {
            EObject parent = element.eContainer();
            if (!(parent instanceof DSemanticDecorator)) {
                return null;
            }
            element = (DSemanticDecorator)parent;
        }
        return (T)((EObject)clazz.cast(element.getTarget()));
    }

    public static Collection<PeripheralAction> getPeripheralActions(Activity activity, IResource resource) {
        return ActivityQueries.getActionsFor((IResource)resource, PeripheralAction.class, (Iterable)activity.getNodes()).asOrderedSet();
    }

    public static Collection<Peripheral> getPeripherals(Activity activity, IResource resource) {
        return ActivityQueries.getActionsFor((IResource)resource, PeripheralAction.class, (Iterable)activity.getNodes()).xcollectOne(pa -> pa.getPeripheral()).asOrderedSet();
    }

    public Collection<Claim> getClaims(DSemanticDiagram element, IResource resource) {
        return ActivityUtil.getClaims((Activity)((Activity)element.getTarget()), (IResource)resource);
    }

    public static void addClaimRelease(Activity activity, IResource resource) {
        ActivityUtil.addClaim((Activity)activity, (IResource)resource);
        ActivityUtil.addRelease((Activity)activity, (IResource)resource);
    }

    public Collection<Release> getReleases(DSemanticDiagram element, IResource resource) {
        return ActivityUtil.getReleases((Activity)((Activity)element.getTarget()), (IResource)resource);
    }

    public String getDescription(EventAction eventAction) {
        StringBuffer description = new StringBuffer(eventAction.getName()).append(": ");
        if (eventAction instanceof RequireEvent) {
            description.append("Require ");
        }
        if (eventAction instanceof RaiseEvent) {
            description.append("Raise ");
        }
        description.append(eventAction.getResource().fqn());
        return description.toString();
    }

    public String getTooltip(EventAction eventAction) {
        return this.getDescription(eventAction);
    }

    public String getDescription(PeripheralAction action) {
        StringBuilder description = new StringBuilder(action.getName()).append(": ");
        if (action instanceof SimpleAction) {
            description.append(((SimpleAction)action).getType().getName());
        } else if (action instanceof Move) {
            description.append(MoveHelper.getDescription((Move)((Move)action), (boolean)false));
        }
        if (ActivityServices.isALAP(action)) {
            description.append(System.lineSeparator()).append("ALAP");
        }
        if (this.shouldShowActivityTime(action)) {
            description.append(System.lineSeparator()).append(this.getActivityTime(action));
        }
        return description.toString();
    }

    public String getActivityTime(PeripheralAction action) {
        try {
            Settings settings = SettingUtil.getSettings((Resource)action.getPeripheral().eResource());
            TimingCalculator timingCalculator = this.timingCalculators.get(settings);
            if (timingCalculator == null) {
                MotionCalculatorExtension motionCalculator = MotionCalculatorExtension.getSelectedMotionCalculator();
                timingCalculator = new TimingCalculator(settings, motionCalculator);
                this.timingCalculators.put(settings, timingCalculator);
            }
            BigDecimal value = timingCalculator.calculateDuration((Node)action).setScale(3, RoundingMode.HALF_UP);
            return "time: " + value.toString();
        }
        catch (IllegalStateException e) {
            return "time: unknown";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "time: unknown";
        }
    }

    public String getTooltip(PeripheralAction action) {
        StringBuffer description = new StringBuffer(action.getName()).append(": ");
        if (action instanceof SimpleAction) {
            description.append(action.getResource().fqn()).append('.');
            description.append(action.getPeripheral().getName()).append('.');
            description.append(((SimpleAction)action).getType().getName());
        } else if (action instanceof Move) {
            description.append(MoveHelper.getDescription((Move)((Move)action), (boolean)true));
        }
        if (ActivityServices.isALAP(action)) {
            description.append(" ").append("ALAP");
        }
        return description.toString();
    }

    public String getTooltip(SyncBar syncbar) {
        return syncbar.getName();
    }

    public String getTooltip(Claim claim) {
        StringBuffer description = new StringBuffer(claim.getName()).append(": ");
        description.append("Claim ");
        description.append(claim.getResource().fqn());
        return description.toString();
    }

    public String getTooltip(Release release) {
        StringBuffer description = new StringBuffer(release.getName()).append(": ");
        description.append("Release ");
        description.append(release.getResource().fqn());
        return description.toString();
    }

    public String getBeginLabel(Dependency dependency) {
        if (!(dependency.getSourceNode() instanceof Action)) {
            return null;
        }
        Action action = (Action)dependency.getSourceNode();
        if (action.getExit() == null) {
            return null;
        }
        StringBuffer label = new StringBuffer(action.getExit().getValue());
        if (action.getOuterExit() != null) {
            label.append("\n[").append(action.getOuterExit().getValue()).append("]");
        }
        return label.toString();
    }

    public String getEndLabel(Dependency dependency) {
        if (!(dependency.getTargetNode() instanceof Action)) {
            return null;
        }
        Action action = (Action)dependency.getTargetNode();
        if (action.getEntry() == null) {
            return null;
        }
        StringBuffer label = new StringBuffer();
        if (action.getOuterEntry() != null) {
            label.append("[").append(action.getOuterEntry().getValue()).append("]\n");
        }
        label.append(action.getEntry().getValue());
        return label.toString();
    }

    private boolean shouldShowActivityTime(PeripheralAction action) {
        Session session = SessionManager.INSTANCE.getSession((EObject)action);
        if (session == null) {
            return false;
        }
        boolean result = DialectManager.INSTANCE.getAllRepresentations(session).stream().filter(rep -> rep instanceof DDiagram).map(rep -> (DDiagram)rep).filter(diagram -> this.diagramContainsAction((DDiagram)diagram, action)).findFirst().map(ActivityServices::getShowTimeLabels).orElse(false);
        return result;
    }

    private boolean diagramContainsAction(DDiagramElement element, PeripheralAction action) {
        if (action.equals(element.getTarget())) {
            return true;
        }
        if (element instanceof DNodeContainer) {
            DNodeContainer container = (DNodeContainer)element;
            for (DDiagramElement child : container.getOwnedDiagramElements()) {
                if (!this.diagramContainsAction(child, action)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean diagramContainsAction(DDiagram diagram, PeripheralAction action) {
        for (DDiagramElement de : diagram.getOwnedDiagramElements()) {
            if (!this.diagramContainsAction(de, action)) continue;
            return true;
        }
        return false;
    }

    public static void setShowTimeLabels(DDiagram diagram, boolean show) {
        DAnnotation ann = ActivityServices.getOrCreateAnnotation(diagram);
        ann.getDetails().put((Object)TIME_LABEL_KEY, (Object)Boolean.toString(show));
    }

    private static DAnnotation getOrCreateAnnotation(DDiagram diagram) {
        for (DAnnotation ann : diagram.getEAnnotations()) {
            if (!ANNOTATION_SOURCE.equals(ann.getSource())) continue;
            return ann;
        }
        DAnnotation annotation = DescriptionFactory.eINSTANCE.createDAnnotation();
        annotation.setSource(ANNOTATION_SOURCE);
        diagram.getEAnnotations().add((Object)annotation);
        return annotation;
    }

    public static boolean getShowTimeLabels(DDiagram diagram) {
        for (DAnnotation ann : diagram.getEAnnotations()) {
            String value;
            if (!ANNOTATION_SOURCE.equals(ann.getSource()) || (value = (String)ann.getDetails().get((Object)TIME_LABEL_KEY)) == null) continue;
            return Boolean.parseBoolean(value);
        }
        return false;
    }
}

