/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.type;

import java.util.Objects;
import org.eclipse.kura.annotation.Immutable;
import org.eclipse.kura.annotation.ThreadSafe;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.osgi.annotation.versioning.ProviderType;

@Immutable
@ThreadSafe
@ProviderType
public class IntegerValue
implements TypedValue<Integer> {
    private final int value;

    public IntegerValue(int value) {
        this.value = value;
    }

    @Override
    public int compareTo(TypedValue<Integer> otherTypedValue) {
        Objects.requireNonNull(otherTypedValue, "Typed Value cannot be null");
        return Integer.valueOf(this.value).compareTo(otherTypedValue.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerValue other = (IntegerValue)obj;
        return this.value == other.value;
    }

    @Override
    public DataType getType() {
        return DataType.INTEGER;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    public String toString() {
        return "IntegerValue [value=" + this.value + "]";
    }
}

