/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.pushstream;

import java.time.Duration;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import java.util.function.ToLongBiFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.osgi.util.function.Function;
import org.osgi.util.function.Predicate;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.promise.TimeoutException;
import org.osgi.util.pushstream.IntermediatePushStreamImpl;
import org.osgi.util.pushstream.PushEvent;
import org.osgi.util.pushstream.PushEventConsumer;
import org.osgi.util.pushstream.PushEventSource;
import org.osgi.util.pushstream.PushStream;
import org.osgi.util.pushstream.PushStreamBuilder;
import org.osgi.util.pushstream.PushStreamProvider;

abstract class AbstractPushStreamImpl<T>
implements PushStream<T> {
    private final Function<T, T> IDENTITY = x -> x;
    protected final PushStreamProvider psp;
    protected final PromiseFactory promiseFactory;
    protected final AtomicReference<State> closed = new AtomicReference<State>(State.BUILDING);
    protected final AtomicReference<PushEventConsumer<T>> next = new AtomicReference();
    protected final AtomicReference<Runnable> onCloseCallback = new AtomicReference();
    protected final AtomicReference<Consumer<? super Throwable>> onErrorCallback = new AtomicReference();

    protected abstract boolean begin();

    protected abstract void upstreamClose(PushEvent<?> var1);

    AbstractPushStreamImpl(PushStreamProvider psp, PromiseFactory promiseFactory) {
        this.psp = psp;
        this.promiseFactory = promiseFactory;
    }

    protected long handleEvent(PushEvent<? extends T> event) {
        if (this.closed.get() != State.CLOSED) {
            block5: {
                try {
                    if (!event.isTerminal()) break block5;
                    this.close(event.nodata());
                    return -1L;
                }
                catch (Exception e) {
                    this.close(PushEvent.error(e));
                    return -1L;
                }
            }
            PushEventConsumer<T> consumer = this.next.get();
            long val = consumer == null ? 0L : consumer.accept(event);
            if (val < 0L) {
                this.close();
            }
            return val;
        }
        return -1L;
    }

    @Override
    public void close() {
        PushEvent close = PushEvent.close();
        if (this.close(close, true)) {
            this.upstreamClose(close);
        }
    }

    protected boolean close(PushEvent<T> event) {
        return this.close(event, true);
    }

    protected boolean close(PushEvent<T> event, boolean sendDownStreamEvent) {
        if (!event.isTerminal()) {
            throw new IllegalArgumentException("The event " + event + " is not a close event.");
        }
        if (this.closed.getAndSet(State.CLOSED) != State.CLOSED) {
            Consumer errorHandler;
            Runnable handler;
            PushEventConsumer aec = this.next.getAndSet(null);
            if (sendDownStreamEvent && aec != null) {
                try {
                    aec.accept(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((handler = (Runnable)this.onCloseCallback.getAndSet(null)) != null) {
                try {
                    handler.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (event.getType() == PushEvent.EventType.ERROR && (errorHandler = (Consumer)this.onErrorCallback.getAndSet(null)) != null) {
                try {
                    errorHandler.accept(event.getFailure());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public PushStream<T> onClose(Runnable closeHandler) {
        if (this.onCloseCallback.compareAndSet(null, closeHandler)) {
            if (this.closed.get() == State.CLOSED && this.onCloseCallback.compareAndSet(closeHandler, null)) {
                closeHandler.run();
            }
        } else {
            throw new IllegalStateException("A close handler has already been defined for this stream object");
        }
        return this;
    }

    @Override
    public PushStream<T> onError(Consumer<? super Throwable> closeHandler) {
        if (this.onErrorCallback.compareAndSet(null, closeHandler)) {
            if (this.closed.get() == State.CLOSED) {
                this.onErrorCallback.set(null);
            }
        } else {
            throw new IllegalStateException("A close handler has already been defined for this stream object");
        }
        return this;
    }

    private void updateNext(PushEventConsumer<T> consumer) {
        if (!this.next.compareAndSet(null, consumer)) {
            throw new IllegalStateException("This stream has already been chained");
        }
        if (this.closed.get() == State.CLOSED && this.next.compareAndSet(consumer, null)) {
            try {
                consumer.accept(PushEvent.close());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public PushStream<T> filter(Predicate<? super T> predicate) {
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl(this.psp, this.promiseFactory, this);
        this.updateNext(event -> {
            block4: {
                try {
                    if (event.isTerminal()) break block4;
                    if (predicate.test(event.getData())) {
                        return eventStream.handleEvent(event);
                    }
                    return 0L;
                }
                catch (Exception e) {
                    this.close(PushEvent.error(e));
                    return -1L;
                }
            }
            return eventStream.handleEvent(event);
        });
        return eventStream;
    }

    @Override
    public <R> PushStream<R> map(Function<? super T, ? extends R> mapper) {
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl(this.psp, this.promiseFactory, this);
        this.updateNext(event -> {
            try {
                if (!event.isTerminal()) {
                    return eventStream.handleEvent(PushEvent.data(mapper.apply(event.getData())));
                }
                return eventStream.handleEvent(event.nodata());
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        });
        return eventStream;
    }

    @Override
    public <R> PushStream<R> asyncMap(int n, int delay, Function<? super T, Promise<? extends R>> mapper) {
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl(this.psp, this.promiseFactory, this);
        Semaphore s = new Semaphore(n);
        this.updateNext(event -> {
            block3: {
                try {
                    if (!event.isTerminal()) break block3;
                    s.acquire(n);
                    eventStream.close(event.nodata());
                    return -1L;
                }
                catch (Exception e) {
                    this.close(PushEvent.error(e));
                    return -1L;
                }
            }
            s.acquire(1);
            Promise p = (Promise)mapper.apply(event.getData());
            p.thenAccept(d -> this.promiseFactory.executor().execute(() -> {
                try {
                    if (eventStream.handleEvent(PushEvent.data(d)) < 0L) {
                        PushEvent close = PushEvent.close();
                        eventStream.close(close);
                        this.upstreamClose(close);
                    }
                }
                finally {
                    s.release();
                }
            })).onFailure(t -> this.promiseFactory.executor().execute(() -> {
                PushEvent error = PushEvent.error(t);
                this.close(error);
                this.upstreamClose(error);
            }));
            int activePromises = Math.max(0, n - s.availablePermits() - 1);
            return (activePromises + s.getQueueLength()) * delay;
        });
        return eventStream;
    }

    @Override
    public <R> PushStream<R> flatMap(Function<? super T, ? extends PushStream<? extends R>> mapper) {
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl(this.psp, this.promiseFactory, this);
        PushEventConsumer consumer = e -> {
            switch (e.getType()) {
                case ERROR: {
                    this.close(e.nodata());
                    return -1L;
                }
                case CLOSE: {
                    return -1L;
                }
                case DATA: {
                    long returnValue = eventStream.handleEvent(e);
                    if (returnValue < 0L) {
                        this.close();
                        return -1L;
                    }
                    return returnValue;
                }
            }
            throw new IllegalArgumentException("The event type " + (Object)((Object)e.getType()) + " is unknown");
        };
        this.updateNext(event -> {
            try {
                if (!event.isTerminal()) {
                    PushStream mappedStream = (PushStream)mapper.apply(event.getData());
                    return (Long)mappedStream.forEachEvent(consumer).getValue();
                }
                return eventStream.handleEvent(event.nodata());
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        });
        return eventStream;
    }

    @Override
    public PushStream<T> distinct() {
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        return this.filter(set::add);
    }

    @Override
    public PushStream<T> sorted() {
        return this.sorted(Comparator.naturalOrder());
    }

    @Override
    public PushStream<T> sorted(Comparator<? super T> comparator) {
        List list = Collections.synchronizedList(new ArrayList());
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl(this.psp, this.promiseFactory, this);
        this.updateNext(event -> {
            try {
                switch (event.getType()) {
                    case DATA: {
                        list.add(event.getData());
                        return 0L;
                    }
                    case CLOSE: {
                        list.sort(comparator);
                        for (Object t : list) {
                            if (eventStream.handleEvent(PushEvent.data(t)) < 0L) break;
                        }
                    }
                    case ERROR: {
                        eventStream.handleEvent(event);
                        return -1L;
                    }
                }
                return eventStream.handleEvent(event.nodata());
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        });
        return eventStream;
    }

    @Override
    public PushStream<T> limit(long maxSize) {
        if (maxSize <= 0L) {
            throw new IllegalArgumentException("The limit must be greater than zero");
        }
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl(this.psp, this.promiseFactory, this);
        AtomicLong counter = new AtomicLong(maxSize);
        this.updateNext(event -> {
            block5: {
                try {
                    if (event.isTerminal()) break block5;
                    long count = counter.decrementAndGet();
                    if (count > 0L) {
                        return eventStream.handleEvent(event);
                    }
                    if (count == 0L) {
                        eventStream.handleEvent(event);
                    }
                    return -1L;
                }
                catch (Exception e) {
                    this.close(PushEvent.error(e));
                    return -1L;
                }
            }
            return eventStream.handleEvent(event.nodata());
        });
        return eventStream;
    }

    @Override
    public PushStream<T> limit(Duration maxTime) {
        final Runnable start = () -> {
            ScheduledFuture<?> scheduledFuture = this.promiseFactory.scheduledExecutor().schedule(() -> this.close(), maxTime.toNanos(), TimeUnit.NANOSECONDS);
        };
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl<T>(this.psp, this.promiseFactory, this){

            @Override
            protected void beginning() {
                start.run();
            }
        };
        this.updateNext(event -> {
            try {
                return eventStream.handleEvent(event);
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        });
        return eventStream;
    }

    @Override
    public PushStream<T> timeout(Duration maxTime) {
        final AtomicLong lastTime = new AtomicLong();
        final long timeout = maxTime.toNanos();
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl<T>(this.psp, this.promiseFactory, this){

            @Override
            protected void beginning() {
                lastTime.set(System.nanoTime());
                this.promiseFactory.scheduledExecutor().schedule(() -> this.check(lastTime, timeout), timeout, TimeUnit.NANOSECONDS);
            }
        };
        this.updateNext(event -> {
            try {
                return eventStream.handleEvent(event);
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        });
        return eventStream;
    }

    void check(AtomicLong lastTime, long timeout) {
        long now = System.nanoTime();
        long elapsed = now - lastTime.get();
        if (elapsed < timeout) {
            this.promiseFactory.scheduledExecutor().schedule(() -> this.check(lastTime, timeout), timeout - elapsed, TimeUnit.NANOSECONDS);
        } else {
            PushEvent error = PushEvent.error((Throwable)new TimeoutException());
            this.close(error);
            this.upstreamClose(error);
        }
    }

    @Override
    public PushStream<T> skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("The number to skip must be greater than or equal to zero");
        }
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl(this.psp, this.promiseFactory, this);
        AtomicLong counter = new AtomicLong(n);
        this.updateNext(event -> {
            block3: {
                try {
                    if (event.isTerminal()) return eventStream.handleEvent(event.nodata());
                    if (counter.get() <= 0L || counter.decrementAndGet() < 0L) break block3;
                    return 0L;
                }
                catch (Exception e) {
                    this.close(PushEvent.error(e));
                    return -1L;
                }
            }
            return eventStream.handleEvent(event);
        });
        return eventStream;
    }

    @Override
    public PushStream<T> fork(int n, int delay, Executor ex) {
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl(this.psp, new PromiseFactory(Objects.requireNonNull(ex), this.promiseFactory.scheduledExecutor()), this);
        Semaphore s = new Semaphore(n);
        this.updateNext(event -> {
            block3: {
                try {
                    if (!event.isTerminal()) break block3;
                    s.acquire(n);
                    eventStream.close(event.nodata());
                    return -1L;
                }
                catch (Exception e) {
                    this.close(PushEvent.error(e));
                    return -1L;
                }
            }
            s.acquire(1);
            ex.execute(() -> {
                try {
                    try {
                        if (eventStream.handleEvent(event) < 0L) {
                            PushEvent close = PushEvent.close();
                            eventStream.close(close);
                            this.upstreamClose(close);
                        }
                    }
                    catch (Exception e1) {
                        PushEvent error = PushEvent.error(e1);
                        this.close(error);
                        this.upstreamClose(error);
                        s.release(1);
                    }
                }
                finally {
                    s.release(1);
                }
            });
            return s.getQueueLength() * delay;
        });
        return eventStream;
    }

    @Override
    public PushStream<T> buffer() {
        return this.psp.createStream(c -> {
            this.forEachEvent(c);
            return this;
        });
    }

    @Override
    public <U extends BlockingQueue<PushEvent<? extends T>>> PushStreamBuilder<T, U> buildBuffer() {
        return this.psp.buildStream(c -> {
            this.forEachEvent(c);
            return this;
        });
    }

    @Override
    public PushStream<T> merge(PushEventSource<? extends T> source) {
        AutoCloseable second;
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl(this.psp, this.promiseFactory, this);
        AtomicInteger count = new AtomicInteger(2);
        PushEventConsumer consumer = event -> {
            try {
                if (!event.isTerminal()) {
                    return eventStream.handleEvent(event);
                }
                if (count.decrementAndGet() == 0) {
                    eventStream.handleEvent(event.nodata());
                    return -1L;
                }
                return 0L;
            }
            catch (Exception e) {
                PushEvent error = PushEvent.error(e);
                this.close(error);
                eventStream.close(event.nodata());
                return -1L;
            }
        };
        this.updateNext(consumer);
        try {
            second = source.open(event -> consumer.accept(event));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Unable to merge events as the event source could not be opened.", e);
        }
        return eventStream.onClose(() -> {
            try {
                second.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).map(this.IDENTITY);
    }

    @Override
    public PushStream<T> merge(final PushStream<? extends T> source) {
        AtomicInteger count = new AtomicInteger(2);
        final Consumer<AbstractPushStreamImpl> start = downstream -> {
            PushEventConsumer consumer = e -> {
                long toReturn;
                block11: {
                    try {
                        if (!e.isTerminal()) {
                            toReturn = downstream.handleEvent(e);
                            break block11;
                        }
                        if (count.decrementAndGet() == 0) {
                            downstream.handleEvent(e);
                            toReturn = -1L;
                            break block11;
                        }
                        return -1L;
                    }
                    catch (Exception ex) {
                        try {
                            downstream.handleEvent(PushEvent.error(ex));
                        }
                        catch (Exception exception) {}
                        toReturn = -1L;
                    }
                }
                if (toReturn < 0L) {
                    try {
                        this.close();
                    }
                    catch (Exception exception) {}
                    try {
                        source.close();
                    }
                    catch (Exception exception) {}
                }
                return toReturn;
            };
            this.forEachEvent(consumer);
            source.forEachEvent(consumer);
        };
        AbstractPushStreamImpl eventStream = new AbstractPushStreamImpl<T>(this.psp, this.promiseFactory){

            @Override
            protected boolean begin() {
                if (this.closed.compareAndSet(State.BUILDING, State.STARTED)) {
                    start.accept(this);
                    return true;
                }
                return false;
            }

            @Override
            protected void upstreamClose(PushEvent<?> close) {
                AbstractPushStreamImpl.this.upstreamClose(close);
                source.close();
            }
        };
        return eventStream.onClose(() -> {
            try {
                this.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                source.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).map(this.IDENTITY);
    }

    @Override
    public PushStream<T>[] split(Predicate<? super T> ... predicates) {
        Predicate<? super T>[] tests = Arrays.copyOf(predicates, predicates.length);
        AbstractPushStreamImpl[] rsult = new AbstractPushStreamImpl[tests.length];
        int i = 0;
        while (i < tests.length) {
            rsult[i] = new IntermediatePushStreamImpl(this.psp, this.promiseFactory, this);
            ++i;
        }
        Object[] array = new Boolean[tests.length];
        Arrays.fill(array, Boolean.TRUE);
        AtomicReferenceArray<Object> off = new AtomicReferenceArray<Object>(array);
        AtomicInteger count = new AtomicInteger(tests.length);
        this.updateNext(event -> {
            if (!event.isTerminal()) {
                long delay = 0L;
                int i = 0;
                while (i < tests.length) {
                    try {
                        if (((Boolean)off.get(i)).booleanValue() && tests[i].test(event.getData())) {
                            long accept = rsult[i].handleEvent(event);
                            if (accept < 0L) {
                                off.set(i, Boolean.TRUE);
                                count.decrementAndGet();
                            } else if (accept > delay) {
                                accept = delay;
                            }
                        }
                    }
                    catch (Exception e) {
                        try {
                            rsult[i].close(PushEvent.error(e));
                        }
                        catch (Exception exception) {}
                        off.set(i, Boolean.TRUE);
                    }
                    ++i;
                }
                if (count.get() == 0) {
                    return -1L;
                }
                return delay;
            }
            AbstractPushStreamImpl[] abstractPushStreamImplArray2 = rsult;
            int n = rsult.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractPushStreamImpl as = abstractPushStreamImplArray2[n2];
                try {
                    as.handleEvent(event.nodata());
                }
                catch (Exception e) {
                    try {
                        as.close(PushEvent.error(e));
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
            return -1L;
        });
        return Arrays.copyOf(rsult, tests.length);
    }

    @Override
    public PushStream<T> sequential() {
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl(this.psp, this.promiseFactory, this);
        ReentrantLock lock = new ReentrantLock();
        this.updateNext(event -> {
            lock.lock();
            try {
                long l = eventStream.handleEvent(event);
                lock.unlock();
                return l;
            }
            catch (Throwable throwable) {
                try {
                    lock.unlock();
                    throw throwable;
                }
                catch (Exception e) {
                    this.close(PushEvent.error(e));
                    return -1L;
                }
            }
        });
        return eventStream;
    }

    @Override
    public <R> PushStream<R> coalesce(Function<? super T, Optional<R>> accumulator) {
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl(this.psp, this.promiseFactory, this);
        this.updateNext(event -> {
            block6: {
                try {
                    if (event.isTerminal()) break block6;
                    Optional<PushEvent> coalesced = ((Optional)accumulator.apply(event.getData())).map(PushEvent::data);
                    if (coalesced.isPresent()) {
                        try {
                            return eventStream.handleEvent(coalesced.get());
                        }
                        catch (Exception ex) {
                            this.close(PushEvent.error(ex));
                            return -1L;
                        }
                    }
                    return 0L;
                }
                catch (Exception e) {
                    this.close(PushEvent.error(e));
                    return -1L;
                }
            }
            return eventStream.handleEvent(event.nodata());
        });
        return eventStream;
    }

    @Override
    public <R> PushStream<R> coalesce(int count, Function<Collection<T>, R> f) {
        if (count <= 0) {
            throw new IllegalArgumentException("A coalesce operation must collect a positive number of events");
        }
        return this.coalesce(() -> count, f);
    }

    @Override
    public <R> PushStream<R> coalesce(IntSupplier count, Function<Collection<T>, R> f) {
        AtomicReference<Object> queueRef = new AtomicReference<Object>(null);
        final Runnable init = () -> queueRef.set(this.getQueueForInternalBuffering(count.getAsInt()));
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl<R>(this.psp, this.promiseFactory, this){

            @Override
            protected void beginning() {
                init.run();
            }
        };
        AtomicBoolean endPending = new AtomicBoolean();
        Object lock = new Object();
        this.updateNext(event -> {
            try {
                Queue queue;
                if (!event.isTerminal()) {
                    Queue queue2;
                    Object object2 = lock;
                    synchronized (object2) {
                        while ((queue2 = (Queue)queueRef.get()) == null) {
                            if (!endPending.get()) continue;
                            return -1L;
                        }
                        if (queue2.offer(event.getData())) {
                            return 0L;
                        }
                        queueRef.lazySet(null);
                    }
                    queueRef.set(this.getQueueForInternalBuffering(count.getAsInt()));
                    return this.aggregateAndForward(f, eventStream, event, queue2);
                }
                Object object3 = lock;
                synchronized (object3) {
                    queue = (Queue)queueRef.get();
                    queueRef.lazySet(null);
                    endPending.set(true);
                }
                if (queue != null) {
                    eventStream.handleEvent(PushEvent.data(f.apply((Object)queue)));
                }
                return eventStream.handleEvent(event.nodata());
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        });
        return eventStream;
    }

    private <R> long aggregateAndForward(Function<Collection<T>, R> f, AbstractPushStreamImpl<R> eventStream, PushEvent<? extends T> event, Queue<T> queue) throws Exception {
        if (!queue.offer(event.getData())) {
            ((ArrayQueue)queue).forcePush(event.getData());
        }
        return eventStream.handleEvent(PushEvent.data(f.apply(queue)));
    }

    @Override
    public <R> PushStream<R> window(Duration time, Function<Collection<T>, R> f) {
        return this.window(time, this.promiseFactory.executor(), f);
    }

    @Override
    public <R> PushStream<R> window(Duration time, Executor executor, Function<Collection<T>, R> f) {
        return this.window(() -> time, () -> 0, executor, (t, c) -> {
            try {
                return f.apply(c);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public <R> PushStream<R> window(Supplier<Duration> time, IntSupplier maxEvents, BiFunction<Long, Collection<T>, R> f) {
        return this.window(time, maxEvents, this.promiseFactory.executor(), f);
    }

    @Override
    public <R> PushStream<R> window(Supplier<Duration> time, IntSupplier maxEvents, Executor ex, BiFunction<Long, Collection<T>, R> f) {
        AtomicLong timestamp = new AtomicLong();
        AtomicLong previousWindowSize = new AtomicLong();
        AtomicLong counter = new AtomicLong();
        Object lock = new Object();
        AtomicReference<Object> queueRef = new AtomicReference<Object>(null);
        final Consumer<AbstractPushStreamImpl> begin = p -> {
            Object object2 = lock;
            synchronized (object2) {
                timestamp.lazySet(System.nanoTime());
                long count = counter.get();
                long windowSize = ((Duration)time.get()).toNanos();
                previousWindowSize.set(windowSize);
                this.promiseFactory.scheduledExecutor().schedule(this.getWindowTask((AbstractPushStreamImpl)p, f, time, maxEvents, lock, count, (AtomicReference<Queue<T>>)queueRef, timestamp, counter, previousWindowSize, ex), windowSize, TimeUnit.NANOSECONDS);
            }
            queueRef.set(this.getQueueForInternalBuffering(maxEvents.getAsInt()));
        };
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl<R>(this.psp, new PromiseFactory(Objects.requireNonNull(ex), this.promiseFactory.scheduledExecutor()), this){

            @Override
            protected void beginning() {
                begin.accept(this);
            }
        };
        AtomicBoolean endPending = new AtomicBoolean(false);
        this.updateNext(event -> {
            try {
                long elapsed;
                Queue queue;
                if (abstractPushStreamImpl.closed.get() == State.CLOSED) {
                    return -1L;
                }
                if (!event.isTerminal()) {
                    long newCount;
                    long elapsed2;
                    Object object2 = lock;
                    synchronized (object2) {
                        Queue queue2;
                        while ((queue2 = (Queue)queueRef.get()) == null) {
                            if (!endPending.get()) continue;
                            return -1L;
                        }
                        if (queue2.offer(event.getData())) {
                            return 0L;
                        }
                        queueRef.lazySet(null);
                        long now = System.nanoTime();
                        elapsed2 = now - timestamp.get();
                        timestamp.lazySet(now);
                        newCount = counter.get() + 1L;
                        counter.lazySet(newCount);
                        this.aggregateAndForward(f, eventStream, event, queue2, ex, elapsed2);
                    }
                    queueRef.set(this.getQueueForInternalBuffering(maxEvents.getAsInt()));
                    long nextWindow = ((Duration)time.get()).toNanos();
                    long backpressure = previousWindowSize.getAndSet(nextWindow) - elapsed2;
                    this.promiseFactory.scheduledExecutor().schedule(this.getWindowTask(eventStream, f, time, maxEvents, lock, newCount, queueRef, timestamp, counter, previousWindowSize, ex), nextWindow, TimeUnit.NANOSECONDS);
                    if (backpressure < 0L) {
                        return 0L;
                    }
                    long l = TimeUnit.NANOSECONDS.toMillis(backpressure);
                    return l;
                }
                Object newCount = lock;
                synchronized (newCount) {
                    queue = (Queue)queueRef.get();
                    queueRef.lazySet(null);
                    endPending.set(true);
                    long now = System.nanoTime();
                    elapsed = now - timestamp.get();
                    counter.lazySet(counter.get() + 1L);
                }
                Collection<Object> collected = queue == null ? Collections.emptyList() : queue;
                ex.execute(() -> {
                    try {
                        eventStream.handleEvent(PushEvent.data(f.apply(TimeUnit.NANOSECONDS.toMillis(elapsed), collected)));
                    }
                    catch (Exception e) {
                        PushEvent error = PushEvent.error(e);
                        this.close(error);
                        this.upstreamClose(error);
                    }
                });
                ex.execute(() -> {
                    long l = eventStream.handleEvent(event.nodata());
                });
                return -1L;
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        });
        return eventStream;
    }

    protected Queue<T> getQueueForInternalBuffering(int size) {
        if (size == 0) {
            return new LinkedList();
        }
        return new ArrayQueue(size - 1);
    }

    private <R> Runnable getWindowTask(AbstractPushStreamImpl<R> eventStream, BiFunction<Long, Collection<T>, R> f, Supplier<Duration> time, IntSupplier maxEvents, Object lock, long expectedCounter, AtomicReference<Queue<T>> queueRef, AtomicLong timestamp, AtomicLong counter, AtomicLong previousWindowSize, Executor executor) {
        return () -> {
            Queue queue = null;
            Object object2 = lock;
            synchronized (object2) {
                if (counter.get() != expectedCounter) {
                    return;
                }
                counter.lazySet(expectedCounter + 1L);
                long now = System.nanoTime();
                long elapsed = now - timestamp.get();
                timestamp.lazySet(now);
                queue = (Queue)queueRef.get();
                queueRef.lazySet(null);
                Collection<Object> collected = queue == null ? Collections.emptyList() : queue;
                executor.execute(() -> {
                    try {
                        eventStream.handleEvent(PushEvent.data(f.apply(TimeUnit.NANOSECONDS.toMillis(elapsed), collected)));
                    }
                    catch (Exception e) {
                        PushEvent error = PushEvent.error(e);
                        this.close(error);
                        this.upstreamClose(error);
                    }
                });
            }
            long nextWindow = ((Duration)time.get()).toNanos();
            previousWindowSize.set(nextWindow);
            queueRef.set(this.getQueueForInternalBuffering(maxEvents.getAsInt()));
            this.promiseFactory.scheduledExecutor().schedule(this.getWindowTask(eventStream, f, time, maxEvents, lock, expectedCounter + 1L, queueRef, timestamp, counter, previousWindowSize, executor), nextWindow, TimeUnit.NANOSECONDS);
        };
    }

    private <R> void aggregateAndForward(BiFunction<Long, Collection<T>, R> f, AbstractPushStreamImpl<R> eventStream, PushEvent<? extends T> event, Queue<T> queue, Executor executor, long elapsed) {
        executor.execute(() -> {
            try {
                long result;
                if (!queue.offer(event.getData())) {
                    ((ArrayQueue)queue).forcePush(event.getData());
                }
                if ((result = eventStream.handleEvent(PushEvent.data(f.apply(TimeUnit.NANOSECONDS.toMillis(elapsed), queue)))) < 0L) {
                    this.close();
                }
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
            }
        });
    }

    @Override
    public PushStream<T> adjustBackPressure(LongUnaryOperator adjustment) {
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl(this.psp, this.promiseFactory, this);
        this.updateNext(event -> {
            long bp;
            block3: {
                try {
                    bp = eventStream.handleEvent(event);
                    if (!event.isTerminal()) break block3;
                    return -1L;
                }
                catch (Exception e) {
                    this.close(PushEvent.error(e));
                    return -1L;
                }
            }
            return bp < 0L ? bp : adjustment.applyAsLong(bp);
        });
        return eventStream;
    }

    @Override
    public PushStream<T> adjustBackPressure(ToLongBiFunction<T, Long> adjustment) {
        IntermediatePushStreamImpl eventStream = new IntermediatePushStreamImpl(this.psp, this.promiseFactory, this);
        this.updateNext(event -> {
            long bp;
            block3: {
                try {
                    bp = eventStream.handleEvent(event);
                    if (!event.isTerminal()) break block3;
                    return -1L;
                }
                catch (Exception e) {
                    this.close(PushEvent.error(e));
                    return -1L;
                }
            }
            return bp < 0L ? bp : adjustment.applyAsLong(event.getData(), bp);
        });
        return eventStream;
    }

    @Override
    public Promise<Void> forEach(Consumer<? super T> action) {
        Deferred d = this.promiseFactory.deferred();
        this.updateNext(event -> {
            try {
                switch (event.getType()) {
                    case DATA: {
                        action.accept((T)event.getData());
                        return 0L;
                    }
                    case CLOSE: {
                        d.resolve(null);
                        break;
                    }
                    case ERROR: {
                        d.fail(event.getFailure());
                        break;
                    }
                }
                this.close(event.nodata());
                return -1L;
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        });
        this.begin();
        return d.getPromise();
    }

    @Override
    public Promise<Object[]> toArray() {
        return this.collect(Collectors.toList()).map(List::toArray);
    }

    @Override
    public <A extends T> Promise<A[]> toArray(IntFunction<A[]> generator) {
        return this.collect(Collectors.toList()).map(l -> l.toArray((Object[])generator.apply(l.size())));
    }

    @Override
    public Promise<T> reduce(T identity, BinaryOperator<T> accumulator) {
        Deferred d = this.promiseFactory.deferred();
        AtomicReference<T> iden = new AtomicReference<T>(identity);
        this.updateNext(event -> {
            try {
                switch (event.getType()) {
                    case DATA: {
                        iden.accumulateAndGet(event.getData(), accumulator);
                        return 0L;
                    }
                    case CLOSE: {
                        d.resolve(iden.get());
                        break;
                    }
                    case ERROR: {
                        d.fail(event.getFailure());
                        break;
                    }
                }
                this.close(event.nodata());
                return -1L;
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        });
        this.begin();
        return d.getPromise();
    }

    @Override
    public Promise<Optional<T>> reduce(BinaryOperator<T> accumulator) {
        Deferred d = this.promiseFactory.deferred();
        AtomicReference<Object> iden = new AtomicReference<Object>(null);
        this.updateNext(event -> {
            try {
                switch (event.getType()) {
                    case DATA: {
                        if (!iden.compareAndSet(null, event.getData())) {
                            iden.accumulateAndGet(event.getData(), (BinaryOperator<Object>)accumulator);
                        }
                        return 0L;
                    }
                    case CLOSE: {
                        d.resolve(Optional.ofNullable(iden.get()));
                        break;
                    }
                    case ERROR: {
                        d.fail(event.getFailure());
                        break;
                    }
                }
                this.close(event.nodata());
                return -1L;
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        });
        this.begin();
        return d.getPromise();
    }

    @Override
    public <U> Promise<U> reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        Deferred d = this.promiseFactory.deferred();
        AtomicReference iden = new AtomicReference(identity);
        this.updateNext(event -> {
            try {
                switch (event.getType()) {
                    case DATA: {
                        iden.updateAndGet(e -> accumulator.apply(e, event.getData()));
                        return 0L;
                    }
                    case CLOSE: {
                        d.resolve(iden.get());
                        break;
                    }
                    case ERROR: {
                        d.fail(event.getFailure());
                        break;
                    }
                }
                this.close(event.nodata());
                return -1L;
            }
            catch (Exception e2) {
                this.close(PushEvent.error(e2));
                return -1L;
            }
        });
        this.begin();
        return d.getPromise();
    }

    @Override
    public <R, A> Promise<R> collect(Collector<? super T, A, R> collector) {
        Object result = collector.supplier().get();
        BiConsumer accumulator = collector.accumulator();
        Deferred d = this.promiseFactory.deferred();
        PushEventConsumer consumer = collector.characteristics().contains((Object)Collector.Characteristics.CONCURRENT) ? event -> {
            try {
                switch (event.getType()) {
                    case DATA: {
                        accumulator.accept(result, (T)event.getData());
                        return 0L;
                    }
                    case CLOSE: {
                        d.resolve(collector.finisher().apply(result));
                        break;
                    }
                    case ERROR: {
                        d.fail(event.getFailure());
                        break;
                    }
                }
                this.close(event.nodata());
                return -1L;
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        } : event -> {
            try {
                switch (event.getType()) {
                    case DATA: {
                        Object object2 = result;
                        synchronized (object2) {
                            accumulator.accept(result, (T)event.getData());
                            return 0L;
                        }
                    }
                    case CLOSE: {
                        d.resolve(collector.finisher().apply(result));
                        break;
                    }
                    case ERROR: {
                        d.fail(event.getFailure());
                        break;
                    }
                }
                this.close(event.nodata());
                return -1L;
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        };
        this.updateNext(consumer);
        this.begin();
        return d.getPromise();
    }

    @Override
    public Promise<Optional<T>> min(Comparator<? super T> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) <= 0 ? a : b);
    }

    @Override
    public Promise<Optional<T>> max(Comparator<? super T> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) > 0 ? a : b);
    }

    @Override
    public Promise<Long> count() {
        Deferred d = this.promiseFactory.deferred();
        LongAdder counter = new LongAdder();
        this.updateNext(event -> {
            try {
                switch (event.getType()) {
                    case DATA: {
                        counter.add(1L);
                        return 0L;
                    }
                    case CLOSE: {
                        d.resolve((Object)counter.sum());
                        break;
                    }
                    case ERROR: {
                        d.fail(event.getFailure());
                        break;
                    }
                }
                this.close(event.nodata());
                return -1L;
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        });
        this.begin();
        return d.getPromise();
    }

    @Override
    public Promise<Boolean> anyMatch(Predicate<? super T> predicate) {
        return this.filter(predicate).findAny().map(Optional::isPresent);
    }

    @Override
    public Promise<Boolean> allMatch(Predicate<? super T> predicate) {
        return this.filter(x -> !predicate.test(x)).findAny().map(o -> !o.isPresent());
    }

    @Override
    public Promise<Boolean> noneMatch(Predicate<? super T> predicate) {
        return this.filter(predicate).findAny().map(o -> !o.isPresent());
    }

    @Override
    public Promise<Optional<T>> findFirst() {
        Deferred d = this.promiseFactory.deferred();
        this.updateNext(event -> {
            try {
                Optional o = null;
                switch (event.getType()) {
                    case DATA: {
                        o = Optional.of(event.getData());
                        break;
                    }
                    case CLOSE: {
                        o = Optional.empty();
                        break;
                    }
                    case ERROR: {
                        d.fail(event.getFailure());
                        return -1L;
                    }
                }
                if (!d.getPromise().isDone()) {
                    d.resolve(o);
                }
                return -1L;
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        });
        this.begin();
        return d.getPromise();
    }

    @Override
    public Promise<Optional<T>> findAny() {
        return this.findFirst();
    }

    @Override
    public Promise<Long> forEachEvent(PushEventConsumer<? super T> action) {
        Deferred d = this.promiseFactory.deferred();
        LongAdder la = new LongAdder();
        this.updateNext(event -> {
            try {
                switch (event.getType()) {
                    case DATA: {
                        long value = action.accept(event);
                        la.add(value);
                        return value;
                    }
                    case CLOSE: {
                        try {
                            action.accept(event);
                            d.resolve((Object)la.sum());
                        }
                        catch (Exception e) {
                            d.fail((Throwable)e);
                        }
                        break;
                    }
                    case ERROR: {
                        try {
                            action.accept(event);
                            d.fail(event.getFailure());
                            break;
                        }
                        catch (Exception e) {
                            d.fail((Throwable)e);
                        }
                    }
                }
                return -1L;
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        });
        this.begin();
        return d.getPromise();
    }

    private static class ArrayQueue<E>
    extends AbstractQueue<E>
    implements Queue<E> {
        final Object[] store;
        int normalLength;
        int nextIndex;
        int size;

        ArrayQueue(int capacity) {
            this.store = new Object[capacity + 1];
            this.normalLength = this.store.length - 1;
        }

        @Override
        public boolean offer(E e) {
            if (e == null) {
                throw new NullPointerException("Null values are not supported");
            }
            if (this.size < this.normalLength) {
                this.store[this.nextIndex] = e;
                ++this.size;
                ++this.nextIndex;
                this.nextIndex %= this.normalLength;
                return true;
            }
            return false;
        }

        public void forcePush(E e) {
            this.store[this.normalLength] = e;
            ++this.normalLength;
            ++this.size;
        }

        @Override
        public E poll() {
            if (this.size == 0) {
                return null;
            }
            int idx = this.nextIndex - this.size;
            if (idx < 0) {
                idx += this.normalLength;
            }
            Object value = this.store[idx];
            this.store[idx] = null;
            --this.size;
            return (E)value;
        }

        @Override
        public E peek() {
            if (this.size == 0) {
                return null;
            }
            int idx = this.nextIndex - this.size;
            if (idx < 0) {
                idx += this.normalLength;
            }
            return (E)this.store[idx];
        }

        @Override
        public Iterator<E> iterator() {
            final int previousNext = this.nextIndex;
            return new Iterator<E>(){
                int idx;
                int remaining;
                {
                    this.remaining = arrayQueue.size;
                    this.idx = arrayQueue.nextIndex - arrayQueue.size;
                    if (this.idx < 0) {
                        this.idx += arrayQueue.normalLength;
                    }
                }

                @Override
                public boolean hasNext() {
                    if (nextIndex != previousNext) {
                        throw new ConcurrentModificationException("The queue was concurrently modified");
                    }
                    return this.remaining > 0;
                }

                @Override
                public E next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("The iterator has no more values");
                    }
                    Object value = store[this.idx];
                    ++this.idx;
                    --this.remaining;
                    if (this.idx == normalLength) {
                        this.idx = 0;
                    }
                    return value;
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static enum State {
        BUILDING,
        STARTED,
        CLOSED;

    }
}

