/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.ws.http.HTTPException;
import org.eclipse.kura.web.server.KuraRemoteServiceServlet;
import org.eclipse.kura.web.server.RequiredPermissions;
import org.eclipse.kura.web.server.servlet.AuditServlet;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelServlet
extends AuditServlet {
    private static final long serialVersionUID = -1445700937173920652L;
    private static Logger logger = LoggerFactory.getLogger(ChannelServlet.class);

    public ChannelServlet() {
        super("UI Channel Servlet", "Write Channel CSV description");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        KuraRemoteServiceServlet.requirePermissions(req, RequiredPermissions.Mode.ALL, new String[]{"kura.wires.admin"});
        HttpSession session = req.getSession(false);
        try {
            GwtXSRFToken token = new GwtXSRFToken(req.getParameter("xsrfToken"));
            KuraRemoteServiceServlet.checkXSRFToken(req, token);
        }
        catch (Exception e) {
            throw new ServletException("Security error: please retry this operation correctly.", (Throwable)e);
        }
        try {
            String assetPid = req.getParameter("assetPid");
            String id = req.getParameter("id");
            String attributeKey = "kura.csv.download." + id;
            String result = (String)session.getAttribute(attributeKey);
            if (result == null) {
                throw new HTTPException(404);
            }
            session.removeAttribute(attributeKey);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("text/csv");
            resp.setHeader("Content-Disposition", "attachment; filename=asset_" + assetPid + ".csv");
            resp.setHeader("Cache-Control", "no-transform, max-age=0");
            Throwable throwable = null;
            Object var9_12 = null;
            try (PrintWriter writer = resp.getWriter();){
                writer.write(result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            logger.error("Error while exporting CSV output!", (Throwable)ex);
        }
    }
}

