/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.device;

import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtDeviceService;
import org.eclipse.kura.web.shared.service.GwtDeviceServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Input;
import org.gwtbootstrap3.client.ui.PanelBody;
import org.gwtbootstrap3.client.ui.TextBox;

public class CommandTabUi
extends Composite {
    private static CommandTabUiUiBinder uiBinder = (CommandTabUiUiBinder)GWT.create(CommandTabUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private static final String SERVLET_URL = "/" + GWT.getModuleName() + "/file/command";
    private GwtSession session;
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtDeviceServiceAsync gwtDeviceService = (GwtDeviceServiceAsync)GWT.create(GwtDeviceService.class);
    @UiField
    TextBox formExecute;
    @UiField
    Input formPassword;
    @UiField
    Button reset;
    @UiField
    Button execute;
    @UiField
    FormPanel commandForm;
    @UiField
    FileUpload docPath;
    @UiField
    PanelBody resultPanel;
    @UiField
    Hidden xsrfTokenField;
    String command;
    String password;
    SafeHtmlBuilder safeHtml = new SafeHtmlBuilder();

    public CommandTabUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.formExecute.clear();
        this.formExecute.setFocus(true);
        this.formExecute.setName("command");
        this.formExecute.addKeyDownHandler(event -> {
            if (event.getNativeKeyCode() == 13) {
                this.formPassword.setFocus(true);
            }
        });
        this.xsrfTokenField.setID("xsrfToken");
        this.xsrfTokenField.setName("xsrfToken");
        this.xsrfTokenField.setValue("");
        this.formPassword.setText(null);
        this.formPassword.setName("password");
        this.formPassword.addKeyDownHandler(event -> {
            if (event.getNativeKeyCode() == 13) {
                this.execute.setFocus(true);
            }
        });
        this.docPath.setName("file");
        this.display(MSGS.deviceCommandNoOutput());
        this.reset.setText(MSGS.reset());
        this.reset.addClickHandler(event -> {
            this.commandForm.reset();
            this.formExecute.setFocus(true);
            this.display(MSGS.deviceCommandNoOutput());
        });
        this.execute.setText(MSGS.deviceCommandExecute());
        this.execute.addClickHandler(event -> this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                CommandTabUi.this.xsrfTokenField.setValue(token.getToken());
                CommandTabUi.this.commandForm.submit();
                CommandTabUi.this.formExecute.setFocus(true);
            }
        }));
        this.commandForm.setEncoding("multipart/form-data");
        this.commandForm.setMethod("post");
        this.commandForm.setAction(SERVLET_URL);
        this.commandForm.addSubmitCompleteHandler(event -> {
            String result = event.getResults();
            if (result.contains("HTTP ERROR")) {
                this.display(MSGS.fileUploadFailure());
            } else {
                EntryClassUi.showWaitModal();
                this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                    public void onFailure(Throwable ex) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(ex);
                    }

                    public void onSuccess(GwtXSRFToken token) {
                        CommandTabUi.this.gwtDeviceService.executeCommand(token, CommandTabUi.this.formExecute.getText(), CommandTabUi.this.formPassword.getText(), new AsyncCallback<String>(){

                            public void onFailure(Throwable caught) {
                                if (caught.getLocalizedMessage().equals(GwtKuraErrorCode.SERVICE_NOT_ENABLED.toString())) {
                                    CommandTabUi.this.display(String.valueOf(MSGS.error()) + "\n" + MSGS.commandServiceNotEnabled());
                                } else if (caught.getLocalizedMessage().equals(GwtKuraErrorCode.ILLEGAL_ARGUMENT.toString())) {
                                    CommandTabUi.this.display(String.valueOf(MSGS.error()) + "\n" + MSGS.commandPasswordNotCorrect());
                                } else {
                                    CommandTabUi.this.display(String.valueOf(MSGS.error()) + "\n" + caught.getLocalizedMessage());
                                }
                                EntryClassUi.hideWaitModal();
                            }

                            public void onSuccess(String result) {
                                CommandTabUi.this.display(result);
                                EntryClassUi.hideWaitModal();
                            }
                        });
                    }
                });
            }
        });
    }

    public void display(String string) {
        this.resultPanel.clear();
        this.resultPanel.add((Widget)new HTML(new SafeHtmlBuilder().appendEscapedLines(string).toSafeHtml()));
    }

    public void setSession(GwtSession currentSession) {
        this.session = currentSession;
    }

    static interface CommandTabUiUiBinder
    extends UiBinder<Widget, CommandTabUi> {
    }
}

