/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.escapeSyntax.scalar3;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.fnSchema;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class scalarClient3
extends ServiceEETest {
    private static final String testName = "jdbc.ee.escapeSyntax";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private Statement stmt = null;
    private ResultSet rs = null;
    private String drManager = null;
    private fnSchema fnSch = null;
    private Properties props = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        scalarClient3 theTests = new scalarClient3();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.fnSch = new fnSchema();
                this.msg = new JDBCTestMsg();
                this.fnSch.createTable(p, this.conn);
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!", e);
        }
    }

    public void testWeek() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("WEEK", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function WEEK  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function WEEK is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testWeek failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Week_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Week of the year: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testWeek failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testWeek failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testMonth() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("MONTH", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function MONTH  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function MONTH is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testMonth failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Month_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Month of the year: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testMonth failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testMonth failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testYear() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("YEAR", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function YEAR  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function YEAR is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testYear failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Year_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Year component of date: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testYear failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testYear failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testMonthname() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("MONTHNAME", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function MONTHNAME  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function MONTHNAME is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testMonthname failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Monthname_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Month Name: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testMonthname failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testMonthname failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testQuarter() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("QUARTER", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function QUARTER  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function QUARTER is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testQuarter failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Quarter_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Quarter in date: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testQuarter Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testQuarter Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testNow() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("NOW", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function NOW  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function NOW is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testNow failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Now_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Current date & Time: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testNow failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testNow Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testHour() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("HOUR", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function HOUR  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function HOUR is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testHour failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Hour_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Hour component of time: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testHour failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testHour failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testMinute() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("MINUTE", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function MINUTE  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function MINUTE is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testMinute failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Minute_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Minute component of time: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testMinute failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testMinute Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testSecond() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isTimeDateFuncFound("SECOND", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Time Date function SECOND  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Time Date function SECOND is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testSecond failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Second_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Second component of time: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testSecond failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testSecond failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testDatabase() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isSystemFuncFound("DATABASE", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("System function DATABASE is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("System function DATABASE is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testDatabase Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Database_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("Database Name: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testDatabase Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testDatabase Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testAcos() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("ACOS", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function ACOS  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function ACOS is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testAcos failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Acos_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("ACOS value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testAcos Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testAcos Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testAsin() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("ASIN", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function ASIN  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function ASIN is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testAsin failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Asin_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("ASIN value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testAsin failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testAsin failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testAtan() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("ATAN", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function ATAN  is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function ATAN is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testAtan failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Atan_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("ATAN value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testAtan failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testAtan failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testAtan2() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("ATAN2", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function ATAN2 is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function ATAN2 is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testAtan2 failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Atan2_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("ATAN value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testAtan2 failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testAtan2 failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testDegrees() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("DEGREES", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function DEGREES is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function DEGREES is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testDegrees failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Degrees_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("DEGREES value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testDegrees failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testDegrees failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testRadians() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("RADIANS", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function RADIANS is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function RADIANS is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testRadians failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Radians_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("RADIANS value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testRadians failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testRadians failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testPi() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("PI", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function PI is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function PI is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testPi failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Pi_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("PI value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testPi failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testPi failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testRand() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isNumericFuncFound("RAND", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("Numeric function RAND is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("Numeric function RAND is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testRand Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Rand_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("RAND value: " + retString);
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testRand Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testRand Failed!");
            }
        }
    }

    public void testDifference() throws EETest.Fault {
        boolean isFuncFound = false;
        try {
            if (this.fnSch.isStringFuncFound("DIFFERENCE", this.conn)) {
                isFuncFound = true;
                this.msg.setMsg("String function DIFFERENCE is supported by this DBMS");
            } else {
                isFuncFound = false;
                this.msg.setMsg("String function DIFFERENCE is not supported by this DBMS");
            }
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testDifference Failed!");
        }
        if (isFuncFound) {
            try {
                String queryString = null;
                queryString = this.props.getProperty("Difference_Fn_Query", "");
                this.rs = this.stmt.executeQuery(queryString);
                this.rs.next();
                String retString = this.rs.getString(1);
                this.msg.setMsg("DIFFERENCE value: <" + retString + ">");
                this.rs.close();
            }
            catch (SQLException sqle) {
                this.msg.printSQLError(sqle, "Call to testDifference Failed!");
            }
            catch (Exception e) {
                this.msg.printError(e, "Call to testDifference Failed!");
            }
        }
        this.msg.printTestMsg();
    }

    public void testLocate02() throws EETest.Fault {
        try {
            String queryString = null;
            queryString = this.props.getProperty("Locate_Fn_Query", "");
            this.rs = this.stmt.executeQuery(queryString);
            this.rs.next();
            String retString = this.rs.getString(1);
            this.msg.setMsg("str1 starts at " + retString + " of str2");
            this.rs.close();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to testLocate02 Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to testLocate02 Failed!");
        }
        this.msg.printTestMsg();
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.stmt.close();
            this.fnSch.dropTable(this.props, this.conn);
            this.fnSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

