/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.manyXone.uni.delete;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.manyXone.uni.delete.ADVC;
import com.sun.ts.tests.ejb.ee.pm.manyXone.uni.delete.ALocal;
import com.sun.ts.tests.ejb.ee.pm.manyXone.uni.delete.ALocalHome;
import com.sun.ts.tests.ejb.ee.pm.manyXone.uni.delete.BDVC;
import com.sun.ts.tests.ejb.ee.pm.manyXone.uni.delete.BLocal;
import com.sun.ts.tests.ejb.ee.pm.manyXone.uni.delete.BLocalHome;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.RemoveException;
import java.util.Properties;
import javax.naming.NamingException;

public abstract class BeanEJB
implements EntityBean {
    private static final int NO_RELATION_SET = 0;
    private static final int NULL_RELATION_SET = 1;
    private static final int RELATION_SET = 2;
    private static final String ALocal = "java:comp/env/ejb/AEJBLocal";
    private static final String BLocal = "java:comp/env/ejb/BEJBLocal";
    private EntityContext context = null;
    private TSNamingContext nctx = null;

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract int getValue();

    public abstract void setValue(int var1);

    public abstract ALocal getA1();

    public abstract void setA1(ALocal var1);

    public abstract ALocal getA2();

    public abstract void setA2(ALocal var1);

    public abstract BLocal getB1();

    public abstract void setB1(BLocal var1);

    public abstract BLocal getB2();

    public abstract void setB2(BLocal var1);

    public abstract BLocal getB3();

    public abstract void setB3(BLocal var1);

    public abstract BLocal getB4();

    public abstract void setB4(BLocal var1);

    private boolean isA(int i) {
        TestUtil.logTrace((String)"isA");
        if (i == 1) {
            return this.getB1().getA() != null;
        }
        if (i == 2) {
            return this.getB2().getA() != null;
        }
        return false;
    }

    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            throw new EJBException(e.getMessage());
        }
    }

    public boolean isA() {
        TestUtil.logTrace((String)"isA");
        return this.getB1().getA() != null;
    }

    public ADVC getAInfo(int i) {
        TestUtil.logTrace((String)"getAInfo");
        if (this.isA(i)) {
            ALocal a = null;
            switch (i) {
                case 1: {
                    a = this.getB1().getA();
                    break;
                }
                case 2: {
                    a = this.getB2().getA();
                }
            }
            if (a != null) {
                return new ADVC(a.getId(), a.getName(), a.getValue());
            }
        }
        return null;
    }

    public boolean test1() {
        TestUtil.logMsg((String)"starting test1");
        ALocal aOne = null;
        BLocal bOne = null;
        BLocal bTwo = null;
        try {
            aOne = this.getA1();
            bOne = this.getB1();
            bTwo = this.getB2();
            TestUtil.logMsg((String)("aOne = " + aOne));
            TestUtil.logMsg((String)("bOne = " + bOne));
            TestUtil.logMsg((String)("bTwo = " + bTwo));
            TestUtil.logMsg((String)"Delete entitybean object A1");
            aOne.remove();
            TestUtil.logMsg((String)"Attempt to call a method on A1");
            aOne.getId();
            TestUtil.logErr((String)"Entitybean object A1 was not deleted, expected EJBException");
            return false;
        }
        catch (EJBException e) {
            TestUtil.logMsg((String)"Entitybean object A1 was deleted");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
        try {
            TestUtil.logMsg((String)"Delete entitybean object B1");
            bOne.remove();
            TestUtil.logMsg((String)"Attempt to call a method on B1");
            bOne.getId();
            TestUtil.logErr((String)"Entitybean object B1 was not deleted, expected EJBException");
            return false;
        }
        catch (EJBException e) {
            TestUtil.logMsg((String)"Entitybean object B1 was deleted");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
        try {
            TestUtil.logMsg((String)"Delete entitybean object B2");
            bTwo.remove();
            TestUtil.logMsg((String)"Attempt to call a method on second B2");
            bTwo.getId();
            TestUtil.logErr((String)"Entitybean object B2 was not deleted, expected EJBException");
            return false;
        }
        catch (EJBException e) {
            TestUtil.logMsg((String)"Entitybean object B2 was deleted");
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean test2() {
        TestUtil.logMsg((String)"starting test2");
        ALocal aOne = null;
        BLocal bOne = null;
        BLocal bTwo = null;
        try {
            aOne = this.getA1();
            bOne = this.getB1();
            bTwo = this.getB2();
            TestUtil.logMsg((String)("aOne = " + aOne));
            TestUtil.logMsg((String)("bOne = " + bOne));
            TestUtil.logMsg((String)("bTwo = " + bTwo));
            TestUtil.logMsg((String)"Delete entitybean object A1");
            aOne.remove();
            TestUtil.logMsg((String)"Check relationship accessor method of entitybean object bOne and bTwo");
            if (bOne.getA() != null || bTwo.getA() != null) {
                TestUtil.logMsg((String)"B1 and B2 relationship not updated corrently ");
                return false;
            }
            TestUtil.logMsg((String)"B1 and B2 relationship updated corrently ");
            TestUtil.logMsg((String)"Check relationship accessor method of BeanEJB");
            if (this.getA1() == null) {
                TestUtil.logMsg((String)"BeanEJB relationship updated corrently ");
                return true;
            }
            TestUtil.logMsg((String)"BeanEJB relationship not updated corrently ");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean test3() {
        TestUtil.logMsg((String)"starting test3");
        ALocal aOne = null;
        BLocal bOne = null;
        BLocal bTwo = null;
        boolean pass = true;
        try {
            aOne = this.getA1();
            bOne = this.getB1();
            bTwo = this.getB2();
            TestUtil.logMsg((String)("aOne = " + aOne));
            TestUtil.logMsg((String)("bOne = " + bOne));
            TestUtil.logMsg((String)("bTwo = " + bTwo));
            TestUtil.logMsg((String)"Delete entitybean object A1");
            aOne.remove();
            TestUtil.logMsg((String)"Assigning aOne to BeanEJB must throw IllegalArgumentException");
            this.setA1(aOne);
            TestUtil.logErr((String)"Did not get expected IllegalArgumentException");
            pass = false;
        }
        catch (IllegalArgumentException e) {
            TestUtil.logMsg((String)"Caught expected IllegalArgumentException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e), (Throwable)e);
            pass = false;
        }
        return pass;
    }

    private ALocal createALocal(String id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createALocal");
        this.nctx = new TSNamingContext();
        ALocalHome aLocalHome = (ALocalHome)this.nctx.lookup(ALocal);
        ALocal aLocal = aLocalHome.create(id, name, value);
        return aLocal;
    }

    private BLocal createBLocal(String id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createBLocal");
        this.nctx = new TSNamingContext();
        BLocalHome bLocalHome = (BLocalHome)this.nctx.lookup(BLocal);
        BLocal bLocal = bLocalHome.create(id, name, value);
        return bLocal;
    }

    public String ejbCreate(String id, String name, int value, ADVC a, BDVC b, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            this.setName(name);
            this.setValue(value);
            this.setId(id);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, String name, int value, ADVC a, BDVC b, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            ALocal a1 = null;
            BLocal b1 = null;
            switch (flag) {
                case 0: {
                    a1 = this.createALocal(a.getId(), a.getName(), a.getValue());
                    b1 = this.createBLocal(b.getId(), b.getName(), b.getValue());
                    break;
                }
                case 1: {
                    a1 = this.createALocal(a.getId(), a.getName(), a.getValue());
                    b1 = this.createBLocal(b.getId(), b.getName(), b.getValue());
                    b1.setA(null);
                    break;
                }
                case 2: {
                    a1 = this.createALocal(a.getId(), a.getName(), a.getValue());
                    b1 = this.createBLocal(b.getId(), b.getName(), b.getValue());
                    b1.setA(a1);
                }
            }
            this.setA1(a1);
            this.setB1(b1);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public String ejbCreate(String id, String name, int value, ADVC aOne, BDVC bOne, BDVC bTwo, ADVC aTwo, BDVC bThree, BDVC bFour) throws CreateException {
        TestUtil.logTrace((String)"ejbCreateWith");
        try {
            this.setId(id);
            this.setName(name);
            this.setValue(value);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, String name, int value, ADVC aOne, BDVC bOne, BDVC bTwo, ADVC aTwo, BDVC bThree, BDVC bFour) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            ALocal a1 = this.createALocal(aOne.getId(), aOne.getName(), aOne.getValue());
            BLocal b1 = this.createBLocal(bOne.getId(), bOne.getName(), bOne.getValue());
            b1.setA(a1);
            BLocal b2 = this.createBLocal(bTwo.getId(), bTwo.getName(), bTwo.getValue());
            b2.setA(a1);
            this.setA1(a1);
            this.setB1(b1);
            this.setB2(b2);
            if (aTwo == null) {
                return;
            }
            ALocal a2 = this.createALocal(aTwo.getId(), aTwo.getName(), aTwo.getValue());
            BLocal b3 = this.createBLocal(bThree.getId(), bThree.getName(), bThree.getValue());
            b3.setA(a2);
            BLocal b4 = this.createBLocal(bFour.getId(), bFour.getName(), bFour.getValue());
            b4.setA(a2);
            this.setA2(a2);
            this.setB3(b3);
            this.setB4(b4);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.context = c;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("NamingException ... " + e), (Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception ... " + e), (Throwable)e);
            throw new EJBException("Exception occurred: " + e);
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        if (this.getA1() != null) {
            TestUtil.logMsg((String)"deleting entity object a1 ...");
            this.getA1().remove();
        }
        if (this.getA2() != null) {
            TestUtil.logMsg((String)"deleting entity object a2 ...");
            this.getA2().remove();
        }
        if (this.getB1() != null) {
            TestUtil.logMsg((String)"deleting entity object b1 ...");
            this.getB1().remove();
        }
        if (this.getB2() != null) {
            TestUtil.logMsg((String)"deleting entity object b2 ...");
            this.getB2().remove();
        }
        if (this.getB3() != null) {
            TestUtil.logMsg((String)"deleting entity object b3 ...");
            this.getB3().remove();
        }
        if (this.getB4() != null) {
            TestUtil.logMsg((String)"deleting entity object b4 ...");
            this.getB4().remove();
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }
}

