/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.connManager;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class connManagerClient1
extends ServiceEETest
implements Serializable {
    private TSNamingContext nctx = null;
    private TSConnection con = null;
    private String whitebox_tx = null;
    private String whitebox_notx = null;
    private String whitebox_xa = null;
    private String whitebox_anno = null;
    private String whitebox_multianno = null;
    private TSDataSource dsource = null;
    private boolean flag = false;
    private DBSupport dbutil = null;

    public static void main(String[] args) {
        connManagerClient1 theTests = new connManagerClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.whitebox_tx = p.getProperty("whitebox-tx");
        this.whitebox_notx = p.getProperty("whitebox-notx");
        this.whitebox_xa = p.getProperty("whitebox-xa");
        this.whitebox_anno = p.getProperty("whitebox-anno_no_md");
        this.whitebox_multianno = p.getProperty("whitebox-multianno");
        this.logMsg("Using: " + this.whitebox_tx);
        try {
            this.dbutil = new DBSupport();
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception constructing DBSupport object: " + e.getMessage(), e);
        }
        try {
            this.nctx = new TSNamingContext();
            this.dsource = (TSDataSource)this.nctx.lookup(this.whitebox_tx);
            TestUtil.logMsg((String)("dsource JNDI lookup: " + this.dsource));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Exception during JNDI lookup: " + e.getMessage()));
        }
    }

    public void testcheckConnectionManager() throws EETest.Fault {
        try {
            this.flag = this.dsource.checkConnectionManager();
            if (!this.flag) {
                throw new EETest.Fault("Connection Manager is NOT Serializable");
            }
            TestUtil.logMsg((String)"Connection Manager is Serializable");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
    }

    public void testTransactionSupportLevels() throws EETest.Fault {
        TSDataSource dsource1 = null;
        TSDataSource dsource2 = null;
        TSDataSource dsource3 = null;
        TSDataSource dsource4 = null;
        TSDataSource dsource5 = null;
        TSConnection con1 = null;
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        try {
            this.nctx = new TSNamingContext();
            dsource1 = (TSDataSource)this.nctx.lookup(this.whitebox_tx);
            dsource2 = (TSDataSource)this.nctx.lookup(this.whitebox_notx);
            dsource3 = (TSDataSource)this.nctx.lookup(this.whitebox_xa);
            dsource4 = (TSDataSource)this.nctx.lookup(this.whitebox_anno);
            dsource5 = (TSDataSource)this.nctx.lookup(this.whitebox_multianno);
            dsource4.setLogFlag(true);
            con1 = dsource4.getConnection();
            log = dsource4.getStateLog();
            String toCheck1 = "anno based NestedWorkXid1 child context submitted";
            String toCheck2 = "anno based NestedWorkXid1 parent context submitted";
            TestUtil.logTrace((String)log.toString());
            for (int i = 0; i < log.size(); ++i) {
                String str = (String)log.elementAt(i);
                if (str.startsWith(toCheck1)) {
                    b1 = true;
                }
                if (!str.startsWith(toCheck2)) continue;
                b2 = true;
            }
            if (!b1 || !b2) {
                throw new EETest.Fault("Transactional support levels not processed correctly.");
            }
            TestUtil.logMsg((String)"Methods called correctly");
            TestUtil.logMsg((String)"Performing end to end verification...");
            try {
                this.dbutil.insertIntoTable(con1);
                TestUtil.logMsg((String)"Values inserted into table!");
            }
            catch (Exception sqle) {
                TestUtil.logMsg((String)"Exception inserting into table.");
                throw new EETest.Fault(sqle.getMessage(), sqle);
            }
            try {
                this.dbutil.dropTable(con1);
                TestUtil.logMsg((String)"Table has been dropped!");
            }
            catch (Exception sqle) {
                TestUtil.logMsg((String)"Exception dropping table.");
                throw new EETest.Fault(sqle.getMessage(), sqle);
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"Failed testTransactionSupportLevels()");
            throw new EETest.Fault(e.getMessage(), e);
        }
        finally {
            try {
                if (con1 != null) {
                    con1.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"Cleanup");
        try {
            this.flag = false;
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception on cleanup: " + e.getMessage()), (Throwable)e);
        }
    }
}

