/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.ee.packaging.ejb.exclude;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.ee.packaging.ejb.exclude.A;
import com.sun.ts.tests.jpa.ee.packaging.ejb.exclude.B;
import com.sun.ts.tests.jpa.ee.packaging.ejb.exclude.Stateful3IF;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.Remote;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Properties;

@Stateful(name="Stateful3Bean")
@Remote(value={Stateful3IF.class})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class Stateful3Bean
implements Stateful3IF {
    @PersistenceContext(unitName="CTS-EJB-EXCLUDE")
    private EntityManager entityManager;
    private static final B[] bRef = new B[5];
    public SessionContext sessionContext;

    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void createTestData() {
        try {
            TestUtil.logTrace((String)"createTestData - create 5 B Instances");
            Stateful3Bean.bRef[0] = new B("11", "myB", 1);
            Stateful3Bean.bRef[1] = new B("12", "yourB", 2);
            Stateful3Bean.bRef[2] = new B("13", "herB", 3);
            Stateful3Bean.bRef[3] = new B("14", "hisB", 4);
            Stateful3Bean.bRef[4] = new B("15", "ourB", 5);
            TestUtil.logTrace((String)"Start to persist Bees ");
            for (B b : bRef) {
                if (b == null) continue;
                this.entityManager.persist((Object)b);
                TestUtil.logTrace((String)("persisted B " + b));
            }
            this.entityManager.flush();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected while creating test data:" + e));
        }
    }

    @Override
    public void removeTestData() {
        TestUtil.logTrace((String)"stateful3Bean removeTestData");
        try {
            this.entityManager.createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.entityManager.createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.entityManager.flush();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught while cleaning up:", (Throwable)e);
        }
        TestUtil.logTrace((String)"Clearing cache");
        this.entityManager.getEntityManagerFactory().getCache().evictAll();
        TestUtil.logTrace((String)"cleanup complete");
    }

    @Override
    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    @Override
    public boolean test1() {
        TestUtil.logTrace((String)"Begin test1");
        boolean pass = false;
        try {
            this.createTestData();
            TestUtil.logTrace((String)"try to find Entity B now that it has been create and persisted.");
            B newB = (B)this.entityManager.find(B.class, (Object)"15");
            if (newB != null) {
                TestUtil.logTrace((String)"found B entity as expected");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception :", (Throwable)e);
            pass = false;
        }
        return pass;
    }

    @Override
    public boolean test2() {
        TestUtil.logTrace((String)"Begin test2");
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"test2:  newA");
            A newA = new A("100", "nonexistent", 5);
            TestUtil.logTrace((String)"test2:  try to Persist Entity A");
            this.entityManager.persist((Object)newA);
            TestUtil.logTrace((String)"test2:  Did not get expected Exception");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected, A is not an Entity");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught in test2:", (Throwable)e);
            pass = false;
        }
        return pass;
    }
}

