/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.bmp.multiclienttest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.multiclienttest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.multiclienttest.TestBeanHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final int SLEEPTIME = 5000;
    private static final String testName = "MultiClientTest";
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private static final String testProps = "multiclienttest.properties";
    private static Properties props = null;
    private static TSNamingContext nctx = null;
    private TestBeanHome beanHome = null;
    private TestBean beanRef = null;
    private Integer pkey = null;
    private boolean newTable = true;
    private static final int NUMEJBS = 2;
    private static final int NUMLOOPS = 5;
    private static final int NTHREADS = 2;
    private static final int NTHREADS2 = 4;
    private static Object lock = new Object();
    private static Object startLock = new Object();
    private static Object workLock = new Object();
    private static int threadsDone = 0;
    private static int errors = 0;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        props = p;
        try {
            this.logMsg("Obtain naming context");
            nctx = new TSNamingContext();
            this.logTrace("Client: Initializing BMP table...");
            DAOFactory.getInstance().getCoffeeDAO().cleanup();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)nctx.lookup(testBean, TestBeanHome.class);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test1() throws EETest.Fault {
        try {
            Thread[] threads = new Thread[2];
            threadsDone = 0;
            errors = 0;
            this.pkey = new Integer(1);
            this.logMsg("Create entity EJB with Primary Key = " + this.pkey.toString());
            this.beanRef = this.beanHome.create(props, this.newTable, this.pkey, "coffee-1", 1.0f);
            this.logMsg("Multiple Clients accessing the same entity EJB");
            this.logMsg("Synchronize calling of entity EJB methods");
            this.logMsg("Creating 2 client threads ...");
            for (int i = 0; i < 2; ++i) {
                threads[i] = new Thread((Runnable)new TestThread(i, 1), "TestThread-" + i);
                threads[i].start();
            }
            this.logMsg("Wait for thread creation ...");
            Object i = lock;
            synchronized (i) {
                while (threadsDone < threads.length) {
                    lock.wait();
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.logMsg("Notify all threads to start ...");
            i = startLock;
            synchronized (i) {
                threadsDone = 0;
                startLock.notifyAll();
            }
            this.logMsg("Wait for all threads to finish ...");
            i = lock;
            synchronized (i) {
                while (threadsDone < threads.length) {
                    lock.wait();
                }
            }
            float initialPrice = 1.0f;
            float finalPrice = this.beanRef.getPrice();
            this.logMsg("Entity EJB initialPrice = " + initialPrice + ", Entity EJB finalPrice = " + finalPrice + " ...");
            if (errors > 0) {
                this.logErr("The number of errors were: " + errors);
                throw new EETest.Fault("test1 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test2() throws EETest.Fault {
        try {
            Thread[] threads = new Thread[2];
            threadsDone = 0;
            errors = 0;
            this.pkey = new Integer(1);
            this.logMsg("Create entity EJB with Primary Key = " + this.pkey.toString());
            this.beanRef = this.beanHome.create(props, this.newTable, this.pkey, "coffee-1", 1.0f);
            this.logMsg("Multiple Clients accessing the same entity EJB");
            this.logMsg("Unsynchronize calling of entity EJB methods");
            this.logMsg("Creating 2 client threads ...");
            for (int i = 0; i < 2; ++i) {
                threads[i] = new Thread((Runnable)new TestThread(i, 2), "TestThread-" + i);
                threads[i].start();
            }
            this.logMsg("Wait for thread creation ...");
            Object i = lock;
            synchronized (i) {
                while (threadsDone < threads.length) {
                    lock.wait();
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.logMsg("Notify all threads to start ...");
            i = startLock;
            synchronized (i) {
                threadsDone = 0;
                startLock.notifyAll();
            }
            this.logMsg("Wait for all threads to finish ...");
            i = lock;
            synchronized (i) {
                while (threadsDone < threads.length) {
                    lock.wait();
                }
            }
            float initialPrice = 1.0f;
            float finalPrice = this.beanRef.getPrice();
            this.logMsg("Entity EJB initialPrice = " + initialPrice + ", Entity EJB finalPrice = " + finalPrice + " ...");
            if (errors > 0) {
                this.logErr("The number of errors were: " + errors);
                throw new EETest.Fault("test2 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test2 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test3() throws EETest.Fault {
        TestBean[] beanRef = new TestBean[2];
        try {
            Thread[] threads = new Thread[4];
            threadsDone = 0;
            errors = 0;
            this.logMsg("Multiple Clients accessing different entity EJB's");
            this.logMsg("Unsynchronize calling of entity EJB's methods");
            this.logMsg("Create 2 entity EJB's");
            int i = 0;
            int j = 1;
            while (i < 2) {
                this.logMsg("Creating entity EJB #" + j + " with Primary Key = " + j);
                beanRef[i] = i == 0 ? this.beanHome.create(props, this.newTable, j, "coffee-" + j, j) : this.beanHome.create(props, !this.newTable, j, "coffee-" + j, j);
                ++i;
                ++j;
            }
            this.logMsg("Creating 4 client threads ...");
            i = 0;
            j = 1;
            while (i < 4) {
                threads[i] = new Thread((Runnable)new TestThread(j, 3), "TestThread-" + j);
                threads[i].start();
                ++i;
                ++j;
            }
            this.logMsg("Wait for thread creation ...");
            Object i2 = lock;
            synchronized (i2) {
                while (threadsDone < threads.length) {
                    lock.wait();
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception j2) {
                    // empty catch block
                }
            }
            this.logMsg("Notify all threads to start ...");
            i2 = startLock;
            synchronized (i2) {
                threadsDone = 0;
                startLock.notifyAll();
            }
            this.logMsg("Wait for all threads to finish ...");
            i2 = lock;
            synchronized (i2) {
                while (threadsDone < threads.length) {
                    lock.wait();
                }
            }
            float initialPrice1 = 1.0f;
            float initialPrice2 = 2.0f;
            float finalPrice1 = beanRef[0].getPrice();
            float finalPrice2 = beanRef[1].getPrice();
            this.logMsg("Entity EJB #1 initialPrice = " + initialPrice1 + ", Entity EJB #1 finalPrice = " + finalPrice1 + " ...");
            this.logMsg("Entity EJB #2 initialPrice = " + initialPrice2 + ", Entity EJB #2 finalPrice = " + finalPrice2 + " ...");
            if (errors > 0) {
                this.logErr("The number of errors were: " + errors);
                throw new EETest.Fault("test3 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 2; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    class TestThread
    implements Runnable {
        private int threadNum;
        private int testNum;
        private boolean synchronize = true;

        public TestThread(int n, int t) {
            this.threadNum = n;
            this.testNum = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = lock;
            synchronized (object) {
                ++threadsDone;
                lock.notifyAll();
            }
            object = startLock;
            synchronized (object) {
                try {
                    startLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            boolean pass = true;
            if (this.testNum == 1) {
                pass = this.runTest1();
            } else if (this.testNum == 2) {
                pass = this.runTest2();
            } else if (this.testNum == 3) {
                pass = this.runTest3();
            }
            Object object2 = lock;
            synchronized (object2) {
                if (!pass) {
                    ++errors;
                }
                ++threadsDone;
                lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean runTest1() {
            boolean pass = true;
            Client.this.logMsg("Entering runTest1 Method .....");
            try {
                Client.this.logMsg("Find entity EJB with Primary Key = " + Client.this.pkey.toString());
                TestBean beanRef = Client.this.beanHome.findTheBean(props, Client.this.pkey);
                Client.this.logMsg("Initialize remote logging");
                beanRef.initLogging(props);
                Client.this.logMsg("Synchronize calling of entity EJB methods");
                Client.this.logMsg("Calling entity EJB methods getPrice()/updatePrice()");
                for (int i = 0; i < 5; ++i) {
                    Object object = workLock;
                    synchronized (object) {
                        float currentPrice = beanRef.getPrice();
                        beanRef.updatePrice(currentPrice + (float)this.threadNum + 1.0f);
                        float updatePrice = beanRef.getPrice();
                        Client.this.logMsg("Entity EJB currentPrice = " + currentPrice + ", updatePrice = " + updatePrice + ", threadNum = " + this.threadNum);
                        continue;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Client.this.logMsg("Leaving runTest1 Method .....");
            return pass;
        }

        public boolean runTest2() {
            boolean pass = true;
            Client.this.logMsg("Entering runTest2 Method .....");
            try {
                Client.this.logMsg("Find entity EJB with Primary Key = " + Client.this.pkey.toString());
                TestBean beanRef = Client.this.beanHome.findTheBean(props, Client.this.pkey);
                Client.this.logMsg("Initialize remote logging");
                beanRef.initLogging(props);
                Client.this.logMsg("Unsynchronize calling of Entity EJB methods");
                Client.this.logMsg("Calling entity EJB methods getPrice()/updatePrice()");
                for (int i = 0; i < 5; ++i) {
                    float currentPrice = beanRef.getPrice();
                    beanRef.updatePrice(currentPrice + 1.0f);
                    float updatePrice = beanRef.getPrice();
                    Client.this.logMsg("Entity EJB currentPrice = " + currentPrice + ", updatePrice = " + updatePrice + ", threadNum = " + this.threadNum);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Client.this.logMsg("Leaving runTest2 Method .....");
            return pass;
        }

        public boolean runTest3() {
            boolean pass = true;
            Integer pkey = null;
            Client.this.logMsg("Entering runTest3 Method .....");
            try {
                if (this.threadNum == 1 || this.threadNum == 2) {
                    pkey = new Integer(1);
                } else if (this.threadNum == 3 || this.threadNum == 4) {
                    pkey = new Integer(2);
                }
                Client.this.logMsg("Find entity EJB with Primary Key = " + pkey.toString());
                TestBean beanRef = Client.this.beanHome.findTheBean(props, pkey);
                Client.this.logMsg("Initialize remote logging");
                beanRef.initLogging(props);
                Client.this.logMsg("Unsynchronize calling of Entity EJB methods");
                Client.this.logMsg("Calling entity EJB methods getPrice()/updatePrice()");
                for (int i = 0; i < 5; ++i) {
                    float currentPrice = beanRef.getPrice();
                    beanRef.updatePrice(currentPrice + 1.0f);
                    float updatePrice = beanRef.getPrice();
                    Client.this.logMsg("Entity EJB currentPrice = " + currentPrice + ", updatePrice = " + updatePrice + ", threadNum = " + this.threadNum);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Client.this.logMsg("Leaving runTest3 Method .....");
            return pass;
        }
    }
}

