/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum DebugType {
    ASN1("asn1"),
    CONNECT("connect"),
    EXCEPTION("exception"),
    LDAP("ldap"),
    LDIF("ldif"),
    MONITOR("monitor"),
    CODING_ERROR("coding-error"),
    OTHER("other");

    private final String name;

    private DebugType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static DebugType forName(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        if (lowerName.equals("asn1")) {
            return ASN1;
        }
        if (lowerName.equals("connect")) {
            return CONNECT;
        }
        if (lowerName.equals("exception")) {
            return EXCEPTION;
        }
        if (lowerName.equals("ldap")) {
            return LDAP;
        }
        if (lowerName.equals("ldif")) {
            return LDIF;
        }
        if (lowerName.equals("monitor")) {
            return MONITOR;
        }
        if (lowerName.equals("coding-error")) {
            return CODING_ERROR;
        }
        if (lowerName.equals("other")) {
            return OTHER;
        }
        return null;
    }

    public static String getTypeNameList() {
        StringBuilder buffer = new StringBuilder();
        DebugType[] types = DebugType.values();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(types[i].getName());
        }
        return buffer.toString();
    }

    public String toString() {
        return this.name;
    }
}

