/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DisconnectClientTask
extends Task {
    static final String DISCONNECT_CLIENT_TASK_CLASS = "com.unboundid.directory.server.tasks.DisconnectClientTask";
    private static final String ATTR_CONNECTION_ID = "ds-task-disconnect-connection-id";
    private static final String ATTR_DISCONNECT_MESSAGE = "ds-task-disconnect-message";
    private static final String ATTR_NOTIFY_CLIENT = "ds-task-disconnect-notify-client";
    private static final String OC_DISCONNECT_CLIENT_TASK = "ds-task-disconnect";
    private static final TaskProperty PROPERTY_CONNECTION_ID = new TaskProperty("ds-task-disconnect-connection-id", TaskMessages.INFO_DISPLAY_NAME_DISCONNECT_CONN_ID.get(), TaskMessages.INFO_DESCRIPTION_DISCONNECT_CONN_ID.get(), Long.class, true, false, false);
    private static final TaskProperty PROPERTY_DISCONNECT_MESSAGE = new TaskProperty("ds-task-disconnect-message", TaskMessages.INFO_DISPLAY_NAME_DISCONNECT_MESSAGE.get(), TaskMessages.INFO_DESCRIPTION_DISCONNECT_MESSAGE.get(), String.class, false, false, false);
    private static final TaskProperty PROPERTY_NOTIFY_CLIENT = new TaskProperty("ds-task-disconnect-notify-client", TaskMessages.INFO_DISPLAY_NAME_DISCONNECT_NOTIFY.get(), TaskMessages.INFO_DESCRIPTION_DISCONNECT_NOTIFY.get(), Boolean.class, false, false, false);
    private static final long serialVersionUID = 6870137048384152893L;
    private final boolean notifyClient;
    private final long connectionID;
    private final String disconnectMessage;

    public DisconnectClientTask() {
        this.notifyClient = false;
        this.connectionID = -1L;
        this.disconnectMessage = null;
    }

    public DisconnectClientTask(String taskID, long connectionID, String disconnectMessage, boolean notifyClient) {
        this(taskID, connectionID, disconnectMessage, notifyClient, null, null, null, null, null);
    }

    public DisconnectClientTask(String taskID, long connectionID, String disconnectMessage, boolean notifyClient, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        super(taskID, DISCONNECT_CLIENT_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
        this.connectionID = connectionID;
        this.disconnectMessage = disconnectMessage;
        this.notifyClient = notifyClient;
    }

    public DisconnectClientTask(Entry entry) throws TaskException {
        super(entry);
        String idStr = entry.getAttributeValue(ATTR_CONNECTION_ID);
        if (idStr == null) {
            throw new TaskException(TaskMessages.ERR_DISCONNECT_TASK_NO_CONN_ID.get(this.getTaskEntryDN()));
        }
        try {
            this.connectionID = Long.parseLong(idStr);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new TaskException(TaskMessages.ERR_DISCONNECT_TASK_CONN_ID_NOT_LONG.get(this.getTaskEntryDN(), idStr), e);
        }
        this.disconnectMessage = entry.getAttributeValue(ATTR_DISCONNECT_MESSAGE);
        this.notifyClient = DisconnectClientTask.parseBooleanValue(entry, ATTR_NOTIFY_CLIENT, false);
    }

    public DisconnectClientTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(DISCONNECT_CLIENT_TASK_CLASS, properties);
        boolean notify = false;
        Long connID = null;
        String msg = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_CONNECTION_ID)) {
                connID = DisconnectClientTask.parseLong(p, values, connID);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_DISCONNECT_MESSAGE)) {
                msg = DisconnectClientTask.parseString(p, values, msg);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_NOTIFY_CLIENT)) continue;
            notify = DisconnectClientTask.parseBoolean(p, values, notify);
        }
        if (connID == null) {
            throw new TaskException(TaskMessages.ERR_DISCONNECT_TASK_NO_CONN_ID.get(this.getTaskEntryDN()));
        }
        this.connectionID = connID;
        this.disconnectMessage = msg;
        this.notifyClient = notify;
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_DISCONNECT_CLIENT.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_DISCONNECT_CLIENT.get();
    }

    public long getConnectionID() {
        return this.connectionID;
    }

    public String getDisconnectMessage() {
        return this.disconnectMessage;
    }

    public boolean notifyClient() {
        return this.notifyClient;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Arrays.asList(OC_DISCONNECT_CLIENT_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(3);
        attrs.add(new Attribute(ATTR_CONNECTION_ID, String.valueOf(this.connectionID)));
        attrs.add(new Attribute(ATTR_NOTIFY_CLIENT, String.valueOf(this.notifyClient)));
        if (this.disconnectMessage != null) {
            attrs.add(new Attribute(ATTR_DISCONNECT_MESSAGE, this.disconnectMessage));
        }
        return attrs;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        List<TaskProperty> propList = Arrays.asList(PROPERTY_CONNECTION_ID, PROPERTY_DISCONNECT_MESSAGE, PROPERTY_NOTIFY_CLIENT);
        return Collections.unmodifiableList(propList);
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>();
        props.put(PROPERTY_CONNECTION_ID, Collections.unmodifiableList(Arrays.asList(this.connectionID)));
        if (this.disconnectMessage == null) {
            props.put(PROPERTY_DISCONNECT_MESSAGE, Collections.emptyList());
        } else {
            props.put(PROPERTY_DISCONNECT_MESSAGE, Collections.unmodifiableList(Arrays.asList(this.disconnectMessage)));
        }
        props.put(PROPERTY_NOTIFY_CLIENT, Collections.unmodifiableList(Arrays.asList(this.notifyClient)));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

