/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.deploy.entity.bmp.single;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.ejb.ee.deploy.entity.bmp.single.Single;
import com.sun.ts.tests.ejb.ee.deploy.entity.bmp.single.SingleHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final String testLookup = "java:comp/env/ejb/TestBean";
    private static final String testName = "com.sun.ts.tests.ejb.ee.deploy.entity.bmp.single.Single";
    private static final String refIdString = "Entity Single Remote";
    private TSNamingContext nctx = null;
    private SingleHome home = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        try {
            this.props = props;
            this.logMsg("[Client] Getting TS Naming Context...");
            this.nctx = new TSNamingContext();
            this.logMsg("[Client] Initializing DB table...");
            DAOFactory.getInstance().getCoffeeDAO().cleanup();
            this.logMsg("Looking up up java:comp/env/ejb/TestBean...");
            this.home = (SingleHome)this.nctx.lookup(testLookup, SingleHome.class);
            this.logMsg("Setup OK!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void testIsSession() throws EETest.Fault {
        try {
            if (this.home.getEJBMetaData().isSession()) {
                throw new EETest.Fault("isSession() test failed [is true]");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("isSession() test failed: " + e, e);
        }
    }

    public void testIsStateless() throws EETest.Fault {
        try {
            boolean pass;
            boolean bl = pass = !this.home.getEJBMetaData().isStatelessSession();
            if (!pass) {
                this.logErr("[Client] isStatelessSession() reported '" + pass + "'");
                throw new EETest.Fault("isStatelessSession() test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("isStatelessSession() test failed: " + e, e);
        }
    }

    public void testGetPrimaryKey() throws EETest.Fault {
        Single bean = null;
        try {
            TestUtil.logTrace((String)"[Client] Creating bean...");
            bean = this.home.create(this.props, 1, "coffee-1", 1.0f);
            TestUtil.logTrace((String)"[Client] Getting primary key...");
            Object pkey = bean.getPrimaryKey();
        }
        catch (Exception e) {
            throw new EETest.Fault("getPrimaryKey() test failed: " + e, e);
        }
        finally {
            try {
                if (null != bean) {
                    bean.remove();
                }
            }
            catch (Exception e) {
                TestUtil.logTrace((String)("[Client] Ignoring exception on bean remove: " + e));
            }
        }
    }

    public void testHomeInterface() throws EETest.Fault {
        Class runtimeHome = null;
        boolean pass = false;
        try {
            runtimeHome = this.home.getEJBMetaData().getHomeInterfaceClass();
            pass = runtimeHome.getName().equals("com.sun.ts.tests.ejb.ee.deploy.entity.bmp.single.SingleHome");
            if (!pass) {
                throw new EETest.Fault("getHomeInterface() test failed ");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("getHomeInterface() test failed: " + e, e);
        }
    }

    public void testRemoteInterface() throws EETest.Fault {
        Class runtimeRemote = null;
        boolean pass = false;
        try {
            runtimeRemote = this.home.getEJBMetaData().getRemoteInterfaceClass();
            pass = runtimeRemote.getName().equals(testName);
            if (!pass) {
                throw new EETest.Fault("getRemoteInterface() test failed ");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("getRemoteInterface() test failed: " + e, e);
        }
    }

    public void testCreate() throws EETest.Fault {
        Single bean = null;
        try {
            bean = this.home.create(this.props, 1, "coffee-1", 1.0f);
            bean.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("Test create failed: ", e);
        }
    }

    public void testBusinessMethod() throws EETest.Fault {
        Single bean = null;
        try {
            bean = this.home.create(this.props, 1, "coffee-1", 1.0f);
            String id = bean.getIdString();
            this.logTrace("[Client] got Identification string '" + id + "'");
            boolean pass = id.equals(refIdString);
            bean.remove();
            if (!pass) {
                this.logErr("[Client] home interface mismatch!");
                throw new EETest.Fault("Remote interface test failed, expected 'Entity Single Remote'");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Remote interface test failed: " + e, e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("[Client] cleanup()");
    }
}

