/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.session.stateless.callback.listener.annotated;

import com.sun.ts.tests.ejb30.bb.session.stateless.callback.listener.annotated.CallbackBean;
import com.sun.ts.tests.ejb30.common.callback.InterceptorHelper;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;

public class StatelessCallbackListener {
    @PostConstruct
    private void myCreate(InvocationContext inv) throws RuntimeException {
        CallbackBean bean = (CallbackBean)inv.getTarget();
        bean.setPostConstructCalled(true);
        TLogger.log("PostConstruct method in " + this + " called for bean " + bean);
        InterceptorHelper.recordExceptionFromGetParameters(inv, bean, false);
        InterceptorHelper.recordExceptionFromSetParameters(inv, bean, false);
        if (bean.getEJBContext() != null) {
            bean.setInjectionDone(true);
        }
        try {
            inv.proceed();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @PreDestroy
    private void myRemove(InvocationContext inv) throws RuntimeException {
        Object bean = inv.getTarget();
        if (bean instanceof CallbackBean) {
            CallbackBean b = (CallbackBean)bean;
            b.setPreDestroyCalled(true);
            TLogger.log("PreDestroy method in " + this + " called for bean " + b);
            InterceptorHelper.recordExceptionFromGetParameters(inv, b, true);
            InterceptorHelper.recordExceptionFromSetParameters(inv, b, true);
        }
        try {
            inv.proceed();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @AroundInvoke
    private Object intercept(InvocationContext inv) throws Exception {
        return inv.proceed();
    }
}

