/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.StoredProcedureQuery;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.StoredProcedureQuery.Employee;
import com.sun.ts.tests.jpa.core.StoredProcedureQuery.Employee2;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TransactionRequiredException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    List<Employee> empRef = new ArrayList<Employee>();
    List<Employee2> empRef2 = new ArrayList<Employee2>();
    Employee emp0 = null;
    Employee2 emp2 = null;
    final Date utilDate = this.getUtilDate("2000-02-14");
    final Calendar calDate = this.getCalDate(2000, 2, 14);
    String dataBaseName = null;
    static final String ORACLE = "oracle";
    static final String POSTGRESQL = "postgresql";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createEmployeeTestData();
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupEmployee2Data(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createEmployee2TestData();
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public List<List> getResultSetsFromStoredProcedure(StoredProcedureQuery spq) {
        TestUtil.logTrace((String)"in getResultSetsFromStoredProcedure");
        boolean results = true;
        ArrayList<List> listOfList = new ArrayList<List>();
        int rsnum = 1;
        int rowsAffected = 0;
        do {
            if (results) {
                TestUtil.logTrace((String)("Processing set:" + rsnum));
                ArrayList<Employee> empList = new ArrayList<Employee>();
                List list = spq.getResultList();
                if (list != null) {
                    TestUtil.logTrace((String)("Getting result set: " + rsnum + ", size:" + list.size()));
                    for (Object o : list) {
                        if (o instanceof Employee) {
                            Employee e = (Employee)o;
                            TestUtil.logTrace((String)("Saving:" + e));
                            empList.add(e);
                            continue;
                        }
                        TestUtil.logErr((String)("Did not get instance of Employee, instead got:" + o.getClass().getSimpleName()));
                    }
                    if (empList.size() > 0) {
                        listOfList.add(empList);
                    }
                } else {
                    TestUtil.logErr((String)("Result set[" + rsnum + "] returned was null"));
                }
                ++rsnum;
            } else {
                rowsAffected = spq.getUpdateCount();
                if (rowsAffected >= 0) {
                    TestUtil.logTrace((String)("rowsAffected:" + rowsAffected));
                }
            }
            results = spq.hasMoreResults();
            TestUtil.logTrace((String)("Results:" + results));
        } while (results || rowsAffected != -1);
        return listOfList;
    }

    public boolean verifyEmployeeIds(List<Integer> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee employee : lEmp) {
                    actual.add(employee.getId());
                }
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    TestUtil.logTrace((String)"Received expected result:");
                    for (Integer n : actual) {
                        TestUtil.logTrace((String)("id:" + n));
                    }
                    ++count;
                    continue;
                }
                TestUtil.logErr((String)"Did not receive expected result:");
                for (Integer n : expected) {
                    TestUtil.logErr((String)(" Expected id:" + n));
                }
                for (Integer n : actual) {
                    TestUtil.logErr((String)("Actual id:" + n));
                }
                continue;
            }
            TestUtil.logErr((String)"Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListOfListEmployees(List<Employee> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Employee> actual = new ArrayList<Employee>();
                for (Employee e : lEmp) {
                    actual.add(e);
                }
                if (!this.verifyListEmployees(expected, actual)) continue;
                ++count;
                continue;
            }
            TestUtil.logErr((String)"Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListEmployees(List<Employee> expected, List<Employee> actual) {
        boolean result = false;
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            for (Employee e : expected) {
                TestUtil.logTrace((String)("Received expected result:" + e));
            }
            result = true;
        } else {
            TestUtil.logErr((String)"Did not receive expected result:");
            for (Employee e : expected) {
                TestUtil.logErr((String)("expected employee:" + e));
            }
            for (Employee e : actual) {
                TestUtil.logErr((String)("actual employee :" + e));
            }
        }
        return result;
    }

    public void executeTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            ArrayList<Integer> expected;
            List<List> listOfList;
            StoredProcedureQuery spq;
            this.getEntityTransaction().begin();
            try {
                TestUtil.logMsg((String)"Testing using name,class");
                this.clearCache();
                spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
                if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                    TestUtil.logTrace((String)"register refcursor parameter");
                    spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
                }
                TestUtil.logTrace((String)("executing:" + spq.toString()));
                if (spq.execute()) {
                    listOfList = this.getResultSetsFromStoredProcedure(spq);
                    if (listOfList.size() == 1) {
                        expected = new ArrayList<Integer>();
                        for (Employee e : this.empRef) {
                            expected.add(e.getId());
                        }
                        pass1 = this.verifyEmployeeIds(expected, listOfList);
                    } else {
                        TestUtil.logErr((String)("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size()));
                    }
                } else {
                    TestUtil.logErr((String)"Expected execute() to return true, actual: false");
                }
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
            }
            try {
                TestUtil.logMsg((String)"Testing using name,result mapping");
                this.clearCache();
                spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"id-firstname-lastname"});
                spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                    TestUtil.logTrace((String)"register refcursor parameter");
                    spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
                }
                spq.setParameter(1, (Object)1);
                if (spq.execute()) {
                    listOfList = this.getResultSetsFromStoredProcedure(spq);
                    if (listOfList.size() == 1) {
                        expected = new ArrayList();
                        expected.add((Integer)new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName()));
                        pass2 = this.verifyListOfListEmployees(expected, listOfList);
                    } else {
                        TestUtil.logErr((String)("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size()));
                    }
                } else {
                    TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                }
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
            }
            try {
                TestUtil.logMsg((String)"Testing using named stored procedure");
                this.clearCache();
                if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                    TestUtil.logTrace((String)"Calling refcursor specific named stored procedure query");
                    spq = this.getEntityManager().createNamedStoredProcedureQuery("get-id-firstname-lastname-refcursor");
                } else {
                    spq = this.getEntityManager().createNamedStoredProcedureQuery("get-id-firstname-lastname");
                }
                spq.setParameter(1, (Object)1);
                if (spq.execute()) {
                    listOfList = this.getResultSetsFromStoredProcedure(spq);
                    if (listOfList.size() == 1) {
                        expected = new ArrayList();
                        expected.add((Integer)new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName()));
                        pass3 = this.verifyListOfListEmployees(expected, listOfList);
                    } else {
                        TestUtil.logErr((String)("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size()));
                    }
                } else {
                    TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                }
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("executeTest failed");
        }
    }

    public void getOutputParameterValueIntTest() throws EETest.Fault {
        String actual;
        boolean pass2 = false;
        boolean pass4 = false;
        boolean pass6 = false;
        Object oActual = null;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Get the value from an OUT only parameter");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpOneFirstNameFromOut");
            spq3.registerStoredProcedureParameter(1, String.class, ParameterMode.OUT);
            if (!spq3.execute()) {
                oActual = spq3.getOutputParameterValue(1);
                if (oActual instanceof String) {
                    actual = (String)oActual;
                    if (actual.equals(this.emp0.getFirstName())) {
                        TestUtil.logTrace((String)("Received expected result:" + actual));
                        pass6 = true;
                    } else {
                        TestUtil.logErr((String)("Expected result: " + this.emp0.getFirstName() + ", actual:" + actual));
                    }
                } else {
                    TestUtil.logErr((String)("Did not get instance of String, instead:" + oActual));
                }
            } else {
                TestUtil.logErr((String)"Expected execute() to return false, actual: true");
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        try {
            TestUtil.logMsg((String)"Get the value from an IN and OUT parameter");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq1.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq1.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq1.setParameter(1, (Object)1);
            if (!spq1.execute()) {
                oActual = spq1.getOutputParameterValue(2);
                if (oActual instanceof String) {
                    actual = (String)oActual;
                    if (actual.equals(this.emp0.getFirstName())) {
                        TestUtil.logTrace((String)("Received expected result:" + actual));
                        pass2 = true;
                    } else {
                        TestUtil.logErr((String)("Expected result: " + this.emp0.getFirstName() + ", actual:" + actual));
                    }
                } else {
                    TestUtil.logErr((String)("Did not get instance of String, instead:" + oActual));
                }
            } else {
                TestUtil.logErr((String)"Expected execute() to return false, actual: true");
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        try {
            TestUtil.logMsg((String)"Get the value from an INOUT parameter");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq2.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq2.setParameter(1, (Object)"1");
            if (!spq2.execute()) {
                oActual = spq2.getOutputParameterValue(1);
                if (oActual instanceof String) {
                    actual = (String)oActual;
                    if (actual.equals(this.emp0.getLastName())) {
                        TestUtil.logTrace((String)("Received expected result:" + actual));
                        pass4 = true;
                    } else {
                        TestUtil.logErr((String)("Expected result: " + this.emp0.getLastName() + ", actual:" + actual));
                    }
                } else {
                    TestUtil.logErr((String)("Expected Integer to be returned, actual:" + oActual));
                }
            } else {
                TestUtil.logErr((String)"Expected execute() to return false, actual: true");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        if (!(pass2 && pass4 && pass6)) {
            throw new EETest.Fault("getOutputParameterValueIntTest failed");
        }
    }

    public void getOutputParameterValueIntIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass4;
        boolean pass2;
        block15: {
            pass2 = false;
            pass4 = false;
            try {
                block14: {
                    this.getEntityTransaction().begin();
                    TestUtil.logMsg((String)"Get a value that does not exist");
                    StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
                    spq1.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                    spq1.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
                    spq1.setParameter(1, (Object)1);
                    if (!spq1.execute()) {
                        try {
                            spq1.getOutputParameterValue(99);
                            TestUtil.logErr((String)"Did not throw IllegalArgumentException");
                        }
                        catch (IllegalArgumentException iae) {
                            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                            if (!this.getEntityTransaction().getRollbackOnly()) {
                                pass2 = true;
                                TestUtil.logTrace((String)"Transaction was not marked for rollback");
                                break block14;
                            }
                            TestUtil.logErr((String)"Transaction was marked for rollback and should not have been");
                        }
                        catch (Exception e) {
                            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
                        }
                    } else {
                        TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                    }
                }
                TestUtil.logMsg((String)"Get the value from an IN parameter");
                StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
                spq2.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
                spq2.setParameter(1, (Object)"1");
                if (!spq2.execute()) {
                    try {
                        spq2.getOutputParameterValue(99);
                        TestUtil.logErr((String)"Did not throw IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                        pass4 = true;
                    }
                    catch (Exception e) {
                        TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
                    }
                    if (this.getEntityTransaction().isActive()) {
                        this.getEntityTransaction().rollback();
                    }
                    break block15;
                }
                TestUtil.logErr((String)"Expected execute() to return false, actual: true");
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
            }
        }
        if (!pass2 || !pass4) {
            throw new EETest.Fault("getOutputParameterValueIntIllegalArgumentExceptionTest failed");
        }
    }

    public void getFirstResultTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            int num;
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                TestUtil.logTrace((String)"register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            if ((num = spq.getFirstResult()) == 0) {
                TestUtil.logTrace((String)("Received expected first result when none is set:" + num));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected first result when none is set: 0, actual:" + num));
            }
            List actual = spq.getResultList();
            num = spq.getFirstResult();
            if (num == 0) {
                TestUtil.logTrace((String)("Received expected first result:" + num + " after getResultList"));
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Expected first result: 0, actual:" + num + " after getResultList"));
            }
            if (actual.size() > 0) {
                pass3 = this.verifyListEmployees(this.empRef, actual);
            } else {
                TestUtil.logErr((String)"getResultList() returned 0 results");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("getFirstResultTest failed");
        }
    }

    public void getMaxResultsTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            int num;
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                TestUtil.logTrace((String)"register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            if ((num = spq.getMaxResults()) == Integer.MAX_VALUE) {
                TestUtil.logTrace((String)("Received expected max result:" + num));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected max result: 2147483647, actual:" + num));
            }
            List actual = spq.getResultList();
            num = spq.getMaxResults();
            if (num == Integer.MAX_VALUE) {
                TestUtil.logTrace((String)("Received expected max result:" + num + " after getResultList"));
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Expected max result:2147483647, actual:" + num + " after getResultList"));
            }
            if (actual.size() > 0) {
                pass3 = this.verifyListEmployees(this.empRef, actual);
            } else {
                TestUtil.logErr((String)"getResultList() returned 0 results");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("getMaxResultsTest failed");
        }
    }

    public void getSingleResultTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"id-firstname-lastname"});
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                TestUtil.logTrace((String)"register refcursor parameter");
                spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            spq.setParameter(1, (Object)1);
            Employee expected = new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName());
            Object o = spq.getSingleResult();
            if (o instanceof Employee) {
                Employee actual = (Employee)o;
                if (actual.equals((Object)expected)) {
                    TestUtil.logTrace((String)("Received expected result:" + actual));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Expected result:" + expected + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)("Did not get Integer result:" + o));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        if (!pass) {
            throw new EETest.Fault("getSingleResultTest failed");
        }
    }

    public void getSingleResultNoResultExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                TestUtil.logTrace((String)"register refcursor parameter");
                spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            spq.setParameter(1, (Object)99);
            try {
                spq.getSingleResult();
                TestUtil.logErr((String)"Did not throw NoResultException");
            }
            catch (NoResultException nre) {
                TestUtil.logTrace((String)"Received expected NoResultException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        if (!pass) {
            throw new EETest.Fault("getSingleResultNoResultExceptionTest failed");
        }
    }

    public void getSingleResultNonUniqueResultExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                TestUtil.logTrace((String)"register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            try {
                spq.getSingleResult();
                TestUtil.logErr((String)"Did not throw NonUniqueResultException");
            }
            catch (NonUniqueResultException nure) {
                TestUtil.logTrace((String)"Received expected NonUniqueResultException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        if (!pass) {
            throw new EETest.Fault("getSingleResultNonUniqueResultExceptionTest failed");
        }
    }

    public void setgetFlushModeTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            FlushModeType fmt;
            TestUtil.logMsg((String)"Testing StoredProcedureQuery");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                TestUtil.logTrace((String)"register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            if ((fmt = spq.getFlushMode()) != null) {
                if (fmt.equals((Object)this.getEntityManager().getFlushMode())) {
                    TestUtil.logTrace((String)"Setting mode to returned default mode");
                    spq.setFlushMode(fmt);
                    TestUtil.logTrace((String)"Setting mode to FlushModeType.COMMIT");
                    spq.setFlushMode(FlushModeType.COMMIT);
                    fmt = spq.getFlushMode();
                    if (fmt.equals((Object)FlushModeType.COMMIT)) {
                        TestUtil.logTrace((String)"Setting mode to FlushModeType.AUTO");
                        spq.setFlushMode(FlushModeType.AUTO);
                        fmt = spq.getFlushMode();
                        if (fmt.equals((Object)FlushModeType.AUTO)) {
                            TestUtil.logTrace((String)"Query object returned from setFlushMode");
                            StoredProcedureQuery q = spq.setFlushMode(FlushModeType.COMMIT);
                            fmt = q.getFlushMode();
                            if (fmt.equals((Object)FlushModeType.COMMIT)) {
                                TestUtil.logTrace((String)("Received expected Query FlushModeType:" + fmt.name()));
                                pass1 = true;
                            } else {
                                TestUtil.logErr((String)("Expected a value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name()));
                            }
                        } else {
                            TestUtil.logErr((String)("Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name()));
                        }
                    } else {
                        TestUtil.logErr((String)("Expected a default value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name()));
                    }
                } else {
                    TestUtil.logErr((String)("Expected EntityManager value of:" + this.getEntityManager().getFlushMode() + ", actual:" + fmt.name()));
                }
            } else {
                TestUtil.logErr((String)"getFlushMode return null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing Query object returned from setFlushMode");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            TestUtil.logTrace((String)"Setting mode to FlushModeType.AUTO");
            StoredProcedureQuery q = spq2.setFlushMode(FlushModeType.AUTO);
            FlushModeType fmt = q.getFlushMode();
            if (fmt.equals((Object)FlushModeType.AUTO)) {
                TestUtil.logTrace((String)("Received expected value of:" + fmt.name()));
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setgetFlushModeTest failed");
        }
    }

    public void setLockModeIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("UpdateEmpSalaryColumn");
            try {
                spq.setLockMode(LockModeType.PESSIMISTIC_READ);
                TestUtil.logErr((String)"Did not throw IllegalStateException");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("setLockModeIllegalStateExceptionTest failed");
        }
    }

    public void getLockModeIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("UpdateEmpSalaryColumn");
            try {
                spq.getLockMode();
                TestUtil.logErr((String)"Did not throw IllegalStateException");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getLockModeIllegalStateExceptionTest failed");
        }
    }

    public void setGetParameterIntTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing StoredProcedureQuery");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            Parameter p = spq.getParameter(1);
            int pos = p.getPosition();
            if (pos == 1) {
                TestUtil.logTrace((String)("Received expected parameter:" + pos));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected position: 1, actual:" + pos));
            }
            TestUtil.logMsg((String)"Testing Query object returned from getParameter");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            StoredProcedureQuery q = spq2.setParameter(1, (Object)1);
            p = q.getParameter(1);
            pos = p.getPosition();
            if (pos == 1) {
                TestUtil.logTrace((String)("Received expected parameter:" + pos));
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Expected position: 1, actual:" + pos));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setGetParameterIntTest failed");
        }
    }

    public void getParameterStringExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing StoredProcedureQuery ");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter("ID", Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter("FIRSTNAME", String.class, ParameterMode.OUT);
            spq.setParameter("ID", (Object)1);
            try {
                spq.getParameter("DOESNOTEXIST");
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Received expected IllegalStateException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing Query object returned from getParameter");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter("ID", Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter("FIRSTNAME", String.class, ParameterMode.OUT);
            StoredProcedureQuery q = spq2.setParameter("ID", (Object)1);
            try {
                q.getParameter("DOESNOTEXIST");
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Received expected IllegalStateException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterStringExceptionTest failed");
        }
    }

    public void getParameterIntIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing StoredProcedureQuery ");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            try {
                spq.getParameter(99);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing Query object returned from getParameter");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            StoredProcedureQuery q = spq2.setParameter(1, (Object)1);
            try {
                q.getParameter(99);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterIntIllegalArgumentExceptionTest failed");
        }
    }

    public void setParameterParameterObjectTest() throws EETest.Fault {
        boolean pass4;
        boolean pass2;
        block18: {
            block17: {
                pass2 = false;
                pass4 = false;
                try {
                    this.getEntityTransaction().begin();
                    TestUtil.logMsg((String)"Testing StoredProcedureQuery ");
                    StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
                    spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                    spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
                    spq.setParameter(1, (Object)99);
                    Parameter p = spq.getParameter(1);
                    spq.setParameter(p, (Object)1);
                    if (!spq.execute()) {
                        Object oActual = spq.getOutputParameterValue(2);
                        if (oActual instanceof String) {
                            String actual = (String)oActual;
                            if (actual.equals(this.emp0.getFirstName())) {
                                TestUtil.logTrace((String)("Received expected result:" + actual));
                                pass2 = true;
                            } else {
                                TestUtil.logErr((String)("Expected result: " + this.emp0.getFirstName() + ", actual:" + actual));
                            }
                        } else {
                            TestUtil.logErr((String)("Did not get instance of String, instead:" + oActual.getClass()));
                        }
                    } else {
                        TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Caught exception", (Throwable)e);
                    if (!this.getEntityTransaction().isActive()) break block17;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                TestUtil.logMsg((String)"Testing Query object returned from setParameter");
                StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
                spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
                StoredProcedureQuery q = spq2;
                q.setParameter(1, (Object)99);
                Parameter p = q.getParameter(1);
                q.setParameter(p, (Object)1);
                StoredProcedureQuery spq3 = q;
                if (!spq3.execute()) {
                    Object oActual = spq3.getOutputParameterValue(2);
                    if (oActual instanceof String) {
                        String actual = (String)oActual;
                        if (actual.equals(this.emp0.getFirstName())) {
                            TestUtil.logTrace((String)("Received expected result:" + actual));
                            pass4 = true;
                        } else {
                            TestUtil.logErr((String)("Expected result: " + this.emp0.getFirstName() + ", actual:" + actual));
                        }
                    } else {
                        TestUtil.logErr((String)("Did not get instance of String, instead:" + oActual));
                    }
                } else {
                    TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught exception", (Throwable)e);
                if (!this.getEntityTransaction().isActive()) break block18;
                this.getEntityTransaction().rollback();
            }
        }
        if (!pass2 || !pass4) {
            throw new EETest.Fault("setParameterParameterObjectTest failed");
        }
    }

    public void setParameterParameterObjectIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Get parameter from other stored procedure");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq.setParameter(1, (Object)"INOUT");
            Parameter p = spq.getParameter(1);
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            try {
                spq2.setParameter(p, (Object)1);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception", (Throwable)e);
        }
        if (!pass1) {
            throw new EETest.Fault("setParameterParameterObjectIllegalArgumentExceptionTest failed");
        }
    }

    public void setParameterIntObjectIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing StoredProcedureQuery with incorrect position specified");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq1.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq1.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            try {
                spq1.setParameter(99, (Object)1);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing StoredProcedureQuery with incorrect type specified");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            try {
                spq2.setParameter(1, (Object)new Date());
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing Query object with incorrect position specified");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq3.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq3.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            StoredProcedureQuery q1 = spq3.setParameter(1, (Object)1);
            try {
                spq3.setParameter(99, (Object)1);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass3 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing Query object with incorrect type specified");
            StoredProcedureQuery spq4 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq4.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq4.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            StoredProcedureQuery q2 = spq4.setParameter(1, (Object)1);
            try {
                q2.setParameter(1, (Object)new Date());
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass4 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("setParameterIntObjectIllegalArgumentExceptionTest failed");
        }
    }

    public void getParametersTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            Set p1 = spq.getParameters();
            if (p1.size() == 0) {
                TestUtil.logTrace((String)("Received expected number of parameters when non exist:" + p1.size()));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected number of parameters when non exist: 0, actual:" + p1));
            }
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            if (!spq.execute()) {
                Set p2 = spq.getParameters();
                if (p2.size() == 2) {
                    TestUtil.logTrace((String)("Received expected number of parameters:" + p2.size()));
                    pass3 = true;
                } else {
                    TestUtil.logErr((String)("Expected number of parameters: 2, actual:" + p2.size()));
                }
            } else {
                TestUtil.logErr((String)"Expected execute() to return false, actual: true");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass3) {
            throw new EETest.Fault("getParametersTest failed");
        }
    }

    @SetupMethod(name="setupEmployee2Data")
    public void setParameterIntCalendarTemporalTypeTest() throws EETest.Fault {
        boolean pass2 = false;
        boolean pass4 = false;
        try {
            this.getEntityTransaction().begin();
            try {
                TestUtil.logMsg((String)"Testing StoredProcedureQuery object");
                StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
                spq.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                spq.setParameter(1, this.calDate, TemporalType.DATE);
                if (!spq.execute()) {
                    Object o = spq.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == this.emp2.getId()) {
                            TestUtil.logTrace((String)("Received expected id:" + actual));
                            pass2 = true;
                        } else {
                            TestUtil.logErr((String)("Expected id: " + this.emp2.getId() + ", actual:" + actual));
                        }
                    } else {
                        TestUtil.logErr((String)("Did not get instance of Integer back:" + o));
                    }
                } else {
                    TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
            }
            try {
                TestUtil.logMsg((String)"Testing Query object");
                StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq1.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
                spq1.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                StoredProcedureQuery q = spq1;
                q.setParameter(1, this.getCalDate(), TemporalType.DATE);
                StoredProcedureQuery spq2 = q;
                if (!spq2.execute()) {
                    Object o = spq2.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == 5) {
                            TestUtil.logTrace((String)("Received expected id:" + actual));
                            pass4 = true;
                        } else {
                            TestUtil.logErr((String)("Expected id: 5, actual:" + actual));
                        }
                    } else {
                        TestUtil.logErr((String)("Did not get instance of Integer back:" + o));
                    }
                } else {
                    TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass2 || !pass4) {
            throw new EETest.Fault("setParameterIntCalendarTemporalTypeTest failed");
        }
    }

    @SetupMethod(name="setupEmployee2Data")
    public void setParameterIntCalendarTemporalTypeIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing StoredProcedureQuery with incorrect position specified");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq1.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            try {
                spq1.setParameter(99, this.getCalDate(), TemporalType.DATE);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing Query object with incorrect position specified");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq3.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            StoredProcedureQuery q1 = spq3.setParameter(1, this.getCalDate(), TemporalType.DATE);
            try {
                q1.setParameter(99, (Object)this.getCalDate());
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterIntCalendarTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    public void setParameterIntDateTemporalTypeTest() throws EETest.Fault {
        boolean pass2 = false;
        boolean pass4 = false;
        try {
            this.getEntityTransaction().begin();
            try {
                TestUtil.logMsg((String)"Testing StoredProcedureQuery");
                StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
                spq.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                spq.setParameter(1, this.utilDate, TemporalType.DATE);
                if (!spq.execute()) {
                    Object o = spq.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        Integer actual = (Integer)o;
                        if (actual == 1) {
                            TestUtil.logTrace((String)("Received expected id:" + actual));
                            pass2 = true;
                        } else {
                            TestUtil.logErr((String)("Expected id: 1, actual:" + actual));
                        }
                    } else {
                        TestUtil.logErr((String)("Did not get instance of Integer back:" + o));
                    }
                } else {
                    TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
            }
            try {
                TestUtil.logMsg((String)"Testing Query object");
                StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq1.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
                spq1.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                StoredProcedureQuery q = spq1;
                q.setParameter(1, this.utilDate, TemporalType.DATE);
                StoredProcedureQuery spq2 = q;
                if (!spq2.execute()) {
                    Object o = spq2.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == 1) {
                            TestUtil.logTrace((String)("Received expected id:" + actual));
                            pass4 = true;
                        } else {
                            TestUtil.logErr((String)("Expected id: 1, actual:" + actual));
                        }
                    } else {
                        TestUtil.logErr((String)("Did not get instance of Integer back:" + o));
                    }
                } else {
                    TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass2 || !pass4) {
            throw new EETest.Fault("setParameterIntDateTemporalTypeTest failed");
        }
    }

    public void setParameterIntDateTemporalTypeIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing StoredProcedureQuery with incorrect position specified");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq1.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
            try {
                spq1.setParameter(99, this.utilDate, TemporalType.DATE);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing Query object with incorrect position specified");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq3.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
            StoredProcedureQuery q1 = spq3.setParameter(1, (Object)this.getUtilDate());
            try {
                q1.setParameter(99, this.utilDate, TemporalType.DATE);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterIntDateTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupEmployee2Data")
    public void setParameterParameterCalendarTemporalTypeTest() throws EETest.Fault {
        boolean pass5;
        boolean pass3;
        boolean pass2;
        block20: {
            block19: {
                pass2 = false;
                pass3 = false;
                pass5 = false;
                try {
                    TestUtil.logMsg((String)"Testing StoredProcedure");
                    this.getEntityTransaction().begin();
                    StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                    spq.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
                    spq.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                    spq.setParameter(1, this.getCalDate(), TemporalType.DATE);
                    Parameter p = spq.getParameter(1);
                    spq.setParameter(p, this.calDate, TemporalType.DATE);
                    if (!spq.execute()) {
                        Object o = spq.getOutputParameterValue(2);
                        if (o instanceof Integer) {
                            int actual = (Integer)o;
                            if (actual == this.emp2.getId()) {
                                TestUtil.logTrace((String)("Received expected id:" + actual));
                                pass2 = true;
                            } else {
                                TestUtil.logErr((String)("Expected id: " + this.emp2.getId() + ", actual:" + actual));
                            }
                        } else {
                            TestUtil.logErr((String)("Did not get instance of Integer back:" + o));
                        }
                    } else {
                        TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
                    if (!this.getEntityTransaction().isActive()) break block19;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                TestUtil.logMsg((String)"Testing Query object");
                StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq1.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
                spq1.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                spq1.setParameter(1, this.getCalDate(), TemporalType.DATE);
                StoredProcedureQuery q = spq1;
                Parameter p = q.getParameter(1);
                q.setParameter(p, this.calDate, TemporalType.DATE);
                Parameter p2 = q.getParameter(1);
                if (p.getPosition().equals(p2.getPosition()) && p.getParameterType().equals(p2.getParameterType())) {
                    TestUtil.logTrace((String)"Received expected parameter");
                    pass3 = true;
                } else {
                    TestUtil.logErr((String)("Expected parameter:" + p + ", actual:" + p2));
                }
                StoredProcedureQuery spq2 = q;
                if (!spq2.execute()) {
                    Object o = spq2.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == this.emp2.getId()) {
                            TestUtil.logTrace((String)("Received expected id:" + actual));
                            pass5 = true;
                        } else {
                            TestUtil.logErr((String)("Expected id: " + this.emp2.getId() + ", actual:" + actual));
                        }
                    } else {
                        TestUtil.logErr((String)("Did not get instance of Integer back:" + o));
                    }
                } else {
                    TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
                if (!this.getEntityTransaction().isActive()) break block20;
                this.getEntityTransaction().rollback();
            }
        }
        if (!(pass2 && pass3 && pass5)) {
            throw new EETest.Fault("setParameterParameterCalendarTemporalTypeTest failed");
        }
    }

    @SetupMethod(name="setupEmployee2Data")
    public void setParameterParameterCalendarTemporalTypeIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Get parameter from other stored procedure");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq.setParameter(1, (Object)"INOUT");
            Parameter p = spq.getParameter(1);
            TestUtil.logMsg((String)"Testing StoredProcedureQuery with parameter specified from another query");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq1.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            spq1.setParameter(1, this.getCalDate(), TemporalType.DATE);
            try {
                spq1.setParameter(p, this.getCalDate(), TemporalType.DATE);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing Query object with parameter specified from another query");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq3.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            StoredProcedureQuery q1 = spq3.setParameter(1, (Object)this.getCalDate());
            try {
                q1.setParameter(p, this.getCalDate(), TemporalType.DATE);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterParameterCalendarTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    public void setParameterParameterDateTemporalTypeTest() throws EETest.Fault {
        boolean pass5;
        boolean pass3;
        boolean pass2;
        block20: {
            block19: {
                pass2 = false;
                pass3 = false;
                pass5 = false;
                try {
                    this.getEntityTransaction().begin();
                    StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                    spq.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
                    spq.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                    spq.setParameter(1, this.getUtilDate(), TemporalType.DATE);
                    Parameter p = spq.getParameter(1);
                    spq.setParameter(p, this.utilDate, TemporalType.DATE);
                    if (!spq.execute()) {
                        Object o = spq.getOutputParameterValue(2);
                        if (o instanceof Integer) {
                            int actual = (Integer)o;
                            if (actual == 1) {
                                TestUtil.logTrace((String)("Received expected id:" + actual));
                                pass2 = true;
                            } else {
                                TestUtil.logErr((String)("Expected id: 1, actual:" + actual));
                            }
                        } else {
                            TestUtil.logErr((String)("Did not get instance of Integer back:" + o));
                        }
                    } else {
                        TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
                    if (!this.getEntityTransaction().isActive()) break block19;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                TestUtil.logMsg((String)"Testing Query object");
                StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq1.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
                spq1.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                spq1.setParameter(1, this.getCalDate().getTime(), TemporalType.DATE);
                StoredProcedureQuery q = spq1;
                Parameter p = q.getParameter(1);
                q.setParameter(p, this.utilDate, TemporalType.DATE);
                Parameter p2 = q.getParameter(1);
                if (p.getPosition().equals(p2.getPosition()) && p.getParameterType().equals(p2.getParameterType())) {
                    TestUtil.logTrace((String)"Received expected parameter");
                    pass3 = true;
                } else {
                    TestUtil.logErr((String)("Expected parameter:" + p + ", actual:" + p2));
                }
                StoredProcedureQuery spq2 = q;
                if (!spq2.execute()) {
                    Object o = spq2.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == this.emp0.getId()) {
                            TestUtil.logTrace((String)("Received expected id:" + actual));
                            pass5 = true;
                        } else {
                            TestUtil.logErr((String)("Expected id: 1, actual:" + actual));
                        }
                    } else {
                        TestUtil.logErr((String)("Did not get instance of Integer back:" + o));
                    }
                } else {
                    TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
                if (!this.getEntityTransaction().isActive()) break block20;
                this.getEntityTransaction().rollback();
            }
        }
        if (!(pass2 && pass3 && pass5)) {
            throw new EETest.Fault("setParameterParameterDateTemporalTypeTest failed");
        }
    }

    public void setParameterParameterDateTemporalTypeIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Get parameter from other stored procedure");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq.setParameter(1, (Object)"INOUT");
            Parameter p = spq.getParameter(1);
            TestUtil.logMsg((String)"Testing StoredProcedureQuery with parameter specified from another query");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq1.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
            spq1.setParameter(1, this.getUtilDate(), TemporalType.DATE);
            try {
                spq1.setParameter(p, this.getUtilDate(), TemporalType.DATE);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            TestUtil.logMsg((String)"Testing Query object with parameter specified from another query");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq3.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            StoredProcedureQuery q1 = spq3.setParameter(1, (Object)this.getCalDate());
            try {
                q1.setParameter(p, this.getCalDate(), TemporalType.DATE);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterParameterDateTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    public void executeUpdateOfAnUpdateTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("UpdateEmpSalaryColumn");
            spq.executeUpdate();
            int updateCount = spq.getUpdateCount();
            if (updateCount == -1) {
                TestUtil.logTrace((String)("Received expected update count:" + updateCount));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected update count: -1, actual:" + updateCount));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("executeUpdateOfAnUpdateTest failed");
        }
    }

    public void executeUpdateOfADeleteTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DeleteAllEmp");
            spq.executeUpdate();
            int updateCount = spq.getUpdateCount();
            if (updateCount == -1) {
                TestUtil.logTrace((String)("Received expected update count:" + updateCount));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected update count: -1, actual:" + updateCount));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("executeUpdateOfADeleteTest failed");
        }
    }

    public void executeUpdateTransactionRequiredExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DeleteAllEmp");
            try {
                TestUtil.logMsg((String)("IsActive returns:" + this.getEntityTransaction().isActive()));
                spq.executeUpdate();
                TestUtil.logErr((String)"Did not throw TransactionRequiredException");
            }
            catch (TransactionRequiredException tre) {
                TestUtil.logTrace((String)"Received expected TransactionRequiredException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("executeUpdateTransactionRequiredExceptionTest failed");
        }
    }

    public void getParameterValueParameterTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            Parameter p = spq.getParameter(1);
            boolean b = spq.isBound(p);
            if (b) {
                TestUtil.logTrace((String)("Received expected from isBound():" + b));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected result from isBound():true, actual:" + b));
            }
            if (!spq.execute()) {
                p = spq.getParameter(1);
                Object o = spq.getParameterValue(p);
                if (o instanceof Integer) {
                    TestUtil.logTrace((String)"Received expected parameter type: Integer");
                    Integer i = (Integer)o;
                    if (i.equals(this.emp0.getId())) {
                        TestUtil.logTrace((String)("Received expected parameter value:" + i));
                        pass3 = true;
                    } else {
                        TestUtil.logErr((String)("Expected getParameterValue() result: " + this.emp0.getId() + ", actual:" + i));
                    }
                } else {
                    TestUtil.logErr((String)("Did not get instance of Integer from getParameterValue():" + o));
                }
            } else {
                TestUtil.logErr((String)"Expected execute() to return false, actual: true");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass3) {
            throw new EETest.Fault("getParameterValueParameterTest failed");
        }
    }

    public void getParameterValueParameterIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq.setParameter(1, (Object)"1");
            Parameter p = spq.getParameter(1);
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq1.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq1.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq1.setParameter(1, (Object)1);
            try {
                spq1.getParameterValue(p);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getParameterValueParameterIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterValueParameterIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            Parameter p = spq.getParameter(1);
            boolean b = spq.isBound(p);
            if (b) {
                TestUtil.logTrace((String)("Received expected from isBound():" + b));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected result from isBound():true, actual:" + b));
            }
            Parameter p2 = spq.getParameter(2);
            try {
                spq.getParameterValue(p2);
                TestUtil.logErr((String)"Did not throw IllegalStateException");
            }
            catch (IllegalStateException iae) {
                TestUtil.logTrace((String)"Received expected IllegalStateException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterValueParameterIllegalStateExceptionTest failed");
        }
    }

    public void getParameterValueIntTest() throws EETest.Fault {
        boolean pass4;
        boolean pass3;
        boolean pass2;
        boolean pass1;
        block24: {
            String s;
            Object o;
            StoredProcedureQuery spq;
            block23: {
                pass1 = false;
                pass2 = false;
                pass3 = false;
                pass4 = false;
                try {
                    this.getEntityTransaction().begin();
                    TestUtil.logMsg((String)"Testing createStoredProcedureQuery");
                    spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
                    spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
                    spq.setParameter(1, (Object)"1");
                    o = spq.getParameterValue(1);
                    if (o instanceof String) {
                        TestUtil.logTrace((String)"Received expected parameter type: String");
                        s = (String)o;
                        if (s.equals("1")) {
                            TestUtil.logTrace((String)("Received expected parameter value:" + s));
                            pass1 = true;
                        } else {
                            TestUtil.logErr((String)("Expected getParameterValue() result: 1, actual:" + s));
                        }
                    } else {
                        TestUtil.logErr((String)("Did not get instance of String from getParameterValue():" + o));
                    }
                    if (!spq.execute()) {
                        o = spq.getParameterValue(1);
                        if (o instanceof String) {
                            TestUtil.logTrace((String)"Received expected parameter type: String");
                            s = (String)o;
                            if (s.equals("1")) {
                                TestUtil.logTrace((String)("Received expected parameter value:" + s));
                                pass2 = true;
                            } else {
                                TestUtil.logErr((String)("Expected getParameterValue() result: 1, actual:" + s));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                    if (!this.getEntityTransaction().isActive()) break block23;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                TestUtil.logMsg((String)"Testing createNamedStoredProcedureQuery");
                spq = this.getEntityManager().createNamedStoredProcedureQuery("getemplastnamefrominout");
                spq.setParameter(1, (Object)"1");
                o = spq.getParameterValue(1);
                if (o instanceof String) {
                    TestUtil.logTrace((String)"Received expected parameter type: String");
                    s = (String)o;
                    if (s.equals("1")) {
                        TestUtil.logTrace((String)("Received expected parameter value:" + s));
                        pass3 = true;
                    } else {
                        TestUtil.logErr((String)("Expected getParameterValue() result: 1, actual:" + s));
                    }
                } else {
                    TestUtil.logErr((String)("Did not get instance of String from getParameterValue():" + o));
                }
                if (!spq.execute()) {
                    o = spq.getParameterValue(1);
                    if (o instanceof String) {
                        TestUtil.logTrace((String)"Received expected parameter type: String");
                        s = (String)o;
                        if (s.equals("1")) {
                            TestUtil.logTrace((String)("Received expected parameter value:" + s));
                            pass4 = true;
                        } else {
                            TestUtil.logErr((String)("Expected getParameterValue() result: 1, actual:" + s));
                        }
                    }
                } else {
                    TestUtil.logErr((String)"Expected execute() to return false, actual: true");
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                if (!this.getEntityTransaction().isActive()) break block24;
                this.getEntityTransaction().rollback();
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("getParameterValueIntTest failed");
        }
    }

    public void getParameterValueIntIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            try {
                spq.getParameterValue(99);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getParameterValueIntIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterValueIntIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            try {
                spq.getParameterValue(2);
                TestUtil.logErr((String)"Did not throw IllegalStateException");
            }
            catch (IllegalStateException iae) {
                TestUtil.logTrace((String)"Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getParameterValueIntIllegalStateExceptionTest failed");
        }
    }

    public void setHintStringObjectTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            spq.getParameterValue(1);
            spq.setHint("property.that.is.not.recognized", (Object)"property.that.is.not.recognized");
            spq.execute();
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("setHintStringObjectTest failed");
        }
    }

    public void xmlOverridesNamedStoredProcedureQueryTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            StoredProcedureQuery spq = this.getEntityManager().createNamedStoredProcedureQuery("tobeoverridden1");
            spq.setParameter(1, (Object)1);
            Object o = spq.getParameterValue(1);
            if (o instanceof Integer) {
                TestUtil.logTrace((String)"Received expected parameter type: Integer");
                Integer i = (Integer)o;
                if (i.equals(1)) {
                    TestUtil.logTrace((String)("Received expected parameter value:" + i));
                    pass1 = true;
                } else {
                    TestUtil.logErr((String)("Expected getParameterValue() result: 1, actual:" + i));
                }
            } else {
                TestUtil.logErr((String)("Did not get instance of Integer from getParameterValue():" + o));
            }
            if (!spq.execute()) {
                o = spq.getOutputParameterValue(2);
                if (o instanceof String) {
                    TestUtil.logTrace((String)"Received expected parameter type: String");
                    String s = (String)o;
                    if (s.equals(this.emp0.getFirstName())) {
                        TestUtil.logTrace((String)("Received expected parameter value:" + s));
                        pass2 = true;
                    } else {
                        TestUtil.logErr((String)("Expected getParameterValue() result: " + this.emp0.getFirstName() + ", actual:" + s));
                    }
                }
            } else {
                TestUtil.logErr((String)"Expected execute() to return false, actual: true");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("xmlOverridesNamedStoredProcedureQueryTest failed");
        }
    }

    public void xmlOverridesSqlResultSetMappingAnnotationTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            try {
                TestUtil.logMsg((String)"Testing using name,result mapping");
                this.clearCache();
                StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"tobeoverridden2"});
                spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                    TestUtil.logTrace((String)"register refcursor parameter");
                    spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
                }
                spq.setParameter(1, (Object)1);
                if (spq.execute()) {
                    List<List> listOfList = this.getResultSetsFromStoredProcedure(spq);
                    if (listOfList.size() == 1) {
                        ArrayList<Employee> expected = new ArrayList<Employee>();
                        expected.add(new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName()));
                        pass = this.verifyListOfListEmployees(expected, listOfList);
                    } else {
                        TestUtil.logErr((String)("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size()));
                    }
                } else {
                    TestUtil.logErr((String)"Expected execute() to return true, actual: false");
                }
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
        }
        if (!pass) {
            throw new EETest.Fault("xmlOverridesSqlResultSetMappingAnnotationTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeTestData() {
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Creating Employees");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.emp0 = new Employee(1, "Alan", "Frechette", this.utilDate, 35000.0f);
            this.empRef.add(this.emp0);
            this.empRef.add(new Employee(2, "Arthur", "Frechette", d2, 35000.0f));
            this.empRef.add(new Employee(3, "Shelly", "McGowan", d3, 50000.0f));
            this.empRef.add(new Employee(4, "Robert", "Bissett", d4, 55000.0f));
            this.empRef.add(new Employee(5, "Stephen", "DMilla", d5, 25000.0f));
            for (Employee e : this.empRef) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                TestUtil.logTrace((String)("persisted employee:" + e));
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployee2TestData() {
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Creating Employee2");
            Calendar d2 = this.getCalDate(2001, 6, 27);
            Calendar d3 = this.getCalDate(2002, 7, 7);
            Calendar d4 = this.getCalDate(2003, 3, 3);
            Calendar d5 = this.getCalDate();
            this.emp2 = new Employee2(1, "Alan", "Frechette", this.calDate, 35000.0f);
            this.empRef2.add(this.emp2);
            this.empRef2.add(new Employee2(2, "Arthur", "Frechette", d2, 35000.0f));
            this.empRef2.add(new Employee2(3, "Shelly", "McGowan", d3, 50000.0f));
            this.empRef2.add(new Employee2(4, "Robert", "Bissett", d4, 55000.0f));
            this.empRef2.add(new Employee2(5, "Stephen", "DMilla", d5, 25000.0f));
            for (Employee2 e : this.empRef2) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                TestUtil.logTrace((String)("persisted Employee2:" + e));
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM INSURANCE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

