/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateful.cm.allowedmethodstest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import jakarta.transaction.UserTransaction;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;

public class TestBeanNoTxEJB
implements SessionBean {
    private SessionContext sctx = null;
    private Properties harnessProps = null;
    private TSNamingContext nctx = null;
    private String role = "Administrator";
    private Hashtable table = new Hashtable();
    private static final String testLookup = "java:comp/env/ejb/Helper";
    private UserTransaction ut;
    private static final String[] tests = new String[]{"ejbCreate", "ejbRemove", "ejbActivate", "ejbPassivate", "afterBegin", "beforeCompletion", "afterCompletion", "setSessionContext", "businessMethod"};
    private static final Properties[] methodList = new Properties[]{new Properties(), new Properties(), new Properties(), new Properties(), new Properties(), new Properties(), new Properties(), new Properties(), new Properties()};

    public void ejbCreate(Properties p) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.harnessProps = p;
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (NamingException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Unable to obtain naming context");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Unable to obtain NamingContext");
        }
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public Hashtable getResults() {
        TestUtil.logTrace((String)"getResults");
        return this.table;
    }

    public void txNotSupported() {
        TestUtil.logTrace((String)"txNotSupported");
        this.doOperationTests("businessMethod");
    }

    public void txSupports() {
        TestUtil.logTrace((String)"txSupports");
        this.doOperationTests("businessMethod");
    }

    public void txNever() {
        TestUtil.logTrace((String)"txNever");
        this.doOperationTests("businessMethod");
    }

    private int testIndex(String s) {
        TestUtil.logTrace((String)"testIndex");
        for (int i = 0; i < tests.length; ++i) {
            if (!s.equals(tests[i])) continue;
            return i;
        }
        return -1;
    }

    private void setTestList(int i) {
        TestUtil.logTrace((String)"setTestList");
        methodList[i].setProperty("JNDI_Access", "true");
        methodList[i].setProperty("getEJBHome", "true");
        methodList[i].setProperty("getCallerPrincipal", "true");
        methodList[i].setProperty("getRollbackOnly", "true");
        methodList[i].setProperty("isCallerInRole", "true");
        methodList[i].setProperty("setRollbackOnly", "true");
        methodList[i].setProperty("getEJBObject", "true");
        methodList[i].setProperty("UserTransaction", "true");
    }

    private void doOperationTests(String s) {
        TestUtil.logTrace((String)"doOperationTests");
        int i = this.testIndex(s);
        TestUtil.logMsg((String)("index for " + s + " is " + i));
        TestUtil.logMsg((String)("methodList length=" + methodList.length));
        TestUtil.logMsg((String)("tests length=" + tests.length));
        this.setTestList(i);
        TestUtil.logMsg((String)("Operations testing for " + s + " method ..."));
        try {
            this.sctx.getEJBHome();
            TestUtil.logMsg((String)"Operations test: getEJBHome() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBHome", "false");
            TestUtil.logMsg((String)"Operations test: getEJBHome() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBHome", "false");
            TestUtil.logMsg((String)("Operations test: getEJBHome() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getCallerPrincipal();
            TestUtil.logMsg((String)"Operations test: getCallerPrincipal() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getCallerPrincipal", "false");
            TestUtil.logMsg((String)"Operations test: getCallerPrincipal() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getCallerPrincipal", "false");
            TestUtil.logMsg((String)("Operations test: getCallerPrincipal() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getRollbackOnly();
            TestUtil.logMsg((String)"Operations test: getRollbackOnly() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getRollbackOnly", "false");
            TestUtil.logMsg((String)"Operations test: getRollbackOnly() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getRollbackOnly", "false");
            TestUtil.logMsg((String)("Operations test: getRollbackOnly() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.isCallerInRole(this.role);
            TestUtil.logMsg((String)"Operations test: isCallerInRole() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("isCallerInRole", "false");
            TestUtil.logMsg((String)"Operations test: isCallerInRole() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("isCallerInRole", "false");
            TestUtil.logMsg((String)("Operations test: isCallerInRole() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getEJBObject();
            TestUtil.logMsg((String)"Operations test: getEJBObject() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBObject", "false");
            TestUtil.logMsg((String)"Operations test: getEJBObject() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBObject", "false");
            TestUtil.logMsg((String)("Operations test: getEJBObject() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            Context ctx = (Context)this.nctx.lookup("java:comp/env");
            TestUtil.logMsg((String)"Operations test: JNDI_Access - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("JNDI_Access", "false");
            TestUtil.logMsg((String)"Operations test: JNDI_Access - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("JNDI_Access", "false");
            TestUtil.logMsg((String)("Operations test: JNDI_Access - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.ut = this.sctx.getUserTransaction();
            TestUtil.logMsg((String)"Operations test: UserTransaction - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction", "false");
            TestUtil.logMsg((String)("Operations test: UserTransaction - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.setRollbackOnly();
            TestUtil.logMsg((String)"Operations test: setRollbackOnly() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("setRollbackOnly", "false");
            TestUtil.logMsg((String)"Operations test: setRollbackOnly() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("setRollbackOnly", "false");
            TestUtil.logMsg((String)("Operations test: setRollbackOnly() - not allowed (Unexpected Exception) - " + e));
        }
        this.table.put(s, methodList[i]);
    }
}

