/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.relationship.bidironexone;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.relationship.bidironexone.BiDir1X1Person;
import com.sun.ts.tests.jpa.core.relationship.bidironexone.BiDir1X1Project;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void biDir1X1Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin biDir1X1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BiDir1X1Project project = new BiDir1X1Project(1L, "JavaEE", 500.0f);
            BiDir1X1Person person = new BiDir1X1Person(Long.valueOf(1L), "Duke");
            project.setBiDir1X1Person(person);
            person.setProject(project);
            this.getEntityManager().persist((Object)project);
            this.getEntityTransaction().commit();
            TestUtil.logTrace((String)"persisted Project this in turn must persist Person too..");
            this.getEntityTransaction().begin();
            BiDir1X1Person newPerson = (BiDir1X1Person)this.getEntityManager().find(BiDir1X1Person.class, (Object)1L);
            if (newPerson != null) {
                TestUtil.logTrace((String)"Found Searched Person Entity");
                if (this.getEntityManager().contains((Object)newPerson) && newPerson.getName().equals("Duke")) {
                    TestUtil.logTrace((String)"biDir1X1Test1: Expected results received");
                    pass = true;
                }
            } else {
                TestUtil.logTrace((String)"searched Person not found");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("biDir1X1Test1 failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIR1X1PERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIR1X1PROJECT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

