/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.sec.cmp.sec;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.sec.cmp.common.SecTest;
import com.sun.ts.tests.ejb.ee.sec.cmp.common.SecTestHome;
import com.sun.ts.tests.ejb.ee.sec.cmp.common.SecTestRoleRef;
import com.sun.ts.tests.ejb.ee.sec.cmp.common.SecTestRoleRefHome;
import java.rmi.RemoteException;
import java.util.Properties;

public class Client
extends EETest {
    private static final String ejb1name = "java:comp/env/ejb/SecTest";
    private static final String ejb2name = "java:comp/env/ejb/SecTestRoleRef";
    private SecTestHome ejb1home = null;
    private SecTest ejb1ref = null;
    private SecTestRoleRefHome ejb2home = null;
    private SecTestRoleRef ejb2ref = null;
    private static final String emp_secrole_ref = "EMP";
    private static final String admin_secrole_ref = "ADMIN";
    private static final String mgr_secrole_ref = "MGR";
    private static final String testDir = System.getProperty("user.dir");
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private String username = "";
    private String password = "";
    private Properties props = null;
    private TSNamingContext nctx = null;
    private TSLoginContext lc = null;
    private boolean newTable = true;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.username = this.props.getProperty(UserNameProp);
            this.password = this.props.getProperty(UserPasswordProp);
            this.nctx = new TSNamingContext();
            this.lc = new TSLoginContext();
            this.lc.login(this.username, this.password);
            this.ejb1home = (SecTestHome)this.nctx.lookup(ejb1name, SecTestHome.class);
            this.ejb2home = (SecTestRoleRefHome)this.nctx.lookup(ejb2name, SecTestRoleRefHome.class);
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        this.logMsg("Starting No caller authorization test");
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            this.ejb1ref.EjbNotAuthz();
            this.logErr("Method call did not generate an expected java.rmi.RemoteException");
            if (this.ejb1ref != null) {
                TestUtil.logTrace((String)"removing ejb1ref from test1");
                this.ejb1ref.remove();
                TestUtil.logTrace((String)"ejb1ref removed from test1");
            }
            throw new EETest.Fault("No caller authorization test failed");
        }
        catch (RemoteException e) {
            TestUtil.logMsg((String)"Caught java.rmi.RemoteException as expected");
            TestUtil.logMsg((String)"No authorization test passed");
            try {
                if (this.ejb1ref != null) {
                    TestUtil.logTrace((String)"removing ejb1ref from test1 in catch block");
                    this.ejb1ref.remove();
                    TestUtil.logTrace((String)"ejb1ref removed from test1 in catch block");
                }
            }
            catch (Exception ex1) {
                this.logErr("ERROR:  Unexpected exception occurred removing ejb1ref in test1: ", ex1);
            }
        }
        catch (Exception en) {
            try {
                if (this.ejb1ref != null) {
                    TestUtil.logTrace((String)"removing ejb1ref from test1 in catch block");
                    this.ejb1ref.remove();
                    TestUtil.logTrace((String)"ejb1ref removed from test1 in catch block");
                }
            }
            catch (Exception ex1) {
                this.logErr("ERROR:  Unexpected exception occurred in test1: ", ex1);
            }
            throw new EETest.Fault("No caller authorization test failed:", en);
        }
    }

    public void test2() throws EETest.Fault {
        this.logMsg("Starting Caller authorization test");
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            boolean pass = this.ejb1ref.EjbIsAuthz();
            if (this.ejb1ref != null) {
                TestUtil.logTrace((String)"removing ejb1ref from test2");
                this.ejb1ref.remove();
                TestUtil.logTrace((String)"ejb1ref removed from test2");
            }
            if (!pass) {
                throw new EETest.Fault("Caller authorization test failed");
            }
            this.logMsg("Caller authorization test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Caller authorization test failed: ", e);
        }
    }

    public void test3() throws EETest.Fault {
        this.logMsg("Starting Security role reference positive test");
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            boolean pass = this.ejb1ref.EjbSecRoleRef(emp_secrole_ref);
            if (this.ejb1ref != null) {
                TestUtil.logTrace((String)"removing ejb1ref from test3");
                this.ejb1ref.remove();
                TestUtil.logTrace((String)"ejb1ref removed from test3");
            }
            if (!pass) {
                this.logErr("EjbSecRoleRef(EMP) returned false");
                throw new EETest.Fault("Security role reference positive test failed");
            }
            this.logMsg("Security role reference positive test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference positive test failed: ", e);
        }
    }

    public void test4() throws EETest.Fault {
        this.logMsg("Starting Security role reference negative test");
        try {
            boolean pass;
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            boolean bl = pass = !this.ejb1ref.EjbSecRoleRef(mgr_secrole_ref);
            if (this.ejb1ref != null) {
                TestUtil.logTrace((String)"removing ejb1ref from test4");
                this.ejb1ref.remove();
                TestUtil.logTrace((String)"ejb1ref removed from test4");
            }
            if (!pass) {
                this.logErr("EjbSecRoleRef(MGR) returned true");
                throw new EETest.Fault("Security role reference negative test failed");
            }
            this.logMsg("Security role reference negative test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference negative test failed: ", e);
        }
    }

    public void test5() throws EETest.Fault {
        boolean pass;
        this.logMsg("Starting Security role reference scope test");
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            pass = this.ejb1ref.EjbSecRoleRef(emp_secrole_ref);
            if (this.ejb1ref != null) {
                TestUtil.logTrace((String)"removing ejb1ref from test5");
                this.ejb1ref.remove();
                TestUtil.logTrace((String)"ejb1ref removed from test5");
            }
            if (!pass) {
                this.logErr("isCallerInRole(EMP) returned false");
                throw new EETest.Fault("Security role reference scope test failed");
            }
            this.logMsg("(ejb1) isCallerInRole(EMP) returned true as expected");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference scope test failed: ", e);
        }
        try {
            this.ejb2ref = this.ejb2home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            pass = this.ejb2ref.EjbSecRoleRefScope(emp_secrole_ref);
            if (this.ejb2ref != null) {
                TestUtil.logTrace((String)"removing ejb2ref from test5");
                this.ejb2ref.remove();
                TestUtil.logTrace((String)"ejb2ref removed from test5");
            }
            if (pass) {
                this.logMsg("isCallerInRole(EMP) returned true");
                throw new EETest.Fault("Security role reference scope test failed");
            }
            this.logMsg("(ejb2) isCallerInRole(EMP) returned false as expected");
            this.logMsg("Security role reference scope test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference scope test failed: ", e);
        }
    }

    public void test6() throws EETest.Fault {
        this.logMsg("Starting Overloaded security role references test");
        this.ejb1ref = null;
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            if (!this.ejb1ref.EjbOverloadedSecRoleRefs(emp_secrole_ref)) {
                this.logErr("EjbOverloadedSecRoleRefs(EMP) returned false");
                throw new EETest.Fault("Overloaded security role references test failed");
            }
            this.logMsg("EjbOverloadedSecRoleRefs(EMP) returned true as expected");
            if (this.ejb1ref.EjbOverloadedSecRoleRefs(emp_secrole_ref, mgr_secrole_ref)) {
                this.logErr("EjbOverloadedRoleRefs(EMP,MGR) returned true");
                throw new EETest.Fault("Overloaded security role references test failed");
            }
            this.logMsg("EjbOverloadedSecRoleRefs(EMP,MGR) returned false as expected");
        }
        catch (Exception e) {
            throw new EETest.Fault("Overloaded security role references test failed: ", e);
        }
        finally {
            try {
                if (this.ejb1ref != null) {
                    this.logMsg("Removing object reference in test6 finally block");
                    this.ejb1ref.remove();
                }
            }
            catch (Exception e) {
                throw new EETest.Fault("Exception caught removing bean for test6: ", e);
            }
        }
        this.logMsg("Overloaded security role references test passed");
    }

    public void test7() throws EETest.Fault {
        this.logMsg("Starting unchecked test1");
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.checktest1();
            if (this.ejb1ref != null) {
                TestUtil.logTrace((String)"removing ejb1ref from test7");
                this.ejb1ref.remove();
                TestUtil.logTrace((String)"ejb1ref removed from test7");
            }
            if (!result) {
                this.logErr("unchecked test returned false");
                throw new EETest.Fault("unchecked test1 failed");
            }
            this.logMsg("unchecked test1 passed.");
        }
        catch (Exception e) {
            throw new EETest.Fault("unchecked test1 failed", e);
        }
    }

    public void test8() throws EETest.Fault {
        try {
            this.logMsg("Creating bean instance in test8");
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            this.logMsg("Calling excludetest1 in test8");
            this.ejb1ref.excludetest1();
            this.logErr("Method call did not generate an expected java.rmi.RemoteException");
            if (this.ejb1ref != null) {
                TestUtil.logTrace((String)"removing ejb1ref from test8");
                this.ejb1ref.remove();
                TestUtil.logTrace((String)"ejb1ref removed from test8");
            }
            throw new EETest.Fault("test8 failed");
        }
        catch (RemoteException e) {
            TestUtil.logMsg((String)"Caught java.rmi.RemoteException as expected");
            TestUtil.logMsg((String)"No authorization test passed");
            try {
                if (this.ejb1ref != null) {
                    TestUtil.logTrace((String)"removing ejb1ref from test8 in expected catch block");
                    this.ejb1ref.remove();
                    TestUtil.logTrace((String)"ejb1ref removed from test8 in expected catch block");
                }
            }
            catch (Exception ex1) {
                this.logErr("ERROR:  Unexpected exception occurred removing ejb1ref in test8: ", ex1);
            }
        }
        catch (Exception en) {
            try {
                if (this.ejb1ref != null) {
                    TestUtil.logTrace((String)"removing ejb1ref from test8 in unexpected catch block");
                    this.ejb1ref.remove();
                    TestUtil.logTrace((String)"ejb1ref removed from test8 in unexpected catch block");
                }
            }
            catch (Exception ex1) {
                this.logErr("ERROR:  Unexpected exception occurred in test8: ", ex1);
            }
            throw new EETest.Fault("test8 failed:", en);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup");
    }
}

