/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.criteriaapi.Join;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.schema30.Customer;
import com.sun.ts.tests.jpa.common.schema30.Customer_;
import com.sun.ts.tests.jpa.common.schema30.Department_;
import com.sun.ts.tests.jpa.common.schema30.Employee;
import com.sun.ts.tests.jpa.common.schema30.Employee_;
import com.sun.ts.tests.jpa.common.schema30.Order;
import com.sun.ts.tests.jpa.common.schema30.Order_;
import com.sun.ts.tests.jpa.common.schema30.Util;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class Client
extends Util {
    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"Entering Setup");
        try {
            super.setup(args, p);
            this.getEntityManager();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinStringTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = true;
        boolean pass4 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Set sJoins = customer.getJoins();
            if (!sJoins.isEmpty()) {
                TestUtil.logErr((String)"Expected getJoins() to return empty set instead got:");
                for (Join j : sJoins) {
                    TestUtil.logErr((String)("join:" + j.toString()));
                }
            } else {
                TestUtil.logTrace((String)"getJoin() returned empty set as expected");
                pass1 = true;
            }
            CollectionJoin order = customer.join(Customer_.orders);
            Set s = customer.getJoins();
            if (s.isEmpty()) {
                TestUtil.logErr((String)"Expected getJoins() to return non empty set");
            } else if (s.size() == 1) {
                TestUtil.logTrace((String)"getJoins returned:");
                Iterator i = s.iterator();
                while (i.hasNext()) {
                    pass2 = true;
                    Join j = (Join)i.next();
                    TestUtil.logTrace((String)("join:" + j.toString()));
                    String name = j.getAttribute().getName();
                    if (name.equals("orders")) {
                        TestUtil.logTrace((String)"Received expected attribute: orders");
                        continue;
                    }
                    TestUtil.logErr((String)("Expected attribute: orders, actual:" + name));
                    pass3 = false;
                }
            } else {
                pass3 = false;
                TestUtil.logErr((String)("Expected getJoins to return 1 join, actual:" + s.size()));
                TestUtil.logErr((String)"getJoins returned:");
                for (Join j : s) {
                    TestUtil.logErr((String)("join:" + j.toString()));
                }
            }
            Join lineItem = order.join("lineItemsCollection");
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass4 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("joinStringTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinStringJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            Join lineItem = order.join("lineItemsCollection", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinStringJoinTypeTest failed");
        }
    }

    public void joinStringIllegalArgumentExceptionTest() throws EETest.Fault {
        CollectionJoin order;
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join(Customer_.orders);
            try {
                order.join("doesnotexist");
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        TestUtil.logMsg((String)"String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join(Customer_.orders);
            try {
                order.join("doesnotexist", JoinType.INNER);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("joinStringIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSingularAttributeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            Join creditCard = order.join("creditCard");
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)creditCard.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinSingularAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSingularAttributeJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            Join creditCard = order.join("creditCard", JoinType.INNER);
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)creditCard.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinSingularAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinCollectionAttributeTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.join(Order_.lineItemsCollection);
            CollectionAttribute pa = lineItem.getModel();
            String name = pa.getName();
            if (name.equals("lineItemsCollection")) {
                TestUtil.logTrace((String)("Received expected attribute:" + name));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("getModel - Expected: lineItemsCollection, actual:" + name));
            }
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("joinCollectionAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinCollectionAttributeJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.join(Order_.lineItemsCollection, JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinCollectionAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinCollectionStringTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.joinCollection("lineItemsCollection");
            String name = lineItem.getModel().getName();
            if (name.equals("lineItemsCollection")) {
                TestUtil.logTrace((String)("Received expected CollectionAttribute:" + name));
            } else {
                TestUtil.logErr((String)("Expected CollectionAttribute:lineItems, actual:" + name));
            }
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinCollectionStringTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinCollectionStringJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.joinCollection("lineItemsCollection", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinCollectionStringJoinTypeTest failed");
        }
    }

    public void joinCollectionIllegalArgumentExceptionTest() throws EETest.Fault {
        CollectionJoin order;
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join(Customer_.orders);
            try {
                order.joinCollection("doesnotexist");
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        TestUtil.logMsg((String)"String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join(Customer_.orders);
            try {
                order.joinCollection("doesnotexist", JoinType.INNER);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("joinCollectionIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSetAttributeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2);
            SetJoin lineItem = order.join(Order_.lineItemsSet);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinSetAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSetAttributeJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2);
            SetJoin lineItem = order.join(Order_.lineItemsSet, JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinSetAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSetStringTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2);
            SetJoin lineItem = order.joinSet("lineItemsSet");
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinSetStringTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSetStringJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2);
            SetJoin lineItem = order.joinSet("lineItemsSet", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinSetStringJoinTypeTest failed");
        }
    }

    public void joinSetIllegalArgumentExceptionTest() throws EETest.Fault {
        SetJoin order;
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join(Customer_.orders2);
            try {
                order.joinSet("doesnotexist");
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        TestUtil.logMsg((String)"String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join(Customer_.orders2);
            try {
                order.joinSet("doesnotexist", JoinType.INNER);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("joinSetIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinListAttributeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2);
            ListJoin lineItem = order.joinList("lineItemsList");
            ListAttribute pa = lineItem.getModel();
            String name = pa.getName();
            if (name.equals("lineItemsList")) {
                TestUtil.logTrace((String)("Received expected attribute:" + name));
            } else {
                TestUtil.logErr((String)("getModel - Expected: lineItemsList, actual:" + name));
            }
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinListAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinListAttributeJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2);
            ListJoin lineItem = order.joinList("lineItemsList", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinListAttributeJoinTypeTest failed");
        }
    }

    public void joinListIllegalArgumentExceptionTest() throws EETest.Fault {
        Join order;
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing String");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join("orders3");
            try {
                order.joinList("doesnotexist");
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing String, JoinType");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            order = customer.join("orders3");
            try {
                order.joinList("doesnotexist", JoinType.INNER);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("joinListIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinListStringTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            ListJoin order = customer.joinList("orders3");
            ListJoin lineItem = order.joinList("lineItemsList");
            String name = lineItem.getModel().getName();
            if (name.equals("lineItemsList")) {
                TestUtil.logTrace((String)("Received expected ListAttribute:" + name));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected ListAttribute:lineItemsList, actual:" + name));
            }
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("joinListStringTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinListStringJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            ListJoin order = customer.joinList("orders3");
            ListJoin lineItem = order.joinList("lineItemsList", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinListStringJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void joinMapAttributeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Employee.class);
            Root employee = cquery.from(Employee.class);
            Join department = employee.join(Employee_.department);
            MapJoin mEmployee = department.join(Department_.lastNameEmployees);
            MapAttribute pa = mEmployee.getModel();
            String name = pa.getName();
            if (name.equals("lastNameEmployees")) {
                TestUtil.logTrace((String)("Received expected attribute:" + name));
            } else {
                TestUtil.logErr((String)("getModel - Expected: lastNameEmployees, actual:" + name));
            }
            cquery.where((Expression)cbuilder.equal((Expression)mEmployee.get("id"), (Object)"1")).select((Selection)employee);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "3", "5"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinMapAttributeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void joinMapAttributeJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Employee.class);
            Root employee = cquery.from(Employee.class);
            Join department = employee.join(Employee_.department);
            MapJoin mEmployee = department.join(Department_.lastNameEmployees, JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)mEmployee.get("id"), (Object)"1")).select((Selection)employee);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "3", "5"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinMapAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void joinMapStringTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Employee.class);
            Root employee = cquery.from(Employee.class);
            Join department = employee.join(Employee_.department);
            MapJoin mEmployee = department.joinMap("lastNameEmployees");
            String name = mEmployee.getModel().getName();
            if (name.equals("lastNameEmployees")) {
                TestUtil.logTrace((String)("Received expected attribute:" + name));
            } else {
                TestUtil.logErr((String)("getModel - Expected: lastNameEmployees, actual:" + name));
            }
            cquery.where((Expression)cbuilder.equal((Expression)mEmployee.get("id"), (Object)"1")).select((Selection)employee);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "3", "5"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinMapStringTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void joinMapStringJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Employee.class);
            Root employee = cquery.from(Employee.class);
            Join department = employee.join(Employee_.department);
            MapJoin mEmployee = department.joinMap("lastNameEmployees", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)mEmployee.get("id"), (Object)"1")).select((Selection)employee);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "3", "5"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 3 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinMapStringJoinTypeTest failed");
        }
    }

    public void joinMapIllegalArgumentExceptionTest() throws EETest.Fault {
        Join department;
        Root employee;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing String");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Employee.class);
            employee = cquery.from(Employee.class);
            department = employee.join(Employee_.department);
            try {
                department.joinMap("doesnotexist");
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing String, JoinType");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Employee.class);
            employee = cquery.from(Employee.class);
            department = employee.join(Employee_.department);
            try {
                department.joinMap("doesnotexist", JoinType.INNER);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("joinMapIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void pluralJoinTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.joinCollection("lineItemsCollection");
            String name = lineItem.getModel().getName();
            if (name.equals("lineItemsCollection")) {
                TestUtil.logTrace((String)("Received expected PluralAttribute:" + name));
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected PluralAttribute:lineItems, actual:" + name));
            }
            name = lineItem.getAttribute().getName();
            if (name.equals("lineItemsCollection")) {
                TestUtil.logTrace((String)("Received expected attribute:" + name));
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Expected attribute name: lineItems, actual:" + name));
            }
            JoinType type = lineItem.getJoinType();
            if (type.equals((Object)JoinType.INNER)) {
                TestUtil.logTrace((String)("Received expected JoinType:" + type));
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Expected JoinType : " + JoinType.INNER.toString() + ", actual:" + type));
            }
            From from = lineItem.getParent();
            String parent = from.getJavaType().getName();
            if (parent.equals("com.sun.ts.tests.jpa.common.schema30.Order")) {
                TestUtil.logTrace((String)("Received expected parent:" + parent));
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Expected parent: com.sun.ts.tests.jpa.common.schema30.Order, actual:" + parent));
            }
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass5 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new EETest.Fault("pluralJoinTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void pluralJoinOnExpressionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            if (order.getOn() == null) {
                TestUtil.logTrace((String)"Received expected null from getOn()");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected null from getOn(), actual:" + order.toString()));
            }
            Join join = order.on((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1"));
            Predicate pred = join.getOn();
            if (pred != null) {
                TestUtil.logTrace((String)"Received expected non-null from getOn()");
                pass2 = true;
            } else {
                TestUtil.logErr((String)"Received unexpected null from getOn()");
            }
            cquery.select((Selection)cbuilder.count((Expression)join));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Long actual = (Long)tquery.getSingleResult();
            if (actual == 1L) {
                TestUtil.logTrace((String)("Received expected number: " + actual));
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Expected: 1, actual:" + actual));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("pluralJoinOnExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void pluralJoinOnPredicateArrayTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            Predicate pred1 = cbuilder.equal((Expression)customer.get("id"), (Object)"1");
            Predicate pred2 = cbuilder.equal((Expression)customer.get("country").get("code"), (Object)"USA");
            Predicate[] pred = new Predicate[]{pred1, pred2};
            Join join = order.on(pred);
            Predicate pred3 = join.getOn();
            if (pred3.getExpressions().size() == 2) {
                TestUtil.logTrace((String)"Received expected number of predicates");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected: 2 predicates, actual:" + pred3.getExpressions().size()));
            }
            cquery.select((Selection)cbuilder.count((Expression)join));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Long actual = (Long)tquery.getSingleResult();
            if (actual == 1L) {
                TestUtil.logTrace((String)("Received expected number: " + actual));
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Expected: 1, actual:" + actual));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("pluralJoinOnPredicateArrayTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void collectionJoinOnExpressionTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            CollectionJoin lineItem = order.joinCollection("lineItemsCollection", JoinType.INNER);
            Predicate exp = cbuilder.gt((Expression)lineItem.get("quantity"), (Number)5);
            lineItem.on((Expression)exp);
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List oList = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "12"};
            if (!this.checkEntityPK(oList, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected: " + expectedPKs.length + "  reference, got: " + oList.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("collectionJoinOnExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void collectionJoinOnPredicateArrayTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            CollectionJoin lineItem = order.joinCollection("lineItemsCollection", JoinType.INNER);
            Predicate[] pred = new Predicate[]{cbuilder.gt((Expression)lineItem.get("quantity"), (Number)5), cbuilder.lt((Expression)lineItem.get("quantity"), (Number)8)};
            lineItem.on(pred);
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List oList = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(oList, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected: " + expectedPKs.length + "  reference, got: " + oList.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("collectionJoinOnPredicateArrayTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void listJoinOnExpressionTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            ListJoin lineItem = order.joinList("lineItemsList", JoinType.INNER);
            Predicate exp = cbuilder.gt((Expression)lineItem.get("quantity"), (Number)5);
            lineItem.on((Expression)exp);
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List oList = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "12"};
            if (!this.checkEntityPK(oList, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected: " + expectedPKs.length + "  reference, got: " + oList.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("listJoinOnExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void listJoinOnPredicateArrayTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            ListJoin lineItem = order.joinList("lineItemsList", JoinType.INNER);
            Predicate[] pred = new Predicate[]{cbuilder.gt((Expression)lineItem.get("quantity"), (Number)5), cbuilder.lt((Expression)lineItem.get("quantity"), (Number)8)};
            lineItem.on(pred);
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List oList = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(oList, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected: " + expectedPKs.length + "  reference, got: " + oList.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("listJoinOnPredicateArrayTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void setJoinOnExpressionTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            SetJoin lineItem = order.joinSet("lineItemsSet", JoinType.INNER);
            Predicate exp = cbuilder.gt((Expression)lineItem.get("quantity"), (Number)5);
            lineItem.on((Expression)exp);
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List oList = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "12"};
            if (!this.checkEntityPK(oList, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected: " + expectedPKs.length + "  reference, got: " + oList.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("setJoinOnExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void setJoinOnPredicateArrayTest() throws EETest.Fault {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Order.class);
            Root order = cquery.from(Order.class);
            SetJoin lineItem = order.joinSet("lineItemsSet", JoinType.INNER);
            Predicate[] pred = new Predicate[]{cbuilder.gt((Expression)lineItem.get("quantity"), (Number)5), cbuilder.lt((Expression)lineItem.get("quantity"), (Number)8)};
            lineItem.on(pred);
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List oList = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(oList, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected: " + expectedPKs.length + "  reference, got: " + oList.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("setJoinOnPredicateArrayTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void mapJoinValueTest() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1, Alan, Frechette");
        expected.add("1, Alan, McGowan");
        expected.add("1, Alan, DMilla");
        expected.add("3, Shelly, Frechette");
        expected.add("3, Shelly, McGowan");
        expected.add("3, Shelly, DMilla");
        expected.add("5, Stephen, Frechette");
        expected.add("5, Stephen, McGowan");
        expected.add("5, Stephen, DMilla");
        expected.add("2, Arthur, Frechette");
        expected.add("2, Arthur, Bissett");
        expected.add("4, Robert, Frechette");
        expected.add("4, Robert, Bissett");
        ArrayList<CallSite> actual = new ArrayList<CallSite>();
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root employee = cquery.from(Employee.class);
            Join department = employee.join(Employee_.department);
            MapJoin mEmployee = department.join(Department_.lastNameEmployees);
            cquery.multiselect(new Selection[]{employee.get(Employee_.id), employee.get(Employee_.firstName), mEmployee.value().get("lastName")});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            for (Tuple tuple : clist) {
                TestUtil.logTrace((String)("result:" + tuple.get(0) + ", " + tuple.get(1) + ", " + tuple.get(2)));
                actual.add((CallSite)((Object)(tuple.get(0) + ", " + tuple.get(1) + ", " + tuple.get(2))));
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                TestUtil.logTrace((String)"Received expected results");
                pass = true;
            } else {
                TestUtil.logErr((String)"Did not get expected results:");
                for (String string : expected) {
                    TestUtil.logErr((String)("expected:" + string));
                }
                for (String string : actual) {
                    TestUtil.logErr((String)("actual:" + string));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("mapJoinValueTest failed");
        }
    }
}

