/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.lrapitest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.entity.util.DBSupport;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.FinderException;
import jakarta.ejb.RemoveException;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;

public class DEJB
implements EntityBean {
    private EntityContext ectx = null;
    private TSNamingContext nctx = null;
    private DBSupport db = null;
    float cofPrice = 0.0f;

    public Integer ejbCreateD(Properties p, int cofID, String cofName, float cofPrice) throws CreateException {
        TestUtil.logTrace((String)"ejbCreateD");
        try {
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
            this.db.getDBConnection();
            this.db.tableInit();
            this.db.createNewRow(cofID, cofName, cofPrice);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("SQL Exception in create");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return new Integer(cofID);
    }

    public void ejbPostCreateD(Properties p, int cofID, String cofName, float cofPrice) {
        TestUtil.logTrace((String)"ejbPostCreateD");
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            TestUtil.logMsg((String)"Initialize DBSupport");
            this.db = new DBSupport(this.ectx);
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("NamingException ... " + e), (Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception ... " + e), (Throwable)e);
            throw new EJBException("unable to initialize DBSupport");
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        try {
            if (this.db == null) {
                TestUtil.logMsg((String)"Initialize DBSupport");
                this.db = new DBSupport(this.ectx);
            }
            this.db.getDBConnection();
            this.db.removeRow((Integer)this.ectx.getPrimaryKey());
        }
        catch (SQLException se) {
            TestUtil.printStackTrace((Throwable)se);
            throw new RemoveException("SQL Exception in remove");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RemoveException("unable to initialize DBSupport");
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrimaryKey");
        try {
            TestUtil.logMsg((String)"Get DB Connection");
            this.db.getDBConnection();
            boolean foundKey = this.db.keyExists(key);
            if (foundKey) {
                Integer n = key;
                return n;
            }
            try {
                throw new FinderException("Key not found: " + key);
            }
            catch (SQLException se) {
                TestUtil.printStackTrace((Throwable)se);
                throw new FinderException("SQL Exception in primary key finder");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new FinderException("Exception occurred: " + e);
            }
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
        try {
            if (this.db == null) {
                TestUtil.logMsg((String)"Initialize DBSupport");
                this.db = new DBSupport(this.ectx);
            }
            this.db.getDBConnection();
            this.cofPrice = this.db.loadPrice((Integer)this.ectx.getPrimaryKey());
        }
        catch (SQLException se) {
            TestUtil.printStackTrace((Throwable)se);
            throw new EJBException("SQL Exception in ejbLoad");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("unable to initialize DBSupport");
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
        try {
            if (this.db == null) {
                TestUtil.logMsg((String)"Initialize DBSupport");
                this.db = new DBSupport(this.ectx);
            }
            this.db.getDBConnection();
            this.db.storePrice((Integer)this.ectx.getPrimaryKey(), this.cofPrice);
        }
        catch (SQLException se) {
            TestUtil.printStackTrace((Throwable)se);
            throw new EJBException("SQL Exception in ejbStore");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("unable to initialize DBSupport");
        }
        finally {
            try {
                this.db.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public String ejbHomeAddBar(String s) {
        TestUtil.logTrace((String)"ejbHomeAddBar");
        return s + "bar";
    }

    public String whoAmILocal() {
        return "whoAmILocal cofPrice is: " + this.cofPrice;
    }
}

