/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jacc.web.toolsContracts;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jacc.util.LogFileProcessor;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private Properties props = null;
    private String contextId = "jacc_ctx";
    LogFileProcessor logProcessor = null;
    private String applicationContext;
    private boolean initialized = false;
    private Permissions unCheckedPermissions = new Permissions();
    private Permissions excludedPermissions = new Permissions();
    private Permissions addToRolePermissions = new Permissions();

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        if (!this.initialized) {
            this.logProcessor = new LogFileProcessor(this.props);
            this.logProcessor.fetchLogs("getAppSpecificRecordCollection|appId", "toolsContracts");
            this.unCheckedPermissions = this.logProcessor.getAppSpecificUnCheckedPermissions();
            this.excludedPermissions = this.logProcessor.getAppSpecificExcludedPermissions();
            this.addToRolePermissions = this.logProcessor.getAppSpecificAddToRolePermissions();
            this.initialized = true;
        }
    }

    public void cleanup() throws EETest.Fault {
    }

    public void WebResourcePermission() throws EETest.Fault {
        boolean verified = false;
        Permissions expectedUnCheckedPermissions = new Permissions();
        Permissions expectedExcludedPermissions = new Permissions();
        Permissions expectedAddToRolePermissions = new Permissions();
        Permissions uncheckedWebResourcePermissions = this.logProcessor.getSpecificPermissions(this.unCheckedPermissions, "WebResourcePermission");
        TestUtil.logMsg((String)"Server generated unchecked WebResourcePermissions");
        this.logProcessor.printPermissionCollection((PermissionCollection)uncheckedWebResourcePermissions);
        expectedUnCheckedPermissions.add((Permission)new WebResourcePermission("/unchecked.jsp", (String)null));
        expectedUnCheckedPermissions.add((Permission)new WebResourcePermission("/sslprotected.jsp", "!GET,POST"));
        expectedUnCheckedPermissions.add((Permission)new WebResourcePermission("/:/secured.jsp:/unchecked.jsp:/excluded.jsp:/sslprotected.jsp:/anyauthuser.jsp", (String)null));
        expectedUnCheckedPermissions.add((Permission)new WebResourcePermission("/excluded.jsp", "!GET,POST"));
        expectedUnCheckedPermissions.add((Permission)new WebResourcePermission("/secured.jsp", "!GET,POST"));
        expectedUnCheckedPermissions.add((Permission)new WebResourcePermission("/anyauthuser.jsp", "!GET,POST"));
        TestUtil.logMsg((String)"verifying unchecked policy statments:");
        verified = this.logProcessor.verifyLogImplies(expectedUnCheckedPermissions, uncheckedWebResourcePermissions);
        if (!verified) {
            throw new EETest.Fault("WebResourcePermission failed: unchecked policy statements verification failed");
        }
        TestUtil.logMsg((String)"unchecked policy statements verification successful");
        Permissions excludedWebResourcePermissions = this.logProcessor.getSpecificPermissions(this.excludedPermissions, "WebResourcePermission");
        TestUtil.logMsg((String)"Server generated excluded WebResourcePermissions");
        this.logProcessor.printPermissionCollection((PermissionCollection)excludedWebResourcePermissions);
        expectedExcludedPermissions.add((Permission)new WebResourcePermission("/excluded.jsp", "GET,POST"));
        TestUtil.logMsg((String)"verifying excluded policy statments:");
        verified = this.logProcessor.verifyLogImplies(expectedExcludedPermissions, excludedWebResourcePermissions);
        if (!verified) {
            throw new EETest.Fault("WebResourcePermission failed: excluded policy statements verification failed");
        }
        TestUtil.logMsg((String)"excluded policy statements verification successful");
        Permissions addToRoleWebResourcePermissions = this.logProcessor.getSpecificPermissions(this.addToRolePermissions, "WebResourcePermission");
        TestUtil.logMsg((String)"Server generated addToRole WebResourcePermissions");
        this.logProcessor.printPermissionCollection((PermissionCollection)addToRoleWebResourcePermissions);
        expectedAddToRolePermissions.add((Permission)new WebResourcePermission("/secured.jsp", "GET,POST"));
        expectedAddToRolePermissions.add((Permission)new WebResourcePermission("/sslprotected.jsp", "GET,POST"));
        expectedAddToRolePermissions.add((Permission)new WebResourcePermission("/anyauthuser.jsp", "GET,POST"));
        TestUtil.logMsg((String)"verifying addToRole policy statments:");
        verified = this.logProcessor.verifyLogImplies(expectedAddToRolePermissions, addToRoleWebResourcePermissions);
        if (!verified) {
            throw new EETest.Fault("WebResourcePermission failed: addToRole policy statements verification failed");
        }
        TestUtil.logMsg((String)"addToRole policy statements verification successful");
    }

    public void WebRoleRefPermission() throws EETest.Fault {
        boolean verified = false;
        Permissions expectedAddToRolePermissions = new Permissions();
        Permissions addToRoleWebRoleRefPermissions = this.logProcessor.getSpecificPermissions(this.addToRolePermissions, "WebRoleRefPermission");
        TestUtil.logMsg((String)"Server generated addToRole WebRoleRefPermissions");
        this.logProcessor.printPermissionCollection((PermissionCollection)addToRoleWebRoleRefPermissions);
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("secured", "ADM"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("secured", "Administrator"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("secured", "Manager"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("secured", "Employee"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("sslprotected", "MGR"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("sslprotected", "ADM"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("sslprotected", "Administrator"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("sslprotected", "Manager"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("sslprotected", "Employee"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("unchecked", "Manager"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("unchecked", "Administrator"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("unchecked", "Employee"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("excluded", "Manager"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("excluded", "Administrator"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("excluded", "Employee"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("anyauthuser", "Employee"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("anyauthuser", "Manager"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("anyauthuser", "Administrator"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("", "Administrator"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("", "Manager"));
        expectedAddToRolePermissions.add((Permission)new WebRoleRefPermission("", "Employee"));
        TestUtil.logMsg((String)"verifying addToRole policy statments:");
        verified = this.logProcessor.verifyLogImplies(expectedAddToRolePermissions, addToRoleWebRoleRefPermissions);
        if (!verified) {
            throw new EETest.Fault("WebRoleRefPermission failed: addToRole policy statements verification failed");
        }
        TestUtil.logMsg((String)"addToRole policy statements verification successful");
    }

    public void AnyAuthUserWebRoleRef() throws EETest.Fault {
        boolean verified = false;
        Permissions expectedAddToRolePerms = new Permissions();
        Permissions addToRoleWebRoleRefPermissions = this.logProcessor.getSpecificPermissions(this.addToRolePermissions, "WebRoleRefPermission");
        TestUtil.logMsg((String)"Server generated addToRole WebRoleRefPermissions");
        this.logProcessor.printPermissionCollection((PermissionCollection)addToRoleWebRoleRefPermissions);
        expectedAddToRolePerms.add((Permission)new WebRoleRefPermission("excluded", "**"));
        expectedAddToRolePerms.add((Permission)new WebRoleRefPermission("unchecked", "**"));
        expectedAddToRolePerms.add((Permission)new WebRoleRefPermission("sslprotected", "**"));
        expectedAddToRolePerms.add((Permission)new WebRoleRefPermission("secured", "**"));
        expectedAddToRolePerms.add((Permission)new WebRoleRefPermission("anyauthuser", "**"));
        TestUtil.logMsg((String)"verifying addToRole policy statments:");
        verified = this.logProcessor.verifyLogImplies(expectedAddToRolePerms, addToRoleWebRoleRefPermissions);
        if (!verified) {
            throw new EETest.Fault("AnyAuthUserWebRoleRef failed: addToRole policy statements for any-authenticated-user (**) failed");
        }
        TestUtil.logMsg((String)"addToRole policy statements verification successful");
    }

    public void WebResourcePermissionExcludedPolicy() throws EETest.Fault {
        boolean verified = false;
        Permissions expectedExcludedPermissions = new Permissions();
        Permissions excludedWebResourcePermissions = this.logProcessor.getSpecificPermissions(this.excludedPermissions, "WebResourcePermission");
        TestUtil.logMsg((String)"Server generated excluded WebResourcePermissions");
        this.logProcessor.printPermissionCollection((PermissionCollection)excludedWebResourcePermissions);
        expectedExcludedPermissions.add((Permission)new WebResourcePermission("/excluded.jsp", "GET,POST"));
        TestUtil.logMsg((String)"verifying excluded policy statments:");
        verified = this.logProcessor.verifyLogImplies(expectedExcludedPermissions, excludedWebResourcePermissions);
        if (!verified) {
            throw new EETest.Fault("WebResourcePermissionExcludedPolicy failed: excluded policy statements verification failed");
        }
        TestUtil.logMsg((String)"excluded policy statements verification successful");
    }

    public void WebResourcePermissionUnCheckedPolicy() throws EETest.Fault {
        Permissions expectedPermissions = new Permissions();
        boolean verified = false;
        Permissions uncheckedWebResourcePermissions = this.logProcessor.getSpecificPermissions(this.unCheckedPermissions, "WebResourcePermission");
        TestUtil.logMsg((String)"Server generated unchecked WebResourcePermissions");
        this.logProcessor.printPermissionCollection((PermissionCollection)uncheckedWebResourcePermissions);
        expectedPermissions.add((Permission)new WebResourcePermission("/unchecked.jsp", (String)null));
        expectedPermissions.add((Permission)new WebResourcePermission("/sslprotected.jsp", "!GET,POST"));
        expectedPermissions.add((Permission)new WebResourcePermission("/:/secured.jsp:/unchecked.jsp:/excluded.jsp:/sslprotected.jsp:/anyauthuser.jsp", (String)null));
        expectedPermissions.add((Permission)new WebResourcePermission("/excluded.jsp", "!GET,POST"));
        expectedPermissions.add((Permission)new WebResourcePermission("/secured.jsp", "!GET,POST"));
        expectedPermissions.add((Permission)new WebResourcePermission("/anyauthuser.jsp", "!GET,POST"));
        verified = this.logProcessor.verifyLogImplies(expectedPermissions, uncheckedWebResourcePermissions);
        if (!verified) {
            throw new EETest.Fault("WebResourcePermissionUnCheckedPolicy failed");
        }
        TestUtil.logMsg((String)"WebResourcePermission constructed correctly with unchecked policy statements");
    }

    public void WebUserDataPermission() throws EETest.Fault {
        boolean verified = false;
        Permissions expectedUnCheckedPermissions = new Permissions();
        Permissions expectedExcludedPermissions = new Permissions();
        Permissions uncheckedWebUserDataPermissions = this.logProcessor.getSpecificPermissions(this.unCheckedPermissions, "WebUserDataPermission");
        TestUtil.logMsg((String)"Server generated unchecked WebUserDataPermissions");
        this.logProcessor.printPermissionCollection((PermissionCollection)uncheckedWebUserDataPermissions);
        expectedUnCheckedPermissions.add((Permission)new WebUserDataPermission("/sslprotected.jsp", "GET,POST:CONFIDENTIAL"));
        expectedUnCheckedPermissions.add((Permission)new WebUserDataPermission("/excluded.jsp", "!GET,POST"));
        expectedUnCheckedPermissions.add((Permission)new WebUserDataPermission("/sslprotected.jsp", "!GET,POST"));
        expectedUnCheckedPermissions.add((Permission)new WebUserDataPermission("/secured.jsp", (String)null));
        expectedUnCheckedPermissions.add((Permission)new WebUserDataPermission("/anyauthuser.jsp", "!GET,POST"));
        expectedUnCheckedPermissions.add((Permission)new WebUserDataPermission("/:/unchecked.jsp:/secured.jsp:/sslprotected.jsp:/excluded.jsp:/anyauthuser.jsp", (String)null));
        expectedUnCheckedPermissions.add((Permission)new WebUserDataPermission("/unchecked.jsp", (String)null));
        TestUtil.logMsg((String)"verifying unchecked policy statments:");
        verified = this.logProcessor.verifyLogImplies(expectedUnCheckedPermissions, uncheckedWebUserDataPermissions);
        if (!verified) {
            throw new EETest.Fault("WebUserDataPermission failed: unchecked policy statements verification failed");
        }
        TestUtil.logMsg((String)"unchecked policy statements verification successful");
        Permissions excludedWebUserDataPermissions = this.logProcessor.getSpecificPermissions(this.excludedPermissions, "WebUserDataPermission");
        TestUtil.logMsg((String)"Server generated excluded WebUserDataPermission");
        this.logProcessor.printPermissionCollection((PermissionCollection)excludedWebUserDataPermissions);
        expectedExcludedPermissions.add((Permission)new WebUserDataPermission("/excluded.jsp", "GET,POST"));
        TestUtil.logMsg((String)"verifying excluded policy statments:");
        verified = this.logProcessor.verifyLogImplies(expectedExcludedPermissions, excludedWebUserDataPermissions);
        if (!verified) {
            throw new EETest.Fault("WebUserDataPermission failed: excluded policy statements verification failed");
        }
        TestUtil.logMsg((String)"excluded policy statements verification successful");
    }

    public void WebResourcePermissionEquals() throws EETest.Fault {
        boolean verified = false;
        String[] tempArgs = new String[]{"WebResourcePermission.equals() : PASSED"};
        verified = this.logProcessor.verifyLogContains(tempArgs);
        if (!verified) {
            throw new EETest.Fault("WebResourcePermissionEquals : FAILED");
        }
        TestUtil.logMsg((String)"WebResourcePermissionEquals : PASSED");
    }

    public void WebRoleRefPermissionEquals() throws EETest.Fault {
        boolean verified = false;
        String[] tempArgs = new String[]{"WebRoleRefPermission.equals() : PASSED"};
        verified = this.logProcessor.verifyLogContains(tempArgs);
        if (!verified) {
            throw new EETest.Fault("WebRoleRefPermissionEquals : FAILED");
        }
        TestUtil.logMsg((String)"WebRoleRefPermissionEquals : PASSED");
    }

    public void WebUserDataPermissionEquals() throws EETest.Fault {
        boolean verified = false;
        String[] tempArgs = new String[]{"WebUserDataPermission.equals() : PASSED"};
        verified = this.logProcessor.verifyLogContains(tempArgs);
        if (!verified) {
            throw new EETest.Fault("WebUserDataPermissionEquals : FAILED");
        }
        TestUtil.logMsg((String)"WebUserDataPermissionEquals : PASSED");
    }

    public void WebResourcePermissionHashCode() throws EETest.Fault {
        boolean verified = false;
        String[] tempArgs = new String[]{"WebResourcePermission.hashCode() : PASSED"};
        verified = this.logProcessor.verifyLogContains(tempArgs);
        if (!verified) {
            throw new EETest.Fault("WebResourcePermissionHashCode : FAILED");
        }
        TestUtil.logMsg((String)"WebResourcePermissionHashCode : PASSED");
    }

    public void WebRoleRefPermissionHashCode() throws EETest.Fault {
        boolean verified = false;
        String[] tempArgs = new String[]{"WebRoleRefPermission.hashCode() : PASSED"};
        verified = this.logProcessor.verifyLogContains(tempArgs);
        if (!verified) {
            throw new EETest.Fault("WebRoleRefPermissionHashCode : FAILED");
        }
        TestUtil.logMsg((String)"WebRoleRefPermissionHashCode : PASSED");
    }

    public void WebUserDataPermissionHashCode() throws EETest.Fault {
        boolean verified = false;
        String[] tempArgs = new String[]{"WebUserDataPermission.hashCode() : PASSED"};
        verified = this.logProcessor.verifyLogContains(tempArgs);
        if (!verified) {
            throw new EETest.Fault("WebUserDataPermissionHashCode : FAILED");
        }
        TestUtil.logMsg((String)"WebUserDataPermissionHashCode : PASSED");
    }

    public void PolicyConfigurationFactory() throws EETest.Fault {
        boolean verified = false;
        String[] args = new String[]{"PolicyConfigurationFactory instantiated"};
        verified = this.logProcessor.verifyLogContains(args);
        if (!verified) {
            throw new EETest.Fault("PolicyConfigurationFactory failed : PolicyconfigurationFactory not instantiated");
        }
        TestUtil.logMsg((String)"PolicyConfigurationFactory() instantiated");
    }

    public void GetPolicyConfiguration() throws EETest.Fault {
        boolean verified = false;
        String[] args = new String[]{"PolicyConfigurationFactory.getPolicyConfiguration() invoked"};
        verified = this.logProcessor.verifyLogContains(args);
        if (!verified) {
            throw new EETest.Fault("GetPolicyConfiguration failed : getPolicyconfiguration() was not invoked");
        }
        TestUtil.logMsg((String)"PolicyConfigurationFactory.getPolicyConfiguration() invoked");
    }

    public void validateNoInvalidStates() throws EETest.Fault {
        boolean verified = false;
        String[] args1 = new String[]{"ERROR - our policy config should not be in the INSERVICE state."};
        String[] args2 = new String[]{"ERROR - our policy config should be in the INSERVICE state."};
        verified = this.logProcessor.verifyLogContains(args1);
        if (verified) {
            throw new EETest.Fault("validateNoInvalidStates failed : detected error message of: " + args1[0]);
        }
        TestUtil.logMsg((String)"validateNoInvalidStates() passed.");
        verified = this.logProcessor.verifyLogContains(args2);
        if (verified) {
            throw new EETest.Fault("validateNoInvalidStates failed : detected error message of: " + args2[0]);
        }
        TestUtil.logMsg((String)"validateNoInvalidStates() passed.");
    }

    public void PolicyRefresh() throws EETest.Fault {
        boolean verified = false;
        String[] tempArgs = new String[]{"TSPolicy.refresh() invoked"};
        verified = this.logProcessor.verifyLogContains(tempArgs);
        if (!verified) {
            throw new EETest.Fault("PolicyRefresh() failed");
        }
        TestUtil.logMsg((String)"TSPolicy.refresh() invoked");
    }

    public void Policy() throws EETest.Fault {
        boolean verified = false;
        String[] args = new String[]{"TSPolicy.refresh() invoked"};
        verified = this.logProcessor.verifyLogContains(args);
        if (!verified) {
            throw new EETest.Fault("TestName: Policy failed : Policy replacement algorithm not used");
        }
        TestUtil.logMsg((String)"System Policy loaded based on system properties");
    }
}

