/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.embeddableMapValue;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.embeddableMapValue.Address;
import com.sun.ts.tests.jpa.core.annotations.embeddableMapValue.Employee;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void embeddableMapValue() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin embeddableMapValue");
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        EntityManager em = this.getEntityManager();
        EntityTransaction et = this.getEntityTransaction();
        try {
            TestUtil.logTrace((String)"New instances");
            Address addr1 = new Address("1", "1 Network Drive", "Burlington", "MA", "01801");
            Address addr2 = new Address("2", "Some Address", "Boston", "MA", "01803");
            Employee emp1 = new Employee(1, "Barack", "Obama");
            HashMap<String, Address> locationAddressMap = new HashMap<String, Address>();
            locationAddressMap.put("home", addr2);
            locationAddressMap.put("office", addr1);
            emp1.setLocationAddress(locationAddressMap);
            TestUtil.logTrace((String)"Created new Employee");
            et.begin();
            em.persist((Object)emp1);
            TestUtil.logTrace((String)"persisted new Employee");
            em.flush();
            this.clearCache();
            TestUtil.logTrace((String)"query for Employee");
            Employee newEmployee = (Employee)em.find(Employee.class, (Object)1);
            int newEmployeeId = newEmployee.getId();
            String newEmployeeFirstName = newEmployee.getFirstName();
            String newEmployeeLastName = newEmployee.getLastName();
            TestUtil.logTrace((String)("Employee Id = " + newEmployeeId));
            TestUtil.logTrace((String)("Employee First Name = " + newEmployeeFirstName));
            TestUtil.logTrace((String)("Employee Last Name = " + newEmployeeLastName));
            if (newEmployeeId == 1) {
                pass1 = true;
                TestUtil.logTrace((String)"Employee Id match");
            }
            if (newEmployeeFirstName.equals("Barack")) {
                TestUtil.logTrace((String)"Employee First Name match");
                pass2 = true;
            }
            if (newEmployeeLastName.equals("Obama")) {
                TestUtil.logTrace((String)"Employee Last Name match");
                pass3 = true;
            }
            Map newLocationAddressMap = newEmployee.getLocationAddress();
            Address homeAddress = (Address)newLocationAddressMap.get("home");
            Address officeAddress = (Address)newLocationAddressMap.get("office");
            if (officeAddress.getStreet().equals("1 Network Drive") && officeAddress.getCity().equals("Burlington") && officeAddress.getState().equals("MA") && officeAddress.getZip().equals("01801")) {
                pass4 = true;
                TestUtil.logTrace((String)"Employee officeAddress match");
            }
            if (homeAddress.getStreet().equals("Some Address") && homeAddress.getCity().equals("Boston") && homeAddress.getState().equals("MA") && homeAddress.getZip().equals("01803")) {
                pass5 = true;
                TestUtil.logTrace((String)"Employee HomeAddress match");
            }
            et.commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception :", (Throwable)e);
        }
        finally {
            try {
                if (et.isActive()) {
                    et.rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            TestUtil.logErr((String)"embeddableMapValue failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from COLTAB_EMP_EMBEDED_ADDRESS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE_EMBEDED_ADDRESS").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

