/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.javamail.ee.mimemessage;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.javamail.ee.common.MailTestUtil;
import com.sun.ts.tests.javamail.ee.mimemessage.MyMimeMessage;
import com.sun.ts.tests.javamail.ee.mimemessage.MyReplyMimeMessage;
import jakarta.mail.Address;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;

public class mimemessage_Test
extends ServiceEETest
implements Serializable {
    private String mailTo = null;
    private int errors = 0;
    private transient MailTestUtil mailTestUtil;
    private transient Session session;
    private Folder folder;
    private Message[] msgs;
    private Store store;
    private transient Status status;
    private String user;
    private String[] addrlist = new String[]{"ksnijjar@eng", "ksnijjar@eng.sun.com", "French@physicists", "cannot@waste", "us/@mhs-mci.ebay", "it@is", "tower@ihug.co.nz", "root@mxrelay.lanminds.com", "javaworld", "xx.zzz12@fea.net", "javamail-api-eng@icdev", "ksnijjar@java-test.Eng.Sun.COM"};

    public static void main(String[] args) {
        mimemessage_Test theTests = new mimemessage_Test();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        try {
            String protocol = TestUtil.getProperty((String)"javamail.protocol");
            String host = TestUtil.getProperty((String)"javamail.server");
            this.user = TestUtil.getProperty((String)"javamail.username");
            String password = TestUtil.getProperty((String)"javamail.password");
            String mailbox = TestUtil.getProperty((String)"javamail.mailbox");
            String smtpPortStr = TestUtil.getProperty((String)"smtp.port");
            int smtpPort = Integer.parseInt(smtpPortStr);
            TestUtil.logTrace((String)("SMTP Port = " + smtpPort));
            String imapPortStr = TestUtil.getProperty((String)"imap.port");
            int imapPort = Integer.parseInt(imapPortStr);
            TestUtil.logTrace((String)("IMAP Port = " + imapPort));
            MailTestUtil mailTestUtil = new MailTestUtil();
            this.store = mailTestUtil.connect2host(protocol, host, imapPort, this.user, password);
            this.session = mailTestUtil.getSession();
            Folder root = mailTestUtil.getRootFolder(this.store);
            this.folder = root.getFolder(mailbox);
            if (this.folder == null) {
                throw new EETest.Fault("Invalid folder object!");
            }
            this.folder.open(1);
            this.msgs = this.folder.getMessages();
        }
        catch (Exception e) {
            this.logErr("Exception : " + e.getMessage());
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testSetContent1() throws EETest.Fault {
        try {
            MimeMessage mob = new MimeMessage(this.session);
            if (mob == null) {
                throw new EETest.Fault("Warning: Failed to create a MimeMessage object!");
            }
            MimeMultipart mmp = new MimeMultipart();
            if (mmp == null) {
                throw new EETest.Fault("Warning: Failed to create a Multipart object!");
            }
            TestUtil.logTrace((String)"UNIT TEST 1:  setContent(Multipart)");
            mob.setContent((Multipart)mmp);
            Object content = mob.getContent();
            if (content == null || !(content instanceof Multipart)) {
                TestUtil.logTrace((String)"UNIT TEST 1:  FAILED\n");
                throw new EETest.Fault("testSetContent1 failed\n");
            }
            TestUtil.logTrace((String)"This is a Multipart");
            Multipart mp1 = (Multipart)content;
            int count = mp1.getCount();
            TestUtil.logTrace((String)"UNIT TEST 1:  passed\n");
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Call to testSetContent1() Failed!", e);
        }
    }

    public void testSetContent2() throws EETest.Fault {
        block5: {
            String msgText = "testing 1,2,3 ...";
            try {
                MimeMessage msg = new MimeMessage(this.session);
                if (msg == null) {
                    throw new EETest.Fault("WARNING: Failed to create a message object!");
                }
                InternetAddress addr = new InternetAddress(this.user);
                if (addr == null) {
                    throw new EETest.Fault("WARNING: Failed to create a InternetAddress object!");
                }
                InternetAddress[] addrs = new InternetAddress[]{addr};
                msg.setFrom((Address)addr);
                msg.setRecipients(Message.RecipientType.TO, (Address[])addrs);
                msg.setSubject("testSetContent2()" + new Date());
                msg.setContent((Object)msgText, "text/plain");
                String content = msg.getContentType();
                TestUtil.logTrace((String)("content is " + content.toString()));
                if (content == null || !(content instanceof String)) break block5;
                if (content.equals("text/plain")) {
                    TestUtil.logTrace((String)"UNIT TEST 1:  passed\n");
                    break block5;
                }
                TestUtil.logTrace((String)"UNIT TEST 1:  FAILED\n");
                throw new EETest.Fault("testSetContent2() failed\n");
            }
            catch (Exception e) {
                this.logErr("Unexpected Exception " + e.getMessage());
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("Call to testSetContent2() Failed!", e);
            }
        }
    }

    public void getSession_Test() throws EETest.Fault {
        TestUtil.logMsg((String)"\nTesting class Message: getSession()\n");
        try {
            MimeMessage msg = new MimeMessage(this.session);
            TestUtil.logMsg((String)"UNIT TEST 1:  getSession()");
            Session sess = msg.getSession();
            if (sess == this.session) {
                TestUtil.logMsg((String)"UNIT TEST 1:  passed\n");
            } else {
                TestUtil.logMsg((String)("got Session: " + sess));
                TestUtil.logMsg((String)"UNIT TEST 1:  Failed\n");
                ++this.errors;
            }
            msg = new MimeMessage((Session)null);
            TestUtil.logMsg((String)"UNIT TEST 2:  getSession() null");
            sess = msg.getSession();
            if (sess == null) {
                TestUtil.logMsg((String)"UNIT TEST 2:  passed\n");
            } else {
                TestUtil.logMsg((String)("got Session: " + sess));
                TestUtil.logMsg((String)"UNIT TEST 2:  Failed\n");
                ++this.errors;
            }
            this.checkStatus();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("getSession_Test Failed!", e);
        }
    }

    public void createMimeMessage_Test() throws EETest.Fault {
        try {
            MyMimeMessage msg = new MyMimeMessage(this.session);
            TestUtil.logMsg((String)"UNIT TEST 1: createMimeMessage");
            Message replyMsg = msg.reply(false);
            if (replyMsg instanceof MyReplyMimeMessage) {
                TestUtil.logMsg((String)"UNIT TEST 1: passed\n");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 1: FAILED\n");
                ++this.errors;
            }
            this.checkStatus();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("createMimeMessage_Test Failed!", e);
        }
    }

    public void reply_Test() throws EETest.Fault {
        try {
            InternetAddress from = new InternetAddress("joe@example.com");
            InternetAddress to = new InternetAddress("bob@example.com");
            String subj = "test";
            MimeMessage msg = new MimeMessage(this.session);
            msg.setFrom((Address)from);
            msg.setRecipient(Message.RecipientType.TO, (Address)to);
            msg.setSubject(subj);
            msg.setText("test");
            TestUtil.logMsg((String)"UNIT TEST 1: reply(false)");
            Message replyMsg = msg.reply(false);
            Address[] addrs = replyMsg.getRecipients(Message.RecipientType.TO);
            if (addrs != null && addrs.length == 1 && addrs[0].equals((Object)from) && replyMsg.getSubject().equals("Re: " + subj) && msg.isSet(Flags.Flag.ANSWERED)) {
                TestUtil.logMsg((String)"UNIT TEST 1: passed\n");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 1: FAILED\n");
                ++this.errors;
            }
            TestUtil.logMsg((String)"UNIT TEST 2: reply(true)");
            replyMsg = msg.reply(true);
            addrs = replyMsg.getRecipients(Message.RecipientType.TO);
            if (addrs != null && addrs.length == 2 && (addrs[0].equals((Object)from) && addrs[1].equals((Object)to) || addrs[0].equals((Object)to) && addrs[1].equals((Object)from))) {
                TestUtil.logMsg((String)"UNIT TEST 2: passed\n");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 2: FAILED\n");
                ++this.errors;
            }
            TestUtil.logMsg((String)"UNIT TEST 3: reply(false, false)");
            msg = new MimeMessage(this.session);
            msg.setFrom((Address)from);
            msg.setRecipient(Message.RecipientType.TO, (Address)to);
            msg.setSubject(subj);
            msg.setText("test");
            replyMsg = msg.reply(false, false);
            addrs = replyMsg.getRecipients(Message.RecipientType.TO);
            if (addrs != null && addrs.length == 1 && addrs[0].equals((Object)from) && replyMsg.getSubject().equals("Re: " + subj) && !msg.isSet(Flags.Flag.ANSWERED)) {
                TestUtil.logMsg((String)"UNIT TEST 3: passed\n");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 3: FAILED\n");
                ++this.errors;
            }
            this.checkStatus();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("reply_Test Failed!", e);
        }
    }

    public void setFrom_Test() throws EETest.Fault {
        TestUtil.logMsg((String)"\nTesting class MimeMessage: setFrom(String)\n");
        try {
            int i;
            MimeMessage msg = new MimeMessage(this.session);
            for (i = 0; i < this.addrlist.length; ++i) {
                InternetAddress addr = new InternetAddress(this.addrlist[i]);
                TestUtil.logMsg((String)("UNIT TEST " + (i + 1) + ":  setFrom(String)"));
                msg.setFrom(this.addrlist[i]);
                Address[] nowfrom = msg.getFrom();
                String newFrom = nowfrom[0].toString();
                if (newFrom != null) {
                    if (this.addrlist[i].equals(newFrom)) {
                        TestUtil.logMsg((String)("setFrom(" + this.addrlist[i] + ")"));
                        TestUtil.logMsg((String)("UNIT TEST " + (i + 1) + ":  passed\n"));
                        continue;
                    }
                    TestUtil.logMsg((String)("getFrom() :=> " + newFrom));
                    TestUtil.logMsg((String)("setFrom(" + this.addrlist[i] + ")"));
                    TestUtil.logMsg((String)("UNIT TEST " + (i + 1) + ":  FAILED\n"));
                    ++this.errors;
                    continue;
                }
                TestUtil.logMsg((String)("WARNING: Message " + (i + 1) + " has null 'From' header"));
                TestUtil.logMsg((String)("UNIT TEST " + (i + 1) + ":  FAILED\n"));
                ++this.errors;
            }
            TestUtil.logMsg((String)("UNIT TEST " + (i + 1) + ":  setFrom(String)"));
            String addr1 = "joe@example.com";
            String addr2 = "bob@example.com";
            msg.setFrom(addr1 + "," + addr2);
            Address[] afrom = msg.getFrom();
            if (afrom != null && afrom.length == 2 && (afrom[0].toString().equals(addr1) && afrom[1].toString().equals(addr2) || afrom[0].toString().equals(addr2) && afrom[1].toString().equals(addr1))) {
                TestUtil.logMsg((String)("setFrom(" + addr1 + "," + addr2 + ")"));
                TestUtil.logMsg((String)("UNIT TEST " + (i + 1) + ":  passed\n"));
            } else {
                TestUtil.logMsg((String)("setFrom(" + addr1 + "," + addr2 + ")"));
                TestUtil.logMsg((String)("UNIT TEST " + (i + 1) + ":  FAILED\n"));
                ++this.errors;
            }
            this.checkStatus();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("reply_Test Failed!", e);
        }
    }

    public void checkStatus() {
        this.status = this.errors == 0 ? Status.passed((String)"OKAY") : Status.failed((String)"");
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("Cleanup ;");
            if (this.store != null) {
                this.store = null;
            }
            if (this.session != null) {
                this.session = null;
            }
        }
        catch (Exception e) {
            this.logErr("An error occurred in cleanup!", e);
        }
    }
}

