/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex6b;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.derivedid.ex6b.DID6bMedicalHistory;
import com.sun.ts.tests.jpa.core.derivedid.ex6b.DID6bPerson;
import com.sun.ts.tests.jpa.core.derivedid.ex6b.DID6bPersonId;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void DIDTest() throws EETest.Fault {
        boolean pass = false;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            DID6bPersonId personId = new DID6bPersonId("Java", "DUKE");
            DID6bPerson person = new DID6bPerson(personId, "123456789");
            DID6bMedicalHistory mHistory = new DID6bMedicalHistory(personId, person, "drFoo");
            this.getEntityManager().persist((Object)person);
            this.getEntityManager().persist((Object)mHistory);
            TestUtil.logTrace((String)"persisted Patient and MedicalHistory");
            this.getEntityManager().flush();
            DID6bMedicalHistory newMHistory = (DID6bMedicalHistory)this.getEntityManager().find(DID6bMedicalHistory.class, (Object)personId);
            if (newMHistory != null) {
                this.getEntityManager().refresh((Object)newMHistory);
            }
            List depList = this.getEntityManager().createQuery("Select m from DID6bMedicalHistory m where m.patient.id.firstName='Java'").getResultList();
            newMHistory = null;
            if (depList.size() > 0) {
                newMHistory = (DID6bMedicalHistory)depList.get(0);
                if (newMHistory.getPatient() == person) {
                    pass1 = true;
                    TestUtil.logTrace((String)"Received Expected Patient");
                } else {
                    TestUtil.logErr((String)"Searched Patient not found");
                }
            }
            List depList2 = this.getEntityManager().createQuery("Select m from DID6bMedicalHistory m where m.id.firstName='Java'").getResultList();
            DID6bMedicalHistory newMHistory2 = null;
            if (depList2.size() > 0) {
                newMHistory2 = (DID6bMedicalHistory)depList.get(0);
                if (newMHistory2 != null) {
                    if (newMHistory2.getPatient() == person) {
                        pass = true;
                        TestUtil.logTrace((String)"Received Expected Patient");
                    } else {
                        TestUtil.logErr((String)"Searched Patient not found");
                    }
                } else {
                    TestUtil.logErr((String)"getEntityManager().createQuery returned null entry");
                }
            } else {
                TestUtil.logErr((String)"getEntityManager().createQuery returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            this.getEntityManager().getTransaction().rollback();
        }
        if (pass1 & pass2) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault("DIDTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID6BMEDICALHISTORY").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID6BPERSON").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

