/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.sec.stateful.mdb;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.sec.stateful.mdb.MDB_SND_Test;
import com.sun.ts.tests.ejb.ee.sec.stateful.mdb.MDB_SND_TestHome;
import java.util.Properties;

public class MDBClient
extends EETest {
    private TSLoginContext lc = null;
    private String username = "";
    private String password = "";
    private TSNamingContextInterface context = null;
    private MDB_SND_Test hr = null;
    private MDB_SND_TestHome home = null;
    private Properties props = null;

    public static void main(String[] args) {
        MDBClient theTests = new MDBClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            TestUtil.logTrace((String)"in client setup");
            this.context = new TSNamingContext();
            this.username = this.props.getProperty("authuser");
            this.password = this.props.getProperty("authpassword");
            this.lc = new TSLoginContext();
            this.lc.login(this.username, this.password);
            this.home = (MDB_SND_TestHome)this.context.lookup("java:comp/env/ejb/MDB_SND_Test", MDB_SND_TestHome.class);
            this.hr = this.home.create(this.props);
            TestUtil.logTrace((String)"about to delete all destinations!");
            if (this.hr.isThereSomethingInTheQueue()) {
                TestUtil.logTrace((String)"Error: message(s) left in Q");
                this.hr.cleanTheQueue();
            } else {
                TestUtil.logTrace((String)"Nothing left in queue");
            }
            this.logMsg("Setup ok;");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup Failed!", e);
        }
    }

    public void test1() throws EETest.Fault {
        String messageType = "TextMessage";
        String matchMe = "TextMessageFromMsgBean";
        try {
            this.hr.askMDBToSendAMessage(messageType);
            if (!this.hr.checkOnResponse(matchMe)) {
                TestUtil.logTrace((String)"Error: didn't get expected response from mdb");
                throw new EETest.Fault("ERROR: Positive test failed");
            }
            TestUtil.logTrace((String)"Test passed!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
        finally {
            try {
                this.hr.askMDBToSendAMessage("ObjectMessage");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Exception removing stateful test bean", (Throwable)ee);
            }
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.hr.isThereSomethingInTheQueue()) {
                TestUtil.logTrace((String)"Error: message(s) left in Q");
                this.hr.cleanTheQueue();
            } else {
                TestUtil.logTrace((String)"Nothing left in queue");
            }
            if (this.hr != null) {
                TestUtil.logTrace((String)"Removing client stateful session bean");
                this.hr.remove();
            }
            this.logMsg("End  of client cleanup;");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }
}

