/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.tx.txEbeanLocal;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.tx.txEbeanLocal.AppException;
import com.sun.ts.tests.ejb.ee.tx.txEbeanLocal.SysException;
import jakarta.ejb.CreateException;
import jakarta.ejb.DuplicateKeyException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.FinderException;
import jakarta.ejb.NoSuchEntityException;
import jakarta.ejb.ObjectNotFoundException;
import jakarta.ejb.RemoveException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.sql.DataSource;

public class TxEBeanEJB
implements EntityBean {
    private EntityContext ectx = null;
    private TSNamingContext context = null;
    private DataSource ds1;
    private int key = 0;
    private String brand = null;
    private float price = 0.0f;
    private String tName = null;
    private String tName1 = null;
    public static final int FLAGAPPEXCEPTION = -1;
    public static final int FLAGAPPEXCEPTIONWITHROLLBACK = -2;
    public static final int FLAGSYSEXCEPTION = -3;
    public static final int FLAGREMOTEEXCEPTION = -4;
    public static final int FLAGEJBEXCEPTION = -5;
    public static final int FLAGERROR = -6;
    public static final int FLAGROLLBACK = -7;

    public TxEBeanEJB() {
        TestUtil.logTrace((String)"TxEBeanEJB no arg constructor");
    }

    public Integer ejbCreate(String tName, int key, String brand, float price, Properties p) throws CreateException, DuplicateKeyException, SQLException {
        TestUtil.logTrace((String)"ejbCreate");
        String newName = null;
        Connection con = null;
        Statement pStmt = null;
        Object findEJBkey = null;
        this.tName = tName;
        TestUtil.logTrace((String)("tName: " + this.tName));
        TestUtil.logTrace((String)("key: " + key));
        TestUtil.logTrace((String)("price: " + price));
        try {
            this.initLogging(p);
            if (key == 1) {
                this.createTableLayout();
            }
            if (this.keyExists(tName, key)) {
                TestUtil.logTrace((String)("key: " + key + " already exists"));
                throw new DuplicateKeyException();
            }
            con = this.getDBConnection();
            newName = this.tName + "-" + key;
            String updateString = TestUtil.getProperty((String)"TxEBean_updateString1");
            pStmt = con.prepareStatement(updateString);
            pStmt.setInt(1, key);
            pStmt.setString(2, newName);
            pStmt.setFloat(3, price);
            pStmt.executeUpdate();
            TestUtil.logMsg((String)"New row inserted into table");
            this.key = key;
            this.brand = newName;
            this.price = price;
        }
        catch (DuplicateKeyException de) {
            TestUtil.printStackTrace((Throwable)de);
            TestUtil.logTrace((String)"Caught DuplicateKeyException, rethrowing to client");
            throw new DuplicateKeyException();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception inserting a new row into table:" + this.tName), (Throwable)e);
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + this.tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
        return new Integer(key);
    }

    public void ejbPostCreate(String tName, int key, String brand, float price, Properties p) throws CreateException, SQLException {
        TestUtil.logTrace((String)"ejbPostCreate");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        Connection con = null;
        Statement pStmt = null;
        try {
            con = this.getDBConnection();
            String updateString = TestUtil.getProperty((String)"TxEBean_updateString2");
            pStmt = con.prepareStatement(updateString);
            int theRow = (Integer)this.ectx.getPrimaryKey();
            pStmt.setInt(1, theRow);
            pStmt.executeUpdate();
            TestUtil.logMsg((String)"Row deleted from table");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception deleting row from table: " + this.tName), (Throwable)e);
            throw new RemoveException(e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + this.tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    public Integer ejbFindtxEbean(String tName, Integer key, Properties p) throws FinderException, ObjectNotFoundException {
        block12: {
            TestUtil.logTrace((String)"ejbFindtxEbean");
            Connection con = null;
            Statement pStmt = null;
            ResultSet rs = null;
            this.tName = tName;
            try {
                this.initLogging(p);
                con = this.getDBConnection();
                String selectString = TestUtil.getProperty((String)"TxEBean_selectString1");
                pStmt = con.prepareStatement(selectString);
                pStmt.setInt(1, key);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    TestUtil.logTrace((String)("ejbFindtxEbean for Row key: " + key.toString() + " successfully located"));
                    break block12;
                }
                TestUtil.logErr((String)("ejbFindtxEbean could not find Row key: " + key.toString()));
                throw new ObjectNotFoundException("ejbFindtxEbean could not find Row key: " + key.toString());
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception finding primary key: " + key.toString()), (Throwable)e);
                throw new ObjectNotFoundException(e.getMessage());
            }
            finally {
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException se) {
                    TestUtil.logErr((String)("SQLException closing db connection for " + this.tName), (Throwable)se);
                    throw new EJBException(se.getMessage());
                }
            }
        }
        return key;
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException, ObjectNotFoundException {
        block12: {
            TestUtil.logTrace((String)"ejbFindByPrimaryKey");
            Connection con = null;
            Statement pStmt = null;
            ResultSet rs = null;
            try {
                con = this.getDBConnection();
                String selectString = TestUtil.getProperty((String)"TxEBean_selectString1");
                pStmt = con.prepareStatement(selectString);
                pStmt.setInt(1, key);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    TestUtil.logTrace((String)("ejbFindByPrimaryKey for Row key: " + key.toString() + " successfully located"));
                    break block12;
                }
                TestUtil.logErr((String)("ejbFindByPrimaryKey could not find Row key: " + key.toString()));
                throw new ObjectNotFoundException("ejbFindByPrimaryKey could not find Row key: " + key.toString());
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Exception finding primary key: " + key.toString()), (Throwable)e);
                throw new ObjectNotFoundException(e.getMessage());
            }
            finally {
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException se) {
                    TestUtil.logErr((String)("SQLException closing db connection for " + this.tName), (Throwable)se);
                    throw new EJBException(se.getMessage());
                }
            }
        }
        return key;
    }

    public Collection ejbFindByBrandName(String tName, String brandName, Properties p) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByBrandName");
        Connection con = null;
        Statement pStmt = null;
        ResultSet rs = null;
        int primaryKey = 0;
        this.tName = tName;
        try {
            this.initLogging(p);
            con = this.getDBConnection();
            String selectString = TestUtil.getProperty((String)"TxEBean_selectString2");
            pStmt = con.prepareStatement(selectString);
            pStmt.setString(1, brandName);
            rs = pStmt.executeQuery();
            if (!rs.next()) {
                TestUtil.logTrace((String)("No rows could be found matching brand name: " + brandName));
                throw new FinderException();
            }
            ArrayList<Integer> arrayOfKeys = new ArrayList<Integer>();
            while (rs.next()) {
                primaryKey = rs.getInt(1);
                arrayOfKeys.add(new Integer(primaryKey));
                TestUtil.logTrace((String)("EJB for brand: " + brandName + " successfully located"));
                TestUtil.logTrace((String)("Primary key located is: " + primaryKey));
            }
            ArrayList<Integer> arrayList = arrayOfKeys;
            return arrayList;
        }
        catch (FinderException fe) {
            TestUtil.printStackTrace((Throwable)fe);
            throw new FinderException("FinderException thrown from ejbFindByBrandName");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception finding EJB for brand name: " + brandName), (Throwable)e);
            throw new FinderException(e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + this.tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    public Collection ejbFindByPrice(String tName, float price, Properties p) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrice");
        Connection con = null;
        Statement pStmt = null;
        ResultSet rs = null;
        int primaryKey = 0;
        this.tName = tName;
        try {
            this.initLogging(p);
            con = this.getDBConnection();
            String selectString = TestUtil.getProperty((String)"TxEBean_selectString3");
            pStmt = con.prepareStatement(selectString);
            pStmt.setFloat(1, price);
            rs = pStmt.executeQuery();
            ArrayList<Integer> arrayOfKeys = new ArrayList<Integer>();
            while (rs.next()) {
                primaryKey = rs.getInt(1);
                arrayOfKeys.add(new Integer(primaryKey));
                TestUtil.logTrace((String)("EJB for price: " + price + " successfully located"));
                TestUtil.logTrace((String)("Primary key located is: " + primaryKey));
            }
            ArrayList<Integer> arrayList = arrayOfKeys;
            return arrayList;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception finding EJB for price: " + price), (Throwable)e);
            throw new FinderException(e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + this.tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    public void setEntityContext(EntityContext ec) {
        TestUtil.logTrace((String)"setEntityContext");
        try {
            this.ectx = ec;
            this.context = new TSNamingContext();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception setting EJB context/DataSources", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbLoad() throws NoSuchEntityException {
        TestUtil.logTrace((String)"ejbLoad");
        Connection con = null;
        Statement pStmt = null;
        ResultSet rs = null;
        try {
            TestUtil.logTrace((String)"Checking for Entity Object");
            int theRow = (Integer)this.ectx.getPrimaryKey();
            TestUtil.logTrace((String)("Row: " + theRow));
            TestUtil.logTrace((String)("tName: " + this.tName));
            if (!this.keyExists(this.tName, theRow)) {
                TestUtil.logTrace((String)("Row: " + theRow + " does not exist"));
                throw new NoSuchEntityException();
            }
            TestUtil.logTrace((String)("Row " + theRow + " exists"));
            con = this.getDBConnection();
            String selectString = TestUtil.getProperty((String)"TxEBean_selectString4");
            pStmt = con.prepareStatement(selectString);
            theRow = (Integer)this.ectx.getPrimaryKey();
            pStmt.setInt(1, theRow);
            rs = pStmt.executeQuery();
            TestUtil.logTrace((String)"Updating the EJB instance data via ejbLoad()");
            if (!rs.next()) {
                throw new EJBException("ejbLoad failed: Row key " + this.key + " not found");
            }
            this.key = rs.getInt(1);
            this.brand = rs.getString(2);
            this.price = rs.getFloat(3);
            TestUtil.logTrace((String)("ejbLoad() successfully located Row key " + this.key + " and updated the EJB instance data!"));
        }
        catch (NoSuchEntityException ne) {
            TestUtil.printStackTrace((Throwable)ne);
            throw new NoSuchEntityException("NoSuchEntityException from ejbLoad()");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception from ejbLoad for row: " + this.key), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + this.tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
        Connection con = null;
        Statement pStmt = null;
        try {
            con = this.getDBConnection();
            String updateString = TestUtil.getProperty((String)"TxEBean_updateString3");
            pStmt = con.prepareStatement(updateString);
            int theRow = (Integer)this.ectx.getPrimaryKey();
            pStmt.setString(1, this.brand);
            pStmt.setFloat(2, this.price);
            pStmt.setInt(3, theRow);
            pStmt.executeUpdate();
            TestUtil.logTrace((String)("ejbStore() successfully located Row key " + this.key + " and updated the database with the EJB instance data!"));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception from ejbStore for row: " + this.key), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + this.tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
        try {
            this.context = new TSNamingContext();
            this.ds1 = (DataSource)this.context.lookup("java:comp/env/jdbc/DB1");
            TestUtil.logTrace((String)("ds1: " + this.ds1));
            TestUtil.logTrace((String)"DataSource1 lookup OK!");
            this.tName = this.tName1 = TestUtil.getTableName((String)TestUtil.getProperty((String)"TxEBean_Delete"));
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception setting EJB context/DataSources", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public String getBrandName() {
        TestUtil.logTrace((String)"getBrandName");
        return this.brand;
    }

    public float getPrice() {
        TestUtil.logTrace((String)"getPrice");
        return this.price;
    }

    public String getDbBrandName() {
        TestUtil.logTrace((String)"getDbBrandName");
        Connection con = null;
        Statement pStmt = null;
        ResultSet rs = null;
        String dbBrandName = null;
        try {
            con = this.getDBConnection();
            String selectString = TestUtil.getProperty((String)"TxEBean_selectString5");
            pStmt = con.prepareStatement(selectString);
            int theRow = (Integer)this.ectx.getPrimaryKey();
            pStmt.setInt(1, theRow);
            rs = pStmt.executeQuery();
            TestUtil.logTrace((String)"Getting the Brand name value from the DB");
            if (!rs.next()) {
                throw new EJBException("getDbBrandName failed: Row key " + this.key + " not found");
            }
            dbBrandName = rs.getString(1);
            TestUtil.logTrace((String)("The DB Brand name is " + dbBrandName));
            TestUtil.logTrace((String)("getDbBrandName successfully located Row key " + this.key + " and obtained the database Brand name data!"));
            String string = dbBrandName;
            return string;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception from getDbPrice for row: " + this.key), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + this.tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    public float getDbPrice() {
        TestUtil.logTrace((String)"getDbPrice");
        Connection con = null;
        Statement pStmt = null;
        ResultSet rs = null;
        float dbPrice = 0.0f;
        try {
            con = this.getDBConnection();
            String selectString = TestUtil.getProperty((String)"TxEBean_selectString6");
            pStmt = con.prepareStatement(selectString);
            int theRow = (Integer)this.ectx.getPrimaryKey();
            pStmt.setInt(1, theRow);
            rs = pStmt.executeQuery();
            TestUtil.logTrace((String)"Getting the Price value from the DB");
            if (!rs.next()) {
                throw new EJBException("getDbPrice failed: Row key " + this.key + " not found");
            }
            dbPrice = rs.getFloat(1);
            TestUtil.logTrace((String)("The DB Price is " + dbPrice));
            TestUtil.logTrace((String)("getDbPrice successfully located Row key " + this.key + " and obtained the database Price data!"));
            float f = dbPrice;
            return f;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception from getDbPrice for row: " + this.key), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + this.tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
    }

    public void updateBrandName(String newBrandName) {
        TestUtil.logTrace((String)"updateBrandName");
        try {
            TestUtil.logTrace((String)"Checking for Entity Object");
            int theRow = (Integer)this.ectx.getPrimaryKey();
            TestUtil.logTrace((String)("Row: " + theRow));
            TestUtil.logTrace((String)("tName: " + this.tName));
            if (!this.keyExists(this.tName, theRow)) {
                TestUtil.logTrace((String)("Row: " + theRow + " does not exist"));
                throw new NoSuchEntityException();
            }
            TestUtil.logTrace((String)("Row " + theRow + " exists"));
            TestUtil.logTrace((String)"Updating the brand name");
            this.brand = newBrandName;
        }
        catch (NoSuchEntityException ne) {
            TestUtil.printStackTrace((Throwable)ne);
            throw new NoSuchEntityException("NoSuchEntityException from updateBrandName()");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exeption from updateBrandName()", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public boolean updateBrandName(String newBrandName, int flag) throws AppException {
        TestUtil.logTrace((String)"updateBrandName w/ Exception");
        boolean isRolledback = false;
        try {
            this.brand = newBrandName;
            if (flag == -1) {
                this.throwAppException();
            }
            if (flag == -2) {
                TestUtil.logTrace((String)"calling setRollbackOnly");
                this.ectx.setRollbackOnly();
                TestUtil.logTrace((String)"Calling getRollbackOnly method");
                if (this.ectx.getRollbackOnly()) {
                    isRolledback = true;
                }
                this.throwAppException();
            }
            if (flag == -3) {
                this.throwSysException();
            }
            if (flag == -5) {
                throw new EJBException("EJBException from updateBrandName()");
            }
            if (flag == -6) {
                throw new Error("Error from updateBrandName()");
            }
            if (flag == -7) {
                TestUtil.logTrace((String)"Calling setRollbackOnly method");
                this.ectx.setRollbackOnly();
                TestUtil.logTrace((String)"Calling getRollbackOnly method");
                if (this.ectx.getRollbackOnly()) {
                    isRolledback = true;
                }
            }
        }
        catch (AppException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new AppException("AppException from updateBrandName()");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exeption from updateBrandName()", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        return isRolledback;
    }

    public boolean updateBrandNameRB(String newBrandName, int flag) throws AppException {
        TestUtil.logTrace((String)"updateBrandNameRB");
        boolean isRolledback = false;
        try {
            this.brand = newBrandName;
            if (flag == -2) {
                TestUtil.logTrace((String)"calling setRollbackOnly");
                this.ectx.setRollbackOnly();
                TestUtil.logTrace((String)"Calling getRollbackOnly method");
                if (this.ectx.getRollbackOnly()) {
                    isRolledback = true;
                    TestUtil.logTrace((String)("Tx isRolledBack " + isRolledback));
                }
                this.throwAppException();
            }
            if (flag == -7) {
                TestUtil.logTrace((String)"Calling setRollbackOnly method");
                this.ectx.setRollbackOnly();
                TestUtil.logTrace((String)"Calling getRollbackOnly method");
                if (this.ectx.getRollbackOnly()) {
                    isRolledback = true;
                    TestUtil.logTrace((String)("Tx isRolledBack " + isRolledback));
                }
            }
        }
        catch (AppException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new AppException("AppException from updateBrandName()");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exeption from updateBrandName()", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        return isRolledback;
    }

    public void updatePrice(float newPriceName) {
        TestUtil.logTrace((String)"updatePrice");
        this.price = newPriceName;
    }

    public void throwAppException() throws AppException {
        TestUtil.logTrace((String)"throwAppException");
        throw new AppException("AppException from TxEBean");
    }

    public void throwSysException() {
        TestUtil.logTrace((String)"throwSysException");
        throw new SysException("SysException from TxEBean");
    }

    public void throwEJBException() {
        TestUtil.logTrace((String)"throwEJBException");
        throw new EJBException("EJBException from TxEBean");
    }

    public void throwError() {
        TestUtil.logTrace((String)"throwError");
        throw new Error("Error from TxEBean");
    }

    public void throwRemoveException() throws RemoveException {
        TestUtil.logTrace((String)"throwRemoveException");
        throw new RemoveException("RemoveException from TxEBean");
    }

    private void initLogging(Properties p) throws Exception {
        TestUtil.logTrace((String)"initLogging");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    private Connection getDBConnection() throws SQLException {
        TestUtil.logTrace((String)"getDBConnection");
        this.initSetup();
        Connection con = null;
        try {
            TestUtil.logTrace((String)("tName: " + this.tName));
            con = this.ds1.getConnection();
            TestUtil.logTrace((String)("Made the JDBC connection to " + this.tName));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception connecting to database for " + this.tName), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        TestUtil.logTrace((String)("con: " + con.toString()));
        return con;
    }

    private void createTableLayout() throws SQLException {
        TestUtil.logTrace((String)"createTableLayout");
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getDBConnection();
            stmt = con.createStatement();
            String dropString = TestUtil.getProperty((String)"TxEBean_Delete");
            stmt.executeUpdate(dropString);
            TestUtil.logMsg((String)("Table " + this.tName + " cleared"));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)(this.tName1 + " encountered problem clearing rows!"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException se) {
                TestUtil.printStackTrace((Throwable)se);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean keyExists(String tName, int key) throws SQLException {
        TestUtil.logTrace((String)"keyExists");
        Connection con = null;
        Object stmt = null;
        Statement pStmt = null;
        boolean b = false;
        try {
            con = this.getDBConnection();
            String queryStr = TestUtil.getProperty((String)"TxEBean_queryStr1");
            pStmt = con.prepareStatement(queryStr);
            pStmt.setInt(1, key);
            ResultSet result = pStmt.executeQuery();
            if (result.next()) {
                b = true;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logTrace((String)("Exception from keyExists: " + e.getMessage()));
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException se) {
                TestUtil.logErr((String)("SQLException closing db connection for " + this.tName), (Throwable)se);
                throw new EJBException(se.getMessage());
            }
        }
        return b;
    }

    private void initSetup() {
        try {
            this.ds1 = (DataSource)this.context.lookup("java:comp/env/jdbc/DB1");
            TestUtil.logTrace((String)("ds1: " + this.ds1));
            TestUtil.logTrace((String)"DataSource1 lookup OK!");
            this.tName1 = TestUtil.getTableName((String)TestUtil.getProperty((String)"TxEBean_Delete"));
            TestUtil.logTrace((String)("tName1: " + this.tName1));
            this.tName = this.tName1;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Create exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }
}

