/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.ee.propagation.cm.extended;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.ee.common.A;
import com.sun.ts.tests.jpa.ee.common.Account;
import com.sun.ts.tests.jpa.ee.common.B;
import com.sun.ts.tests.jpa.ee.propagation.cm.extended.Teller;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.Local;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import java.util.List;
import java.util.Properties;

@Stateful(name="TellerBean")
@Local(value={Teller.class})
public class TellerBean
implements Teller {
    public SessionContext sessionContext;
    private static final int[] ACCOUNTS = new int[]{1000, 1075, 40, 30564, 387};
    private static final double[] BALANCES = new double[]{50000.0, 10490.75, 200.5, 25000.0, 1000000.0};
    private Account accountRef;
    @PersistenceContext(type=PersistenceContextType.EXTENDED, unitName="CTS-EXT-UNIT")
    private EntityManager entityManager;

    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @Override
    public double balance(int acct) {
        double balance;
        TestUtil.logTrace((String)"balance");
        Account thisAccount = (Account)this.entityManager.find(Account.class, (Object)acct);
        try {
            balance = thisAccount.balance();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in balance: " + e);
        }
        return balance;
    }

    @Override
    public double deposit(int acct, double amt) {
        double balance;
        TestUtil.logTrace((String)"deposit");
        Account thisAccount = (Account)this.entityManager.find(Account.class, (Object)acct);
        try {
            balance = thisAccount.deposit(amt);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in deposit: " + e);
        }
        return balance;
    }

    @Override
    public double withdraw(int acct, double amt) {
        double balance;
        TestUtil.logTrace((String)"withdraw");
        Account thisAccount = (Account)this.entityManager.find(Account.class, (Object)acct);
        try {
            balance = thisAccount.withdraw(amt);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in withdraw: " + e);
        }
        return balance;
    }

    @Override
    public boolean checkAccountStatus(Account acct) {
        TestUtil.logTrace((String)"checkAccountStatus");
        Account thisAccount = (Account)this.entityManager.find(Account.class, (Object)acct.id());
        return acct.equals((Object)thisAccount);
    }

    @Override
    public boolean checkCustomerStatus(B b) {
        TestUtil.logTrace((String)"checkCustomerStatus");
        boolean pass = false;
        B thisB = (B)this.entityManager.find(B.class, (Object)b.getId());
        if (null == thisB) {
            TestUtil.logErr((String)"checkCustomerStatus: customerB is NULL");
        } else {
            TestUtil.logTrace((String)"checkCustomerStatus: customerB is Not Null, set A");
            A newA = new A("9", "customerA9", 9);
            thisB.setA(newA);
            this.entityManager.merge((Object)thisB);
            this.entityManager.flush();
            pass = true;
        }
        return pass;
    }

    @Override
    public boolean rollbackStatus(B b) {
        TestUtil.logTrace((String)"rollbackStatus");
        boolean pass = false;
        try {
            B thisB = (B)this.entityManager.find(B.class, (Object)b.getId());
            if (null == thisB) {
                TestUtil.logErr((String)"rollbackStatus: customerB is NULL");
            } else {
                TestUtil.logTrace((String)"rollbackStatus: customerB is not Null, setName");
                System.out.println("rollbackStatus: customerB is NOT NULL, set Name");
                thisB.setName("rolledBackB");
                this.entityManager.merge((Object)thisB);
                this.entityManager.flush();
                pass = true;
            }
            TestUtil.logTrace((String)"rollbackStatus - setRollbackOnly so the only outcome is to roll back the changes");
            this.sessionContext.setRollbackOnly();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught in rollbackStatus", (Throwable)e);
            pass = false;
        }
        return pass;
    }

    @Override
    public boolean flushStatus(B b) {
        TestUtil.logTrace((String)"flushStatus");
        boolean pass = false;
        try {
            B thisB = (B)this.entityManager.find(B.class, (Object)b.getId());
            if (null == thisB) {
                TestUtil.logErr((String)"flushStatus: customerB is NULL");
            } else {
                TestUtil.logTrace((String)"flushStatus: customerB is not Null, setName");
                System.out.println("flushStatus: customerB is NOT NULL, set Name");
                thisB.setName("flushB");
                this.entityManager.merge((Object)thisB);
                this.entityManager.flush();
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught in flushStatus", (Throwable)e);
            pass = false;
        }
        return pass;
    }

    @Override
    public String getAllAccounts() {
        StringBuffer accounts = new StringBuffer();
        try {
            List result = this.entityManager.createQuery("select a from Account a").getResultList();
            for (Account a1 : result) {
                accounts.append(a1.id() + "  " + a1.balance() + "\n");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in getAllAccounts: " + e);
        }
        return accounts.toString();
    }

    @Override
    public void createTestData() {
        try {
            TestUtil.logTrace((String)"createTestData");
            TestUtil.logTrace((String)"Create 5 Account Entities");
            for (int i = 0; i < ACCOUNTS.length; ++i) {
                TestUtil.logTrace((String)("Creating account=" + ACCOUNTS[i] + ", balance=" + BALANCES[i]));
                System.out.println("Creating account=" + ACCOUNTS[i] + ", balance=" + BALANCES[i]);
                this.accountRef = new Account(Integer.valueOf(ACCOUNTS[i]), BALANCES[i]);
                this.entityManager.persist((Object)this.accountRef);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected while creating test data:", (Throwable)e);
        }
    }

    @Override
    public void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        try {
            this.entityManager.createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.entityManager.createNativeQuery("DELETE FROM ACCOUNT").executeUpdate();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        TestUtil.logTrace((String)"Clearing cache");
        this.entityManager.getEntityManagerFactory().getCache().evictAll();
        TestUtil.logTrace((String)"TellerBean: cleanup complete");
    }

    @Override
    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

