/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.tx.cm.stateful.sessionsync;

import com.sun.ts.tests.ejb30.common.statussingleton.StatusSingletonBean;
import jakarta.annotation.Resource;
import jakarta.ejb.AfterBegin;
import jakarta.ejb.AfterCompletion;
import jakarta.ejb.BeforeCompletion;
import jakarta.ejb.EJB;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.interceptor.ExcludeDefaultInterceptors;

@Stateful
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
@ExcludeDefaultInterceptors
public class RollbackBean {
    @EJB
    private StatusSingletonBean statusSingleton;
    @Resource
    private SessionContext sctx;
    private String currentTest;
    private Boolean transactionStatus;

    public boolean getAndResetTransactionStatus() {
        boolean result = this.transactionStatus;
        this.transactionStatus = null;
        return result;
    }

    public void rollback() {
        if (this.currentTest == null) {
            return;
        }
        if (this.currentTest.equals(TestNames.methodException.toString())) {
            throw new RuntimeException("from businessMethod.");
        }
        if (this.currentTest.equals(TestNames.methodSetRollbackOnly.toString())) {
            this.sctx.setRollbackOnly();
        }
    }

    @AfterBegin
    private void afterBegin() {
        this.currentTest = this.statusSingleton.getAndResetResult(TestNames.currentTestKey.toString());
        if (this.currentTest == null) {
            return;
        }
        if (this.currentTest.equals(TestNames.afterBeginException.toString())) {
            throw new RuntimeException("from afterBegin callback.");
        }
        if (this.currentTest.equals(TestNames.afterBeginSetRollbackOnly.toString())) {
            this.sctx.setRollbackOnly();
        }
    }

    @BeforeCompletion
    private void beforeCompletion() {
        if (this.currentTest == null) {
            return;
        }
        if (this.currentTest.equals(TestNames.beforeCompletionException.toString())) {
            throw new RuntimeException("from beforeCompletion callback.");
        }
        if (this.currentTest.equals(TestNames.beforeCompletionSetRollbackOnly.toString())) {
            this.sctx.setRollbackOnly();
        }
    }

    @AfterCompletion
    private void afterCompletion(boolean b) {
        if (this.currentTest == null) {
            return;
        }
        this.transactionStatus = b;
        String currentTestSave = this.currentTest;
        this.currentTest = null;
        if (currentTestSave.equals(TestNames.afterCompletionException.toString())) {
            throw new RuntimeException("from afterCompletion callback.");
        }
    }

    static enum TestNames {
        currentTestKey,
        isTxCommittedKey,
        methodSetRollbackOnly,
        methodException,
        afterBeginSetRollbackOnly,
        afterBeginException,
        beforeCompletionSetRollbackOnly,
        beforeCompletionException,
        afterCompletionException;

    }
}

